package cn.smarthse.tt.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName SpecialistOperateRecordVo
 * @Description 专家信息变更记录查询结果对象
 * @Author 曾华川
 * @Date 2024年05月20日 15:44
 **/
@Data
public class SpecialistOperateRecordVo implements Serializable {

    private static final long serialVersionUID = -372008696867349893L;
    private Long id;

    @ApiModelProperty("专家id")
    private Long specialistId;

    @ApiModelProperty("操作类型（1-新增，2-编辑，3-出入库）")
    private Integer type;

    @ApiModelProperty("操作人类型（1-专家端操作，2-监管端或运维端）")
    private Integer operatorType;

    @ApiModelProperty("操作人姓名")
    private String operator;

    @ApiModelProperty("变更之前的内容")
    private String changeBefore;

    @ApiModelProperty("变更之后的内容")
    private String changeAfter;

    @ApiModelProperty("创建时间")
    private Date createDate;
}
