package cn.smarthse.tt.vo;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.db.common.entity.BaseEntity;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.tt.enums.SpecialistExpertiseAreaEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.sourceforge.pinyin4j.PinyinHelper;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 专家信息返回对象
 * @Title: SpecialistInfoVo
 * @Author zhangt
 * @Date: 2024/2/26 10:35
 */
@Data
public class SpecialistInfoVo extends BaseEntity {

    /**
     * 专家id
     */
    @ApiModelProperty("专家ID")
    private Long id;

    /**
     * 照片文件ID(file.id)
     */
    @ApiModelProperty("照片文件ID(file.id)")
    private Long faceId;

    /**
     * 照片附件
     */
    @ApiModelProperty("照片附件")
    private SysFileModel face;

    /**
     * 姓名
     */
    @ApiModelProperty("专家姓名")
    private String fullname;

    @ApiModelProperty("专家姓名首字母")
    private Character fullnameInitial;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String userMobile;

    /**
     * 所在单位ID
     */
    @ApiModelProperty("专家所在单位ID")
    private Long cid;

    /**
     * 所在单位名称
     */
    @ApiModelProperty("所在单位名称")
    private String companyName;

    /**
     * 擅长领域--枚举
     */
    @ApiModelProperty("擅长领域")
    private String expertiseArea;

    /**
     * 擅长领域枚举--字符串
     */
    private List<String> expertiseAreaStr = new ArrayList<>();

    /**
     * 专业技术职称/职务
     */
    @ApiModelProperty("技术职称")
    private String jobTitle;


    /**
     * 专家类别（1 第一响应专家(市级)、2 第二响应专家(省级))
     */
    @ApiModelProperty("专家类别（1 第一响应专家(市级)、2 第二响应专家(省级))")
    private Byte type;

    private String typeStr;

    /**
     * 所在地区域ID(单位所在地)
     */
    @ApiModelProperty("所在区域ID")
    private Long areaId;

    /**
     * 单位区域
     */
    private AreaModel areaModel;

    /**
     * 详细所在地(单位所在地)
     */
    @ApiModelProperty("详细所在地")
    private String areaAddress;

    /**
     * 专家简介
     */
    @ApiModelProperty("专家简介")
    private String info;

    @ApiModelProperty("最大回答问题数")
    private Integer maximum;
    /**
     * 当天回答问题数量
     */
    @ApiModelProperty("当天回答问题数量")
    private Integer replyNum;

    /**
     * 当天是否可回答
     */
    @ApiModelProperty("当天是否可回答")
    private Boolean canReply;

    /**
     * 是否入库（0-出库，1-入库）
     */
    @ApiModelProperty(value = "是否入库（0-出库，1-入库）")
    private Boolean isEntering;

    @ApiModelProperty("数据是否有效")
    private Boolean isValid;

    private String isEnteringStr;
    @ApiModelProperty("未响应次数")
    private Integer noResponseCount = 0;

    @ApiModelProperty("响应问题数")
    private Integer responseCount;

    /**
     * 已完成服务次数
     *
     * @return
     */
    @ApiModelProperty("完成问题数")
    private Integer answerCount = 0;

    @ApiModelProperty("接收问题数")
    private Integer receiveCount;

    @ApiModelProperty("是否是兜底专家")
    private Boolean isFallback;


    public List<String> getExpertiseAreaStr() {
        List<String> expertiseAreas = new ArrayList<>();

        if (this.expertiseArea != null && !this.expertiseArea.isEmpty()) {
            String[] codes = this.expertiseArea.split(Constants.SPLIT_CHAR);

            for (String code : codes) {
                String name = SpecialistExpertiseAreaEnum.getName(code.trim());
                if (name != null && !name.isEmpty()) {
                    expertiseAreas.add(name);
                }
            }
        }

        return expertiseAreas;
    }


    public String getTypeStr(){
        if (this.type != null && this.type == 1){
            return "第一响应专家";
        } else if (this.type != null && this.type == 2) {
            return "第二响应专家";
        }else {
            return "--";
        }
    }

    public String getIsEnteringStr(){
        if(this.isEntering != null && this.isEntering == true){
            return "入库专家";
        } else if (this.isEntering != null && this.getIsEntering() == false) {
            return "出库专家";
        }else {
            return "--";
        }
    }

    public Character getFullnameInitial(){
        // 获取姓名的拼音数组
        String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray(this.fullname.charAt(0));

        if (pinyinArray != null && pinyinArray.length > 0) {
            // 获取首字母
            return pinyinArray[0].charAt(0); // 转换为大写
        } else {
            // 如果没有找到拼音，则直接取姓名的首个字符
            return this.fullname.charAt(0);
        }
    }


}
