package cn.smarthse.tt.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import lombok.Data;

import java.io.Serializable;

/**
 * 专家列表数据导出
 * @Title: SpecialistInfoExportVo
 * @Author zhangt
 * @Date: 2024/6/3 20:59
 */
@HeadRowHeight(20)
@ContentRowHeight(20)
@ColumnWidth(25)
@Data
public class SpecialistInfoExportVo implements Serializable {

    private static final long serialVersionUID = 3422515121835026402L;

    @ExcelProperty("专家名称")
    private String fullname;

    @ExcelProperty("所在单位名称")
    private String companyName;

    @ExcelProperty("擅长领域")
    private String expertiseAreaStr;

    @ExcelProperty("技术职称")
    private String jobTitle;

    @ExcelProperty("未响应次数")
    private Integer noResponseCount = 0;

    @ExcelProperty("完成问题数")
    private Integer answerCount = 0;
}
