package cn.smarthse.tt.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * 直通车工作统计--区域统计VO
 * @Title: SpecialistCountVo
 * @Author zhangt
 * @Date: 2024/5/28 15:24
 */
@Data
@ApiModel("直通车工作统计--区域统计VO")
public class SpecialistCountVo implements Serializable {
    private static final long serialVersionUID = -2813862365966008334L;

    /**
     * 区域ID
     */
    @ApiModelProperty("区域ID")
    private Long areaId;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    private String areaName;
    /**
     * 区域等级
     */
    @ApiModelProperty("区域等级")
    private Byte areaLevel;

    private LocalDateTime updateDate;

    @ApiModelProperty("最近更新时间")
    private String updateDateStr;

    @ApiModelProperty("系统接收问题数")
    private Integer sysReceiveNum = 0;

    @ApiModelProperty("专家总数")
    private Integer specialistNum = 0;

    @ApiModelProperty("接收问题数")
    private Integer receiveNum = 0;

    @ApiModelProperty("专家问题完成数")
    private Integer answerNum = 0;



    @ApiModelProperty("未响应问题数")
    private Integer noResponseCount = 0;

    @ApiModelProperty("响应率")
    private String responsivity;

    @ApiModelProperty("数据年份")
    private String dataType;

    @ApiModelProperty("统计截止日期")
    private String closeDate;



    public String getUpdateDateStr() {
        if (updateDate == null) {
            return "-";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return updateDate.format(formatter);
    }

}
