package cn.smarthse.tt.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description:
 * @Title: SpecialistCountExportVo
 * @Author zhangt
 * @Date: 2024/5/29 15:43
 */
@HeadRowHeight(20)
@ContentRowHeight(20)
@ColumnWidth(25)
@Data
public class SpecialistCountExportVo implements Serializable {

    private static final long serialVersionUID = 3422515121835026402L;

    @ExcelProperty("行政区划")
    private String areaName;

    @ExcelProperty(value = "本级专家数")
    private Integer specialistNum = 0;

    @ExcelProperty("接收问题数")
    private Integer receiveNum = 0;

    @ExcelProperty("未响应问题数")
    private Integer noResponseCount = 0;

    @ExcelProperty("在线问诊响应率")
    private String responsivity;
}
