package cn.smarthse.tt.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description:
 * @Title: SpecialistCountDetailVo
 * @Author zhangt
 * @Date: 2024/5/28 17:58
 */
@Data
@ApiModel("直通车工作统计详情")
public class SpecialistCountDetailVo implements Serializable {

    @ApiModelProperty("专家ID")
    private Long id;

    @ApiModelProperty("专家名称")
    private String fullname;

    @ApiModelProperty("专家库状态 0出库 1入库")
    private Boolean isEntering;

    private String isEnteringStr;

    @ApiModelProperty("接收问题数量")
    private Integer receiveCount = 0;

    @ApiModelProperty("解答问题数")
    private Integer answerCount = 0;

    @ApiModelProperty("响应问题数")
    private Integer responseCount = 0;

    @ApiModelProperty("未响应问题")
    private Integer noResponseCount = 0;

    public String getIsEnteringStr(){
        if(this.getIsEntering() != null && this.getIsEntering() == true){
            return "入库专家";
        } else if (this.getIsEntering() != null && this.getIsEntering() == false) {
            return "出库专家";
        }else {
            return "--";
        }
    }

}
