package cn.smarthse.tt.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description:
 * @Title: SpecialistCountDetailExportVo
 * @Author zhangt
 * @Date: 2024/5/29 17:17
 */
@HeadRowHeight(20)
@ContentRowHeight(20)
@ColumnWidth(25)
@Data
public class SpecialistCountDetailExportVo implements Serializable {

    private static final long serialVersionUID = 3422515121835026402L;

    @ExcelProperty("专家名称")
    private String fullname;

    @ExcelProperty("专家库状态")
    private String isEnteringStr;

    @ExcelProperty("接收问题数")
    private Integer receiveCount = 0;

    @ExcelProperty("完成问题数")
    private Integer answerCount = 0;

    @ExcelProperty("响应问题数")
    private Integer responseCount = 0;
}
