package cn.smarthse.tt.provider.supervise;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.tt.model.SpecialistQuickQuestionModel;
import cn.smarthse.tt.vo.SpecialistQuickQuestionVo;
import com.github.pagehelper.PageInfo;
import javafx.util.Pair;

public interface ISpecialistQuickQuestionProviderToSupervise {

    /**
     * @description: 监管端，查询提问分页
     * @version: 卫企快车
     * @date: 2024-05-21 9:18
     * @param: 传参说明：
     * 		pageParam -> 分页参数
     * 		queParam ->  提问参数
     * @return: {@link PageInfo<SpecialistQuickQuestionVo>} 提问分页
     * @author: DengJia 18402894534@163.com
     */
    PageInfo<SpecialistQuickQuestionVo> getSpecialistQuestionPage(JqGridParam pageParam, SpecialistQuickQuestionModel queParam);

    /**
     * @description: 监管端，提出问题
     * @version: 卫企快车
     * @date: 2024-05-29 10:24
     * @param: 传参说明：
     *      queParam -> 问题参数
     * @return: {@link Pair<Integer, String>} 提问结果
     * @author: DengJia 18402894534@163.com
     */
    Pair<Integer, String> askQuestion(SpecialistQuickQuestionModel queParam);

    /**
     * @description: 监管端，完成问题
     * @version: 卫企快车
     * @date: 2024-05-30 22:34
     * @param: 传参说明：
     *      queParam -> 包含问题id参数
     * @return: void
     * @author: DengJia 18402894534@163.com
     */
    void finishQuestion(SpecialistQuickQuestionModel queParam);
}
