package cn.smarthse.tt.provider.supervise;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.tt.model.SpecialistQuickCommunicateModel;
import cn.smarthse.tt.vo.SpecialistQuickCommunicateVo;

import java.util.List;

public interface ISpecialistQuickCommunicateProviderToSupervise {

    /**
     * @description: 监管端，查询交流回复列表
     * @version: 卫企快车
     * @date: 2024-05-24 9:56
     * @param: 传参说明：
     *      commParam -> 包含提问id、专家id参数
     * @return: {@link ResponseData<List<SpecialistQuickCommunicateVo>>} 交流回复列表
     * @author: DengJia 18402894534@163.com
     */
    List<SpecialistQuickCommunicateVo> getSpecialistCommunicateList(SpecialistQuickCommunicateModel commParam);

    /**
     * @description: 监管端，交流回复
     * @version: 卫企快车
     * @date: 2024-05-29 11:43
     * @param: 传参说明：
     * 		commParam -> 回复参数
     * @return: void
     * @author: DengJia 18402894534@163.com
     */
    void doReply(SpecialistQuickCommunicateModel commParam);
}
