package cn.smarthse.tt.provider.supervise;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.tt.dto.SpecialistInfoDto;
import cn.smarthse.tt.entity.ReplyTemplate;
import cn.smarthse.tt.entity.SpecialistParam;
import cn.smarthse.tt.model.*;
import cn.smarthse.tt.vo.*;
import com.github.pagehelper.PageInfo;

import java.io.IOException;
import java.util.List;

public interface ISpecialistInfoProviderToSupervise {

    /**
     * 查询专家详情信息
     * @param id
     * @return
     */
    SpecialistInfoVo getSpecialistInfoById(Long id, Boolean isMaintenance);

    /**
     * 查询专家列表
     * @param model
     * @return
     */
    PageInfo<SpecialistInfoVo> getSpecialistInfoList(SpecialistInfoModel model);

    /**
     * 新增/保存专家信息
     *
     * @param dto
     * @param operatorType  操作人类型（1-专家端操作，2-监管端或运维端）
     * @param userId
     */
    void saveSpecialistInfo(SpecialistInfoDto dto, Integer operatorType, Long userId);

    /**
     * 修改出入库状态
     * @param id
     * @param userId
     * @return
     */
    ResponseData<String> editEnteringStatus(Long id, Long userId);

    /**
     * 区域统计
     * @param model
     * @return
     */
    SpecialistCountVo getResponsivityData(SpecialistCountModel model);

    /**
     * 统计各市
     * @param model
     * @return
     */
    JqGridData<SpecialistCountVo> getResponsivityListData(SpecialistCountModel model);


    /**
     * 专家统计详情
     * @param model
     * @return
     */
    JqGridData<SpecialistCountDetailVo> getResponsivityDetail(SpecialistCountModel model);

    /**
     * 专家信息变更记录
     *
     * @param specialistId
     * @param page
     * @return
     */
    PageInfo<SpecialistOperateRecordVo> getOperateList(Long specialistId, JqGridParam page);

    /**
     * 问题移交记录
     * @param questionId
     * @return
     */
    List<SpecialistQuestionRecordVo> getTransferList(Long questionId);

    /**
     * 修改直通车系统参数
     * @param model
     * @param userId
     */
    void saveSysParam(SpecialistModel model, Long userId);

    /**
     * 查询直通车系统参数
     * @return
     */
    List<SpecialistParam> sysParamList();

    /**
     * 专家条件查询问题列表
     *
     * @param pageParam 分页入参
     * @param queParam  问题查询参数
     * @return 问题分页列表
     */
    PageInfo<SpecialistQuickQuestionVo> getQuestionListBySearch(JqGridParam pageParam, SpecialistQuickQuestionModel queParam);

    /**
     * 问题详情
     *
     * @param id 问题id
     * @return 问题
     */
    SpecialistQuickQuestionVo getQuestionInfo(Long id, Long specialistId);

    /**
     * 回复模版列表
     *
     * @param specialistId
     * @return
     */
    List<ReplyTemplate> getPageList(Long specialistId);

    /**
     * 收藏回复
     *
     * @param model
     */
    void addTemplateList(ReplyTemplateModel model);

    /**
     * 取消收藏
     *
     * @param model
     */
    void deleteTemplateList(ReplyTemplateModel model);

    /**
     * 专家信息导入
     *
     * @param file
     * @param operatorType – 操作人类型（1-专家端操作，2-监管端或运维端）
     * @param userId
     */
    ResponseData<String> importSpecialist(SysFileModel file, Integer operatorType, Long userId) throws IOException;

    /**
     * 问题最新匹配的专家信息
     * @param questionId
     * @return
     */
    SpecialistInfoVo getLatestSpecialistInfo(Long questionId);

    /**
     * 删除专家信息
     * @param specialistId
     */
    void delSpecialistInfo(Long specialistId);

    PageInfo<SpecialistActiveVo> specialistActive(SpecialistActiveParam param);

    /**
     * 修改专家隐藏状态
     * @param id
     * @param userId
     * @return
     */
    ResponseData<String> editIsvalidStatus(Long id, Long userId);

    ResponseData<String> editFallbackStatus(Long id, Long userId);
}
