package cn.smarthse.tt.model;

import cn.smarthse.tt.entity.sys.SpecialistUser;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 卫企直通车问题表 Model
 */

@Data
public class SpecialistQuickQuestionModel implements Serializable {

    private static final long serialVersionUID = -5787065389649252224L;

    /**
     * 主键id；问题id
     */
    private Long id;

    /**
     * 问题id
     */
    private Long questionId;

    /**
     * 行政区划id
     */
    private Long regionId;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 是否专家角色查询问题列表（true专家 false普通用户）
     */
    private Boolean isSpecialist;

    /**
     * 提问人id
     */
    private Long askId;

    /**
     * 向此专家发起提问
     */
    private Long expertId;

    /**
     * 提问人姓名
     */
    private String askName;

    /**
     * 问题标题
     */
    private String title;

    /**
     * 提问人姓名或问题标题
     */
    private String keyword;

    /**
     * 问题描述
     */
    private String content;

    /**
     * 问题文件；文件id，若多个逗号分隔
     */
    private String file;

    /**
     * 问题类型/擅长领域（单选）；参考SpecialistExpertiseAreaEnum
     */
    private Integer type;

    /**
     * 问题状态；1-未完成，2-已完成，3-已无效，4-待响应，5-未响应，6-已移交（专业领域不符合），7-已移交（无法回答）
     */
    private Integer status;

    /**
     * 问题属性（1-智能匹配，2-用户指定）
     */
    private Byte property;

    /**
     * 记录专家最后一次回复时间
     */
    private LocalDateTime lastReplyTime;

    /**
     * 根据专家最后一次回复时间，计算问题自动关闭时间
     */
    private LocalDateTime autoCloseTime;

    /**
     * 问题,专家/用户,关联
     */
    private SpecialistUser user;
}
