package cn.smarthse.tt.model;

import cn.smarthse.tt.entity.sys.SpecialistUser;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 卫企直通车交流表 Model
 */

@Data
public class SpecialistQuickCommunicateModel implements Serializable {

    private static final long serialVersionUID = -612399129454062162L;

    /**
     * 主键id；交流id
     */
    private Long id;

    /**
     * 问题id；quick_question.id
     */
    private Long questionId;

    /**
     * 是否专家角色查询交流回复记录（false普通用户 true专家）
     */
    private Boolean isSpecialist;

    /**
     * 专家id（specialist_info.id），从问题列表跳过来的那个专家的id，也表示此回复归属于此专家。
     */
    private Long specialistId;

    /**
     * specialistId视角下的历史移交专家id集合（包括其本身）
     */
    private List<Long> specialistIdList;

    /**
     * 类型；0系统消息1用户回复2专家回复
     */
    private Integer type;

    /**
     * 回复人员id（用户或专家）
     */
    private Long personId;

    /**
     * 交流内容
     */
    private String content;

    // /**
    //  * 收藏模板id specialist.reply_template.id
    //  */
    // private Long replyTemplateId;

    /**
     * 回复,专家/用户,关联
     */
    private SpecialistUser user;

    /**
     * 用户来源（cn.smarthse.modules.health.supervise.enums.sys.UserFromEnum）
     */
    private Byte userFrom;

    /**
     * 当前登录用户的账号名称
     */
    private String loginAccountUserName;
}
