package cn.smarthse.tt.model;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.tt.constants.SpecialistConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName SpecialistInfoModel
 * @Description 直通车工作统计表
 * @Author zhangt
 * @Date 2024年6月11日16:42:47
 **/
@Data
public class SpecialistInfoModel extends JqGridParam {

    private Long areaId;
    private Byte areaLevel;

    @ApiModelProperty("是否是仅本级")
    private Boolean isCurrent = false;

    @ApiModelProperty("擅长领域")
    private String expertiseArea;

    @ApiModelProperty("专家名称")
    private String fullname;

    /**
     * 查省本级的时候查询2
     */
    @ApiModelProperty("专家类别 1 市级专家  2 省级专家")
    private Byte type;

    /**
     * 专家库状态：0-出库，1-入库
     */
    @ApiModelProperty("专家库状态：0-出库，1-入库")
    private Boolean isEntering;

    @ApiModelProperty("是否是运维")
    private Boolean isMaintenance;

    @ApiModelProperty("是否包含系统专家")
    private Boolean hasSysSpecialist;

    @ApiModelProperty("系统专家ID")
    private Long sysSpecialistId = SpecialistConstants.SYS_SPECIALIST_ID;

    @ApiModelProperty("排序方式(升序：ASC 降序：DESC)")
    private String sort = "ASC";

    @ApiModelProperty("排序字段(完成问题数:answerCount  未响应问题数: noResponseCount)")
    private String sortField = "answerCount";
}
