package cn.smarthse.tt.model;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName SpecialistCountModel
 * @Description 直通车工作统计表
 * @Author zhangt
 * @Date 2024年5月28日14:42:48
 **/
@Data
public class SpecialistCountModel extends JqGridParam {


    /**
     * 搜索区域ID
     */
    @ApiModelProperty("搜索区域ID")
    private Long areaId;

    @ApiModelProperty("搜索区域等级")
    private Byte areaLevel;

    @ApiModelProperty("搜索区域名称")
    private String areaName;

    /**
     * 关键字查询
     */
    private String keyword;

    /**
     * 默认查询1  查省本级的时候查询2
     */
    @ApiModelProperty("专家类别 1 市级专家  2 省级专家")
    private Byte type = 1;

    /**
     * 专家库状态：0-出库，1-入库
     */
    @ApiModelProperty("专家库状态：0-出库，1-入库")
    private Boolean isEntering;

    /**
     * 查询备份数据
     */
    private String queryBak;

    @ApiModelProperty("排序方式(升序：ASC 降序：DESC)")
    private String sort = "ASC";

    @ApiModelProperty("排序字段(接收问题数:receiveNum  未响应问题数: noResponseCount 在线问诊响应率:responsivity)")
    private String sortField = "areaId";
}
