package cn.smarthse.tt.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import java.util.Objects;

/**
 * @Author: DengJia
 * @Date: 2024-05-20 22:09
 * @Description: 问题状态枚举
 */

@Getter
@AllArgsConstructor
public enum SpecialistQuestionStatusEnum {

    UNCOMPLETED(1, "未完成"),
    COMPLETED(2, "已完成"),
    INVALID(3, "已无效"),
    WAIT_RESPONSE(4, "待响应"),
    NO_RESPONSE(5, "未响应"),

    // 以下状态未存数据库
    TRANSFERRED_MAJOR(6, "已移交（专业领域不符合）"),
    TRANSFERRED_ANSWER(7, "已移交（无法回答）"),
    ;

    private final Integer key;
    private final String value;

    public static String getValue(Integer key) {
        if (key == null) {
            return null;
        }
        for (SpecialistQuestionStatusEnum type : SpecialistQuestionStatusEnum.values()) {
            if (Objects.equals(key, type.getKey())) {
                return type.getValue();
            }
        }
        return null;
    }
}
