package cn.smarthse.tt.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 技术职称枚举
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SpecialistJobTitleEnum {


    RESEARCHER("研究员", "1"),
    ASSOCIATE_RESEARCHER("副研究员", "2"),
    CHIEF_PHYSICIAN("主任医师", "3"),
    DEPUTY_CHIEF_PHYSICIAN("副主任医师", "4"),
    CHIEF_TECHNICIAN("主任技师", "5"),
    DEPUTY_CHIEF_TECHNICIAN("副主任技师", "6"),
    SENIOR_ENGINEER_RESEARCHER("研究员级高级工程师", "7"),
    PROFESSOR_ENGINEER("教授级工程师", "8"),
    SENIOR_ENGINEER("正高级工程师", "9"),
    SENIOR_ENGINEER_GENERAL("高级工程师", "10"),
    CHIEF_PHARMACIST("主任药师", "11"),
    DEPUTY_CHIEF_PHARMACIST("副主任药师", "12"),
    PROFESSOR("教授", "13"),
    ASSOCIATE_PROFESSOR("副教授", "14"),
    SENIOR_EXPERIMENTALIST("正高级实验师", "15"),
    OTHER("其他", "16"),
    NONE("无", "17"),
    ;

    // 成员变量
    private String name;
    private String code;
    // 构造方法

    private SpecialistJobTitleEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    // 普通方法
    public static String getName(String code) {
        if (code == null) {
            return SpecialistJobTitleEnum.NONE.name;
        }
        for (SpecialistJobTitleEnum c : SpecialistJobTitleEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return SpecialistJobTitleEnum.NONE.name;
    }

    // 普通方法
    public static String getCode(String name) {
        if (name == null) {
            return "";
        }
        for (SpecialistJobTitleEnum c : SpecialistJobTitleEnum.values()) {
            if (c.getName().equals(name)) {
                return c.code;
            }
        }
        return "";
    }


    public static String getCodeByName(String unitName) {
        if (unitName == null || unitName.length() == 0) {
            return null;
        }
        for (SpecialistJobTitleEnum c : SpecialistJobTitleEnum.values()) {
            if (c.getName().equals(unitName)) {
                return c.code;
            }
        }
        return null;
    }

    // get set 方法
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
