package cn.smarthse.tt.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 擅长领域枚举
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum SpecialistExpertiseAreaEnum {


    OCC_HEALTH_SUP_LAW("职业健康监督执法", "0"),
    EVALUATION("职业卫生检测与评价", "1"),
    RADIATION_HEALTH("放射卫生", "2"),
    DEVICE("职业卫生工程防护", "3"),
    CHECK("职业健康检查", "4"),
    DISEASE_DIAGNOSIS("职业病诊断与鉴定", "5");

    // 成员变量
    private String name;
    private String code;
    // 构造方法

    private SpecialistExpertiseAreaEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    // 普通方法
    public static String getName(String code) {
        if (code == null) {
            return "";
        }
        for (SpecialistExpertiseAreaEnum c : SpecialistExpertiseAreaEnum.values()) {
            if (c.getCode().equals(code)) {
                return c.name;
            }
        }
        return "";
    }

    // 普通方法
    public static String getCode(String name) {
        if (name == null) {
            return "";
        }
        for (SpecialistExpertiseAreaEnum c : SpecialistExpertiseAreaEnum.values()) {
            if (c.getName().equals(name)) {
                return c.code;
            }
        }
        return "";
    }


    public static String getCodeByName(String unitName) {
        if (unitName == null || unitName.length() == 0) {
            return null;
        }
        for (SpecialistExpertiseAreaEnum c : SpecialistExpertiseAreaEnum.values()) {
            if (c.getName().equals(unitName)) {
                return c.code;
            }
        }
        return null;
    }

    // get set 方法
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
