package cn.smarthse.tt.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @ClassName QuestionTransferShowEnum
 * @Description 问题移交记录显示内容枚举
 * @Author 曾华川
 * @Date 2024年06月05日 18:03
 **/
@Getter
@AllArgsConstructor
public enum QuestionTransferShowEnum {

    CREATE(0, "创建问题"),
    MATCH(1, "问题分配至"),
    NO_RESPONSE(2, "问题未响应"),
    TRANSFER(3, "问题移交至"),
    COMPLETE(4, "问题已完成"),
    INVALID(5, "问题已无效"),
    ;

    private Integer code;
    private String content;

    public static String getContent(Integer code) {
        for (QuestionTransferShowEnum value : QuestionTransferShowEnum.values()) {
            if (value.getCode().equals(code)) {
                return value.getContent();
            }
        }
        return null;
    }
}
