package cn.smarthse.tt.entity.sys;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 卫企预约用户
 *
 * @TableName wqyy_user
 */
@TableName(value = "sys_user")
@Data
public class SysUser implements Serializable {
    /**
     * ID
     */
    @TableId(value = "id")
    private Long id;

    /**
     * 所属企业编号
     */
    @TableField(value = "cid")
    private Long cid;

    /**
     * 用户名
     */
    @TableField(value = "username")
    private String username;
    @TableField(exist = false)
    private String name;// todo 临时处理，前端提交审核了，他们不方便改

    /**
     * 登录加密密码（SHA-1）
     */
    @TableField(value = "password")
    private String password;

    /**
     * 登录盐值
     */
    @TableField(value = "salt")
    private String salt;

    /**
     * 头像文件编号（file.id)
     */
    @TableField(value = "face_id")
    private Long faceId;

    /**
     * 用户姓名
     */
    @TableField(value = "fullname")
    private String fullname;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField(value = "is_valid")
    private Boolean isValid;

    /**
     * 是否管理员
     */
    @TableField(value = "is_manger")
    private Boolean isManger;

    /**
     * 是否禁用
     */
    @TableField(value = "is_forbidden")
    private Boolean isForbidden;

    /**
     * 启用/禁用时间（is_forbidden=1 表示禁用时间）
     */
    @TableField(value = "forbidden_update_time")
    private Date forbiddenUpdateTime;

    /**
     * 最近登录时间
     */
    @TableField(value = "last_login_time")
    private Date lastLoginTime;

    /**
     * 是否是默认密码
     */
    @TableField(value = "is_default_pwd")
    private Boolean isDefaultPwd;

    /**
     * 创建人
     */
    @TableField(value = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @TableField(value = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @TableField(value = "update_date")
    private Date updateDate;

    /**
     * 关联的员工编号
     */
    @TableField(value = "staff_id")
    private Long staffId;

    /**
     * 手机号码
     */
    @TableField(value = "mobile")
    private String mobile;

    /**
     * 政务服务网账户唯一标识
     */
    @TableField(value = "zlb_user_id")
    private String zlbUserId;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}