package cn.smarthse.tt.entity.sys;

import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @Description:
 * @Title: SpecialistUser
 * @Author zhangt
 * @Date: 2024/5/30 14:51
 */
@TableName(value = "specialist_user")
@Data
public class SpecialistUser extends BaseEntity {

    @TableId
    private Long id;

    /**
     * 浙里办主键
     */
    @TableField("user_id")
    private String userId;

    /**
     * 个人姓名
     */
    @TableField("user_name")
    private String username; // todo 前端要读取这个字段  但是不方便改成小驼峰


    /**
     * 手机号码
     */
    @TableField("phone")
    private String phone;

    /**
     * 是否是专家(0-普通用户，1-专家)
     */
    @TableField("is_specialist")
    private Boolean isSpecialist;

    @TableField("specialist_id")
    private Long specialistId;

    @ApiModelProperty("是否禁用")
    @TableField("is_forbidden")
    private Integer isForbidden;
    /**
     * 禁用、启用时间
     */
    @ApiModelProperty("禁用、启用时间")
    @TableField("forbidden_date")
    private Date forbiddenDate;

    /**
     * 最后登录时间
     */
    @TableField("last_login_time")
    private LocalDateTime lastLoginTime;


}
