package cn.smarthse.tt.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Id;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 卫企直通车问题表
 */

@Data
@TableName(value = "specialist_quick_question")
@Accessors(chain = true)
public class SpecialistQuickQuestion implements Serializable {

    private static final long serialVersionUID = -5197583629078184165L;

    /**
     * 主键id；问题id
     */
    @Id
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 提问人id
     */
    private Long askId;

    /**
     * 问题标题
     */
    private String title;

    /**
     * 问题描述
     */
    private String content;

    /**
     * 问题文件；文件id，若多个逗号分隔
     */
    private String file;

    /**
     * 问题类型/擅长领域（单选）；参考SpecialistExpertiseAreaEnum
     */
    private Integer type;

    /**
     * 问题状态；1未完成 2已完成 3已无效 4待响应 5未响应
     */
    private Integer status;

    /**
     * 问题属性（1-智能匹配，2-用户指定）
     */
    private Byte property;

    /**
     * 记录专家最后一次回复时间
     */
    private LocalDateTime lastReplyTime;

    /**
     * 根据专家最后一次回复时间，计算问题自动关闭时间
     */
    private LocalDateTime autoCloseTime;

    /**
     * 是否有效；0无效1有效
     */
    private Integer isValid;

    /**
     * 创建人id
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 修改人id
     */
    private Long updatedBy;

    /**
     * 修改时间
     */
    private Date updateDate;

}
