package cn.smarthse.tt.entity;

import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 卫企直通车交流表
 */

@Data
@TableName(value = "specialist_quick_communicate")
@Accessors(chain = true)
public class SpecialistQuickCommunicate implements Serializable {

    private static final long serialVersionUID = 8109873819792637298L;

    /**
     * 主键id；交流id
     */
    @Id
    private Long id;

    /**
     * 问题id；quick_question.id
     */
    private Long questionId;

    /**
     * 专家id（specialist_info.id），从问题列表跳过来的那个专家的id，也表示此回复归属于此专家。
     */
    private Long specialistId;

    /**
     * 类型；0系统消息1用户回复2专家回复
     */
    private Integer type;

    /**
     * 回复人员id（用户或专家）
     */
    private Long personId;

    /**
     * 交流内容
     */
    private String content;

    /**
     * 是否有效；0无效1有效
     */
    private Integer isValid;

    /**
     * 创建人id
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 修改人id
     */
    private Long updatedBy;

    /**
     * 修改时间
     */
    private Date updateDate;

}
