package cn.smarthse.tt.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName SpecialistQuestionRecord
 * @Description 专家和问题的关联记录
 * @Author 曾华川
 * @Date 2024年05月20日 11:28
 **/
@TableName("specialist_question_record")
@Data
public class SpecialistQuestionRecord implements Serializable {

    private static final long serialVersionUID = -6540982758625957027L;
    @TableId
    private Long id;

    /**
     * 问题表id
     */
    @TableField("question_id")
    private Long questionId;

    /**
     * 移交问题的专家id
     */
    @TableField("transfer_specialist_id")
    private Long transferSpecialistId;

    /**
     * 接收问题的专家id
     */
    @TableField("receive_specialist_id")
    private Long receiveSpecialistId;

    /**
     * 是否为历史记录（0-否，1-是）
     */
    @TableField("is_history")
    private Boolean isHistory;

    /**
     * 移交类型（1-专家手动移交，2-超时移交，系统自动移交）
     */
    @TableField("transfer_type")
    private Integer transferType;

    /**
     * 移交原因的类别（1-不符合专业领域，2-无法回答，3-超时未响应）
     */
    @TableField("reason_type")
    private Integer reasonType;

    /**
     * 专家领域类型（枚举）
     */
    @TableField("specialist_field_type")
    private Integer specialistFieldType;

    /**
     * 移交理由
     */
    @TableField("reason")
    private String reason;

    /**
     * 未响应的截止时间，根据该时间进行倒计时
     */
    @TableField("no_response_time")
    private Date noResponseTime;

    /**
     * 专家接收问题的状态：1-未完成，2-已完成，3-已无效，4-待响应，5-未响应，6-已移交（专业领域不符合），7-已移交（无法回答），8-被移交（其他专家移交给当前专家），
     * 9-超时响应（响应超时移交到当前专家）
     */
    @TableField("question_status")
    private Integer questionStatus;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField("is_valid")
    private Boolean isValid;

    @TableField("create_by")
    private Long createBy;

    @TableField("create_date")
    private Date createDate;

    @TableField("update_by")
    private Long updateBy;

    @TableField("update_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

}
