package cn.smarthse.tt.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName SpecialistOperateRecord
 * @Description 专家信息变更记录
 * @Author 曾华川
 * @Date 2024年05月20日 15:04
 **/
@TableName("specialist_operate_record")
@Data
public class SpecialistOperateRecord implements Serializable {

    private static final long serialVersionUID = -1992641861259360054L;
    @TableId
    private Long id;

    /**
     * 专家id
     */
    @TableField("specialist_id")
    private Long specialistId;

    /**
     * 操作类型（1-新增，2-编辑，3-出入库）
     */
    @TableField("type")
    private Integer type;

    /**
     * 操作人类型（1-专家端操作，2-监管端或运维端）
     */
    @TableField("operator_type")
    private Integer operatorType;

    /**
     * 变更之前的内容
     */
    @TableField("change_before")
    private String changeBefore;

    /**
     * 变更之后的内容
     */
    @TableField("change_after")
    private String changeAfter;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @TableField("is_valid")
    private Boolean isValid;

    @TableField("create_by")
    private Long createBy;

    @TableField("create_date")
    private Date createDate;

    @TableField("update_by")
    private Long updateBy;

    @TableField("update_date")
    private Date updateDate;

    /**
     * 操作人姓名
     */
    @TableField(exist = false)
    private String operator;
}
