package cn.smarthse.tt.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import net.sourceforge.pinyin4j.PinyinHelper;

/**
 * @Description: 专家信息
 * @Title: SpecialistInfo
 * @Author 张涛
 * @Date: 2024/2/23 15:59
 */

@Data
@TableName(value = "specialist_info")
public class SpecialistInfo extends BaseEntity {

    private static final long serialVersionUID = -7029143713983442279L;

    @TableId
    private Long id;

    /**
     * 照片文件ID(file.id)
     */
    @TableField(value = "face_id")
    private String faceId;

    /**
     * 姓名
     */
    @TableField(value = "fullname")
    private String fullname;

    /**
     * 首字母拼音
     */
    @TableField(value = "fullname_initial")
    private Character fullnameInitial;

    /**
     * 手机号
     */
    @TableField(value = "user_mobile")
    private String userMobile;

    /**
     * 所在单位ID
     */
    @TableField(value = "cid")
    private Long cid;

    /**
     * 所在单位名称
     */
    @TableField(value = "company_name")
    private String companyName;

    /**
     * 擅长领域
     */
    @TableField(value = "expertise_area")
    private String expertiseArea;

    /**
     * 专业技术职称/职务
     */
    @TableField(value = "job_title")
    private String jobTitle;

    /**
     * 专家类别（1 第一响应专家(市级)、2 第二响应专家(省级))
     */
    @TableField(value = "type")
    private Byte type;

    /**
     * 所在地区域ID(单位所在地)
     */
    @TableField(value = "area_id")
    private Long areaId;

    /**
     * 详细所在地(单位所在地)
     */
    @TableField(value = "area_address")
    private String areaAddress;

    /**
     * 专家简介
     */
    @TableField(value = "info")
    private String info;


    /**
     * 是否入库（0-出库，1-入库）
     */
    @TableField(value = "is_entering")
    private Boolean isEntering;

    /**
     * 是否是兜底专家
     */
    @TableField(value = "is_fallback")
    private Boolean isFallback;


    public Character getFullnameInitial() {
        if (this.fullname != null) {
            // 获取姓名的拼音数组
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray(this.fullname.charAt(0));

            if (pinyinArray != null && pinyinArray.length > 0) {
                // 获取首字母
                return pinyinArray[0].charAt(0); // 转换为大写
            } else {
                // 如果没有找到拼音，则直接取姓名的首个字符
                return this.fullname.charAt(0);
            }
        } else return null;

    }

}
