package cn.smarthse.tt.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description:
 * @Title: SpecialistAnswerCount
 * @Author zhangt
 * @Date: 2024/5/28 19:18
 */
@Data
@ApiModel
public class SpecialistAnswerCount extends BaseEntity {

    @ApiModelProperty("区域ID")
    private Long areaId;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    private String areaName;
    /**
     * 区域等级
     */
    @ApiModelProperty("区域等级")
    private Byte areaLevel;

    @ApiModelProperty("专家数")
    private Integer specialistNum;

    @ApiModelProperty("专家出入库状态数据(0-出库，1-入库，2-所有)")
    private Byte specialistType;

    @ApiModelProperty("接收问题数")
    private Integer receiveCount;

    @ApiModelProperty("解答问题数")
    private Integer answerCount;

    @ApiModelProperty("响应问题数")
    private Integer responseCount;

    @ApiModelProperty("未响应问题数")
    private Integer noResponseCount = 0;

    @ApiModelProperty("问题响应率")
    private Double responsivity;


    public Double getResponsivity() {
        if (this.receiveCount != null && this.noResponseCount != null && this.receiveCount != 0) {
            double responsivity = (double) (this.receiveCount - this.noResponseCount) / this.receiveCount;
            return Math.round(responsivity * 10000) / 100.0;
        } else {
            return 100.00;
        }
    }

}
