package cn.smarthse.tt.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName ReplyTemplate
 * @Description 问题回复模版
 * @Author 曾华川
 * @Date 2024年05月20日 11:03
 **/
@TableName("reply_template")
@Data
public class ReplyTemplate implements Serializable {

    private static final long serialVersionUID = -8734066740600645832L;
    @TableId
    private Long id;

    /**
     * 问题表id
     */
    @TableField("question_id")
    private Long questionId;

    /**
     * 专家表id
     */
    @TableField("specialist_id")
    private Long specialistId;

    /**
     * 交流表id
     */
    @TableField("communicate_id")
    private Long communicateId;

    /**
     * 模版内容
     */
    @TableField("content")
    private String content;

    @TableField("is_valid")
    private Boolean isValid;

    @TableField("create_by")
    private Long createBy;

    @TableField("create_date")
    private Date createDate;

    @TableField("update_by")
    private Long updateBy;

    @TableField("update_date")
    private Date updateDate;

}
