package cn.smarthse.tt.dto;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * @Description: 专家信息保存对象
 * @Title: SpecialistInfoDto
 * @Author zhangt
 * @Date: 2024年5月21日14:13:35
 */
@Data
public class SpecialistInfoDto extends BaseEntity {

    /**
     * 照片文件ID(file.id)
     */
    @ApiModelProperty("照片文件ID(file.id)")
    private Long faceId;

    /**
     * 姓名
     */
    @ApiModelProperty("专家姓名")
    @NotEmpty(message = "专家姓名必填")
    private String fullname;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    @NotEmpty(message = "手机号必填")
    private String userMobile;

    /**
     * 所在单位名称
     */
    @ApiModelProperty("所在单位名称")
    @NotEmpty(message = "所在单位名称必填")
    private String companyName;

    /**
     * 擅长领域--枚举
     */
    @ApiModelProperty("擅长领域")
    @NotEmpty(message = "擅长领域必填")
    private String expertiseArea;

    /**
     * 专业技术职称/职务
     */
    @ApiModelProperty("技术职称")
    private String jobTitle;

    /**
     * 专家类别（1 第一响应专家(市级)、2 第二响应专家(省级))
     */
    @ApiModelProperty("专家类别（1 第一响应专家(市级)、2 第二响应专家(省级))")
    private Byte type;

    /**
     * 所在地区域ID(单位所在地)
     */
    @ApiModelProperty("所在区域ID")
    @NotEmpty(message = "行政区划必选")
    private Long areaId;

    private String areaAddress;

    /**
     * 专家简介
     */
    @ApiModelProperty("专家简介")
    private String info;


}
