/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.thirdOrganization.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private StringUtil() {
    }

    public static String doubleToIntString(Double d) {
        int value = d.intValue();
        return String.valueOf(value);
    }

    public static boolean checkFloat(String num, String type) {
        String eL = "";
        eL = type.equals("0+") ? "^\\d+(\\.\\d+)?$" : (type.equals("+") ? "^((\\d+\\.\\d*[1-9]\\d*)|(\\d*[1-9]\\d*\\.\\d+)|(\\d*[1-9]\\d*))$" : (type.equals("-0") ? "^((-\\d+(\\.\\d+)?)|(0+(\\.0+)?))$" : (type.equals("-") ? "^(-((\\d+\\.\\d*[1-9]\\d*)|(\\d*[1-9]\\d*\\.\\d+)|(\\d*[1-9]\\d*)))$" : "^(-?\\d+)(\\.\\d+)?$")));
        Pattern p = Pattern.compile(eL);
        Matcher m = p.matcher(num);
        boolean b = m.matches();
        return b;
    }

    public static boolean isInArray(String value, String[] array) {
        if (array == null) {
            return false;
        }
        for (String v : array) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInArray(int value, String[] array) {
        if (array == null) {
            return false;
        }
        for (String v : array) {
            if (Integer.valueOf(v) != value) continue;
            return true;
        }
        return false;
    }

    public static String implode(String str, Object[] array) {
        if (str == null || array == null) {
            return "";
        }
        Object result = "";
        for (int i = 0; i < array.length; ++i) {
            result = i == array.length - 1 ? (String)result + array[i].toString() : (String)result + array[i].toString() + str;
        }
        return result;
    }

    public static String implodeValue(String str, Object[] array) {
        if (str == null || array == null) {
            return "";
        }
        Object result = "";
        for (int i = 0; i < array.length; ++i) {
            result = i == array.length - 1 ? (String)result + "?" : (String)result + "?" + str;
        }
        return result;
    }

    public static String md5(String str) {
        return StringUtil.md5(str, true);
    }

    public static String md5(String str, boolean zero) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return null;
        }
        byte[] resultByte = messageDigest.digest(str.getBytes());
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < resultByte.length; ++i) {
            int v = 0xFF & resultByte[i];
            if (v < 16 && zero) {
                result.append("0");
            }
            result.append(Integer.toHexString(v));
        }
        return result.toString();
    }

    public static boolean validEmail(String sEmail) {
        String pattern = "^([a-z0-9A-Z]+[-|\\.|_]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        return sEmail.matches(pattern);
    }

    public static boolean validMaxLen(String str, int length) {
        if (str == null || str.equals("")) {
            return false;
        }
        return str.length() <= length;
    }

    public static boolean validMinLen(String str, int length) {
        if (str == null || str.equals("")) {
            return false;
        }
        return str.length() >= length;
    }

    public static boolean isEmpty(String str) {
        if (str == null || "".equals(str)) {
            return true;
        }
        String pattern = "\\S";
        Pattern p = Pattern.compile(pattern, 34);
        Matcher m = p.matcher(str);
        return !m.find();
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null || str1.equals("") || str2 == null || str2.equals("")) {
            return false;
        }
        return str1.equals(str2);
    }

    public static int toInt(String str, boolean checked) {
        int value = 0;
        if (str == null || str.equals("")) {
            return 0;
        }
        try {
            value = Integer.parseInt(str);
        }
        catch (Exception ex) {
            if (checked) {
                throw new RuntimeException("\u6574\u578b\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            return 0;
        }
        return value;
    }

    public static Integer toInt(String str, Integer defaultValue) {
        Integer value = defaultValue;
        if (str == null || str.equals("")) {
            return defaultValue;
        }
        try {
            value = Integer.parseInt(str);
        }
        catch (Exception ex) {
            return defaultValue;
        }
        return value;
    }

    @Deprecated
    public static int toInt(String str) {
        int value = 0;
        if (str == null || str.equals("")) {
            return 0;
        }
        try {
            value = Integer.parseInt(str);
        }
        catch (Exception ex) {
            value = 0;
            ex.printStackTrace();
        }
        return value;
    }

    @Deprecated
    public static Double toDouble(String str) {
        Double value = 0.0;
        if (str == null || str.equals("")) {
            return 0.0;
        }
        try {
            value = Double.valueOf(str);
        }
        catch (Exception ex) {
            value = 0.0;
        }
        return value;
    }

    public static Double toDouble(String str, boolean checked) {
        Double value = 0.0;
        if (str == null || str.equals("")) {
            return 0.0;
        }
        try {
            value = Double.valueOf(str);
        }
        catch (Exception ex) {
            if (checked) {
                throw new RuntimeException("\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            return 0.0;
        }
        return value;
    }

    public static Double toDouble(String str, Double defaultValue) {
        Double value = defaultValue;
        if (str == null || str.equals("")) {
            return 0.0;
        }
        try {
            value = Double.valueOf(str);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            value = defaultValue;
        }
        return value;
    }

    public static String arrayToString(Object[] array, String split) {
        if (array == null) {
            return "";
        }
        Object str = "";
        for (int i = 0; i < array.length; ++i) {
            str = i != array.length - 1 ? (String)str + array[i].toString() + split : (String)str + array[i].toString();
        }
        return str;
    }

    public static String listToString(List list, String split) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Object obj : list) {
            if (sb.length() != 0) {
                sb.append(split);
            }
            sb.append(obj.toString());
        }
        return sb.toString();
    }

    public static int formatPage(String page) {
        int iPage = 1;
        if (page == null || page.equals("")) {
            return iPage;
        }
        try {
            iPage = Integer.parseInt(page);
        }
        catch (Exception ex) {
            iPage = 1;
        }
        return iPage;
    }

    public static String getFileSize(String fileSize) {
        Object temp = "";
        DecimalFormat df = new DecimalFormat("0.00");
        double dbFileSize = Double.parseDouble(fileSize);
        temp = dbFileSize >= 1024.0 ? (dbFileSize >= 1048576.0 ? (dbFileSize >= 1.073741824E9 ? df.format(dbFileSize / 1024.0 / 1024.0 / 1024.0) + " GB" : df.format(dbFileSize / 1024.0 / 1024.0) + " MB") : df.format(dbFileSize / 1024.0) + " KB") : df.format(dbFileSize / 1024.0) + " KB";
        return temp;
    }

    public static String getEntry() {
        Random random = new Random(100L);
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(new String("yyyyMMddHHmmssS"));
        return StringUtil.md5(formatter.format(now) + random.nextDouble());
    }

    public static String toUTF8(String str) {
        if (str == null || str.equals("")) {
            return "";
        }
        try {
            return new String(str.getBytes("ISO8859-1"), "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String to(String str, String charset) {
        if (str == null || str.equals("")) {
            return "";
        }
        try {
            return new String(str.getBytes("UTF-8"), charset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String getRandStr(int n) {
        Random random = new Random();
        Object sRand = "";
        for (int i = 0; i < n; ++i) {
            String rand = String.valueOf(random.nextInt(10));
            sRand = (String)sRand + rand;
        }
        return sRand;
    }

    public static String getChineseNum(int num) {
        String[] chineseNum = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};
        return chineseNum[num];
    }

    public static String replaceEnter(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\r", "").replaceAll("\n", "");
    }

    public static String replaceAll(String source, String target, String content) {
        StringBuffer buffer = new StringBuffer(source);
        int start = buffer.indexOf(target);
        if (start > 0) {
            source = buffer.replace(start, start + target.length(), content).toString();
        }
        return source;
    }

    public static String getTxtWithoutHTMLElement(String element) {
        if (null == element || "".equals(element.trim())) {
            return element;
        }
        Pattern pattern = Pattern.compile("<[^<|^>]*>");
        Matcher matcher = pattern.matcher(element);
        StringBuffer txt = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group();
            if (group.matches("<[\\s]*>")) {
                matcher.appendReplacement(txt, group);
                continue;
            }
            matcher.appendReplacement(txt, "");
        }
        matcher.appendTail(txt);
        String temp = txt.toString().replaceAll("\n", "");
        temp = temp.replaceAll(" ", "");
        return temp;
    }

    public static String toTrim(String strtrim) {
        if (null != strtrim && !strtrim.equals("")) {
            return strtrim.trim();
        }
        return "";
    }

    public static String filterDollarStr(String str) {
        Object sReturn = "";
        if (!StringUtil.toTrim(str).equals("")) {
            if (str.indexOf(36, 0) > -1) {
                while (str.length() > 0) {
                    if (str.indexOf(36, 0) > -1) {
                        sReturn = (String)sReturn + String.valueOf(str.subSequence(0, str.indexOf(36, 0)));
                        sReturn = (String)sReturn + "\\$";
                        str = str.substring(str.indexOf(36, 0) + 1, str.length());
                        continue;
                    }
                    sReturn = (String)sReturn + str;
                    str = "";
                }
            } else {
                sReturn = str;
            }
        }
        return sReturn;
    }

    public static String compressHtml(String html) {
        if (html == null) {
            return null;
        }
        html = html.replaceAll("[\\t\\n\\f\\r]", "");
        return html;
    }

    public static String toCurrency(Double d) {
        if (d != null) {
            DecimalFormat df = new DecimalFormat("\uffe5#,###.00");
            return df.format(d);
        }
        return "";
    }

    public static String toString(Integer i) {
        if (i != null) {
            return String.valueOf(i);
        }
        return "";
    }

    public static String toString(Double d) {
        if (null != d) {
            return String.valueOf(d);
        }
        return "";
    }

    public static String getRandom() {
        int[] array = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        Random rand = new Random();
        for (int i = 10; i > 1; --i) {
            int index = rand.nextInt(i);
            int tmp = array[index];
            array[index] = array[i - 1];
            array[i - 1] = tmp;
        }
        int result = 0;
        for (int i = 0; i < 6; ++i) {
            result = result * 10 + array[i];
        }
        return "" + result;
    }

    public static int getMaxLevelCode(int code) {
        String codeStr = "" + code;
        StringBuffer str = new StringBuffer();
        boolean flag = true;
        for (int i = codeStr.length() - 1; i >= 0; --i) {
            char c = codeStr.charAt(i);
            if (c == '0' && flag) {
                str.insert(0, '9');
                continue;
            }
            str.insert(0, c);
            flag = false;
        }
        return Integer.valueOf(str.toString());
    }

    public static String delSqlComment(String content) {
        String pattern = "/\\*(.|[\r\n])*?\\*/";
        Pattern p = Pattern.compile(pattern, 34);
        Matcher m = p.matcher(content);
        if (m.find()) {
            content = m.replaceAll("");
        }
        return content;
    }

    public static String inputStream2String(InputStream is) {
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static String decode(String keyword) {
        try {
            keyword = URLDecoder.decode(keyword, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return keyword;
    }

    public static String doFilter(String regex, String rpstr, String source) {
        Pattern p = Pattern.compile(regex, 34);
        Matcher m = p.matcher(source);
        return m.replaceAll(rpstr);
    }

    public static String formatScript(String source) {
        source = source.replaceAll("javascript", "&#106avascript");
        source = source.replaceAll("jscript:", "&#106script:");
        source = source.replaceAll("js:", "&#106s:");
        source = source.replaceAll("value", "&#118alue");
        source = source.replaceAll("about:", "about&#58");
        source = source.replaceAll("file:", "file&#58");
        source = source.replaceAll("document.cookie", "documents&#46cookie");
        source = source.replaceAll("vbscript:", "&#118bscript:");
        source = source.replaceAll("vbs:", "&#118bs:");
        source = StringUtil.doFilter("(on(mouse|exit|error|click|key))", "&#111n$2", source);
        return source;
    }

    public static String htmlDecode(String htmlContent) {
        htmlContent = StringUtil.formatScript(htmlContent);
        htmlContent = htmlContent.replaceAll(" ", "&nbsp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n\r", "<br>").replaceAll("\r\n", "<br>").replaceAll("\r", "<br>");
        return htmlContent;
    }

    public static String addPrefix(String table, String prefix) {
        Object result = "";
        result = table.length() > prefix.length() ? (table.substring(0, prefix.length()).toLowerCase().equals(prefix.toLowerCase()) ? table : prefix + table) : prefix + table;
        return result;
    }

    public static String addSuffix(String table, String suffix) {
        int end;
        int start;
        Object result = "";
        result = table.length() > suffix.length() ? (table.substring(start = table.length() - suffix.length(), end = start + suffix.length()).toLowerCase().equals(suffix.toLowerCase()) ? table : table + suffix) : table + suffix;
        return result;
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static String replaceComma(String rpIds) {
        if (rpIds == null || rpIds.trim().equals("")) {
            return "";
        }
        if ((rpIds = rpIds.replaceAll("[,]{2,}", ",")).endsWith(",")) {
            rpIds = rpIds.substring(0, rpIds.length() - 1);
        }
        if (rpIds.startsWith(",")) {
            rpIds = rpIds.substring(1);
        }
        return rpIds;
    }

    public static int getChineseCharLength(String value) {
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }
}

