/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.zlb.service.impl.science;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.entity.information.BigText;
import cn.smarthse.modules.health.entity.information.Information;
import cn.smarthse.modules.health.service.information.IBigTextService;
import cn.smarthse.modules.health.service.information.IInformationService;
import cn.smarthse.modules.health.zlb.entity.InfoEvaluation;
import cn.smarthse.modules.health.zlb.mapper.ScienceMapper;
import cn.smarthse.modules.health.zlb.model.ScienceInfoModel;
import cn.smarthse.modules.health.zlb.model.ScienceModel;
import cn.smarthse.modules.health.zlb.model.ScienceSearchVo;
import cn.smarthse.modules.health.zlb.service.science.IScienceService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class ScienceServiceImpl
extends BaseServiceImpl<ScienceMapper, InfoEvaluation>
implements IScienceService {
    @DubboReference
    private IInformationService informationService;
    @DubboReference
    private IBigTextService bigTextService;

    public PageInfo<ScienceModel> page(ScienceSearchVo searchVo) {
        PageHelper.startPage((int)searchVo.getPage(), (int)searchVo.getRows());
        List<ScienceModel> list = ((ScienceMapper)this.dao).page(searchVo);
        return new PageInfo(list);
    }

    public ScienceInfoModel getBigTextById(Long id) {
        ScienceInfoModel model = new ScienceInfoModel();
        if (id == null) {
            return model;
        }
        model.setSourceId(id);
        Information information = (Information)this.informationService.getById(id);
        if (information == null) {
            return model;
        }
        model.setSource(information.getSource());
        model.setTitle(information.getTitle());
        BigText t = (BigText)this.bigTextService.getById(information.getTextId());
        String text = "";
        if (t != null) {
            text = t.getText();
            text = text.replaceAll("&lt;", "<");
            text = text.replaceAll("&gt;", ">");
            model.setTextId(t.getId());
        }
        model.setText(text);
        return model;
    }

    @Transactional(readOnly=false)
    public InfoEvaluation saveEvaluate(InfoEvaluation evaluation) {
        if (evaluation.getUserId() == null) {
            return new InfoEvaluation();
        }
        evaluation.setId(Long.valueOf(this.idworker.nextId()));
        evaluation.setType(Byte.valueOf((byte)1));
        evaluation.setEvaluateDate(new Date());
        evaluation.setCreateDate(new Date());
        evaluation.setUpdateDate(new Date());
        return this.add(evaluation);
    }

    public InfoEvaluation checkEvaluate(InfoEvaluation evaluation) {
        Example example = new Example(InfoEvaluation.class);
        example.createCriteria().andEqualTo("sourceId", (Object)evaluation.getSourceId()).andEqualTo("userId", (Object)evaluation.getUserId()).andEqualTo("isValid", (Object)Global.TRUE);
        return (InfoEvaluation)this.getOneByExample(example);
    }
}

