/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.tasks.presmartdoc;

import cn.smarthse.modules.health.micro.enums.PreSmartDocStaskEvent;
import cn.smarthse.modules.health.micro.param.MicrocomPreSmartPlanParam;
import cn.smarthse.modules.health.micro.service.IMicrocomPreSmartPlanService;
import cn.smarthse.modules.health.micro.service.PreSmartDataGenerateService;
import cn.smarthse.modules.health.micro.service.handle.CheckOverPreSmartDocHandle;
import cn.smarthse.modules.health.micro.service.handle.PersonProtectSmartDocHandle;
import cn.smarthse.modules.health.micro.service.handle.PhyRiskPreSmartDocHandle;
import cn.smarthse.modules.health.micro.service.handle.TsProjectSimplePreSmartDocRiskHandle;
import cn.smarthse.modules.health.micro.service.handle.WarnSignSmartDocHandle;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreSmartDocTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreSmartDocTask.class);
    @Autowired
    private PreSmartDataGenerateService preSmartDataGenerateService;
    @Autowired
    private IMicrocomPreSmartPlanService planService;
    @Autowired
    private CheckOverPreSmartDocHandle checkOverPreSmartDocHandle;
    @Autowired
    private PhyRiskPreSmartDocHandle phyRiskPreSmartDocHandle;
    @Autowired
    private WarnSignSmartDocHandle warnSignSmartDocHandle;
    @Autowired
    private PersonProtectSmartDocHandle personProtectSmartDocHandle;
    @Autowired
    private TsProjectSimplePreSmartDocRiskHandle tsProjectSimplePreSmartDocRiskHandle;

    private LocalDate getLocaDate() {
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObject = JSON.parseObject((String)jobParam);
        if (jsonObject != null && jsonObject.containsKey((Object)"date")) {
            String dateParam = jsonObject.getString("date");
            return LocalDate.parse(dateParam);
        }
        return null;
    }

    private List<Long> getCids() {
        List<Long> cids = null;
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObject = JSON.parseObject((String)jobParam);
        if (jsonObject != null && jsonObject.containsKey((Object)"cid")) {
            Long cid = jsonObject.getLong("cid");
            cids = List.of(cid);
        }
        return cids;
    }

    @XxlJob(value="PreSmartDocTask-yearRemind")
    public void yearRemind() {
        XxlJobHelper.log((String)"\u3010\u5e74\u5ea6\u9884\u667a\u5355\uff0c\u5f00\u59cb\u3002\u3011", (Object[])new Object[0]);
        LocalDate now = LocalDate.now();
        LocalDate locaDate = this.getLocaDate();
        if (locaDate != null) {
            now = locaDate;
        }
        this.preSmartDataGenerateService.generateYearWorkRemindData(null, now, PreSmartDocStaskEvent.YEAR_REMIND);
        XxlJobHelper.log((String)"\u3010\u5e74\u5ea6\u9884\u667a\u5355\uff0c\u7ed3\u675f\u3002\u3011", (Object[])new Object[0]);
    }

    @XxlJob(value="PreSmartDocTask-workRemind")
    public void workRemind() {
        XxlJobHelper.log((String)"\u3010\u5de5\u4f5c\u63d0\u9192\u9884\u667a\u5355\uff0c\u5f00\u59cb\u3002\u3011", (Object[])new Object[0]);
        LocalDate now = LocalDate.now();
        LocalDate locaDate = this.getLocaDate();
        if (locaDate != null) {
            now = locaDate;
        }
        this.preSmartDataGenerateService.generateYearWorkRemindData(null, now, PreSmartDocStaskEvent.WORK_REMIND);
        XxlJobHelper.log((String)"\u3010\u5de5\u4f5c\u63d0\u9192\u9884\u667a\u5355\uff0c\u7ed3\u675f\u3002\u3011", (Object[])new Object[0]);
    }

    @XxlJob(value="PreSmartDocTask-newAddCompanySuppleYearRemind")
    public void newAddCompanySuppleYearRemind() {
        XxlJobHelper.log((String)"\u3010\u65b0\u589e\u4f01\u4e1a\u8865\u5145\u5e74\u5ea6\u63d0\u9192\u9884\u667a\u5355\uff0c\u5f00\u59cb\u3002\u3011", (Object[])new Object[0]);
        LocalDate now = LocalDate.now();
        LocalDate locaDate = this.getLocaDate();
        if (locaDate != null) {
            now = locaDate;
        }
        MicrocomPreSmartPlanParam param = new MicrocomPreSmartPlanParam();
        param.setType(PreSmartDocStaskEvent.YEAR_REMIND.getKey());
        param.setEffectYear(Integer.valueOf(now.getYear()));
        List cidList = this.planService.listNoMicrocomPreSmartPlan(param);
        if (CollectionUtils.isEmpty((Collection)cidList)) {
            return;
        }
        XxlJobHelper.log((String)"\u3010\u65b0\u589e\u4f01\u4e1a\u8865\u5145\u5e74\u5ea6\u63d0\u9192\u9884\u667a\u5355\u3011\u9700\u65b0\u589e\u4f01\u4e1a\u6570\uff1a{}", (Object[])new Object[]{cidList.size()});
        this.preSmartDataGenerateService.generateYearWorkRemindData(cidList, now, PreSmartDocStaskEvent.YEAR_REMIND);
        XxlJobHelper.log((String)"\u3010\u65b0\u589e\u4f01\u4e1a\u8865\u5145\u5e74\u5ea6\u63d0\u9192\u9884\u667a\u5355\uff0c\u7ed3\u675f\u3002\u3011", (Object[])new Object[0]);
    }

    @XxlJob(value="PreSmartDocTask-checkRiskRemind")
    public void checkRiskRemind() {
        XxlJobHelper.log((String)"\u3010\u68c0\u6d4b\u98ce\u9669\u63d0\u9192\u9884\u667a\u5355\uff0c\u5f00\u59cb\u3002\u3011", (Object[])new Object[0]);
        LocalDate now = LocalDate.now();
        LocalDate locaDate = this.getLocaDate();
        if (locaDate != null) {
            now = locaDate;
        }
        this.preSmartDataGenerateService.generateRiskRemindPreSmart(this.checkOverPreSmartDocHandle, this.getCids(), now);
        XxlJobHelper.log((String)"\u3010\u98ce\u9669\u63d0\u9192\u9884\u667a\u5355\uff0c\u7ed3\u675f\u3002\u3011", (Object[])new Object[0]);
    }

    @XxlJob(value="PreSmartDocTask-thirdTimeRiskRemind")
    public void thirdTimeRiskRemind() {
        XxlJobHelper.log((String)"\u3010\u4e09\u540c\u65f6\u98ce\u9669\u63d0\u9192\u9884\u667a\u5355\uff0c\u5f00\u59cb\u3002\u3011", (Object[])new Object[0]);
        LocalDate now = LocalDate.now();
        LocalDate locaDate = this.getLocaDate();
        if (locaDate != null) {
            now = locaDate;
        }
        this.preSmartDataGenerateService.generateRiskRemindPreSmart(this.tsProjectSimplePreSmartDocRiskHandle, this.getCids(), now);
        XxlJobHelper.log((String)"\u3010\u4e09\u540c\u65f6\u98ce\u9669\u63d0\u9192\u9884\u667a\u5355\uff0c\u7ed3\u675f\u3002\u3011", (Object[])new Object[0]);
    }

    @XxlJob(value="PreSmartDocTask-healthRiskRemind")
    public void healthRiskRemind() {
        XxlJobHelper.log((String)"\u3010\u4f53\u68c0\u98ce\u9669\u63d0\u9192\u9884\u667a\u5355\uff0c\u5f00\u59cb\u3002\u3011", (Object[])new Object[0]);
        LocalDate now = LocalDate.now();
        LocalDate locaDate = this.getLocaDate();
        if (locaDate != null) {
            now = locaDate;
        }
        this.preSmartDataGenerateService.generateRiskRemindPreSmart(this.phyRiskPreSmartDocHandle, this.getCids(), now);
        XxlJobHelper.log((String)"\u3010\u4f53\u68c0\u98ce\u9669\u63d0\u9192\u9884\u667a\u5355\uff0c\u7ed3\u675f\u3002\u3011", (Object[])new Object[0]);
    }
}

