/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.tasks.dosemonitor;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyBaseInfoSearchModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.health.dosemonitor.entity.DoseMonitor;
import cn.smarthse.modules.health.dosemonitor.entity.DoseMonitorData;
import cn.smarthse.modules.health.dosemonitor.enums.DoseMonitorConvertStaffEnum;
import cn.smarthse.modules.health.dosemonitor.enums.DoseMonitorSourcesEnum;
import cn.smarthse.modules.health.dosemonitor.enums.DoseMonitorStatusEnum;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorConvertModel;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorDataConvertModel;
import cn.smarthse.modules.health.dosemonitor.model.params.DoseMonitorParam;
import cn.smarthse.modules.health.dosemonitor.service.IDoseMonitorService;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.enums.staff.StaffAddFromEnum;
import cn.smarthse.modules.health.enums.staff.StaffSourceEnum;
import cn.smarthse.modules.health.model.staff.BatchAddStaffLogCounter;
import cn.smarthse.modules.health.model.staff.BatchAddStaffModel;
import cn.smarthse.modules.health.model.staff.StaffBasicQueryModel;
import cn.smarthse.modules.health.service.base.staff.IBatchAddStaffService;
import cn.smarthse.modules.health.supervise.dao.company.CompanyDcMapper;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DoseMonitorTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DoseMonitorTask.class);
    @Autowired
    IDoseMonitorService doseMonitorService;
    @Autowired
    CompanyDcMapper companyDcMapper;
    @Autowired
    IdWorker idWorker;
    @DubboReference
    IBatchAddStaffService batchAddStaffService;

    public List<DoseMonitor> convertDoseMonitor(List<DoseMonitorConvertModel> doseMonitorConvertModels, Map<String, Long> unicode2IdMap) {
        ArrayList<DoseMonitor> doseMonitors = new ArrayList<DoseMonitor>();
        for (DoseMonitorConvertModel doseMonitorConvertModel : doseMonitorConvertModels) {
            try {
                doseMonitorConvertModel.setBeginDate(DateUtils.StringToDate((String)doseMonitorConvertModel.getSourceBeginDate()));
                doseMonitorConvertModel.setEndDate(DateUtils.StringToDate((String)doseMonitorConvertModel.getSourceEndDate()));
                doseMonitorConvertModel.setCycleDays(Convert.toInt((Object)doseMonitorConvertModel.getSourceCycleDays()));
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)doseMonitorConvertModel);
                doseMonitorConvertModel.setIsConvertedTozlwq(Integer.valueOf(2));
                doseMonitorConvertModel.setFailReasonTozlwq("\u8f6c\u6362\u6570\u636e\u5f02\u5e38");
                continue;
            }
            DoseMonitor doseMonitor = new DoseMonitor();
            BeanUtils.copyProperties((Object)doseMonitorConvertModel, (Object)doseMonitor);
            doseMonitor.setId(Long.valueOf(this.idWorker.nextId()));
            doseMonitor.setCid(unicode2IdMap.get(doseMonitorConvertModel.getHospitalCreditCode()));
            doseMonitorConvertModel.setIsConvertedTozlwq(Integer.valueOf(0));
            if (doseMonitor.getCid() != null) {
                doseMonitorConvertModel.setIsConvertedTozlwq(Integer.valueOf(1));
            } else {
                doseMonitorConvertModel.setIsConvertedTozlwq(Integer.valueOf(2));
                doseMonitorConvertModel.setFailReasonTozlwq("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5355\u4f4d");
            }
            doseMonitor.setIsValid(Boolean.valueOf(true));
            if (Objects.equals(doseMonitorConvertModel.getOptType(), 3)) {
                doseMonitor.setIsValid(Boolean.valueOf(false));
                doseMonitor.setDelReason("\u4e07\u8fbe\u4ed3\u6570\u636e\u5220\u9664");
            }
            doseMonitor.setDataSource(DoseMonitorSourcesEnum.FROM_WANDA.getKey());
            doseMonitor.setStatus(DoseMonitorStatusEnum.NOCHECK_FROMWANDA.getKey());
            doseMonitors.add(doseMonitor);
        }
        return doseMonitors;
    }

    @XxlJob(value="DoseMonitorTask-syncDoseMonitor")
    public void syncDoseMonitor() throws InterruptedException {
        int pageSize;
        XxlJobHelper.log((String)"--------\u3010\u4e2a\u4eba\u5242\u91cf\u4e3b\u8868\u6570\u636e\u8f6c\u6362start\u3011-------", (Object[])new Object[0]);
        log.debug("--------\u3010\u4e2a\u4eba\u5242\u91cf\u4e3b\u8868\u6570\u636e\u8f6c\u6362start\u3011-------");
        do {
            PageHelper.startPage((int)1, (int)1000);
            DoseMonitorParam param = new DoseMonitorParam();
            List doseMonitorConvertModels = this.doseMonitorService.listNeedSyncDoseMonitor(param);
            pageSize = doseMonitorConvertModels.size();
            XxlJobHelper.log((String)"\u672c\u6b21\u9700\u8f6c\u6362\u6570\u636e\u6570\uff1a{}", (Object[])new Object[]{pageSize});
            if (CollectionUtils.isEmpty((Collection)doseMonitorConvertModels)) {
                return;
            }
            List creditCodes = doseMonitorConvertModels.stream().map(DoseMonitor::getHospitalCreditCode).collect(Collectors.toList());
            CompanyBaseInfoSearchModel baseInfoSearchModel = new CompanyBaseInfoSearchModel();
            baseInfoSearchModel.setIsValid(Boolean.valueOf(true));
            baseInfoSearchModel.setIncludeUnincodes(creditCodes);
            List<CompanySuperviseModel> companySuperviseModels = this.companyDcMapper.listCompanyBaseInfo(baseInfoSearchModel);
            if (CollectionUtils.isEmpty(companySuperviseModels)) {
                return;
            }
            Map<String, Long> unicode2IdMap = companySuperviseModels.stream().collect(Collectors.toMap(CompanyBaseInfoModel::getUnifiedSocialCc, CompanyBaseInfoModel::getId));
            List<DoseMonitor> doseMonitors = this.convertDoseMonitor(doseMonitorConvertModels, unicode2IdMap);
            this.doseMonitorService.updateDoseMonitors(doseMonitors, doseMonitorConvertModels);
        } while (pageSize >= 1000);
        XxlJobHelper.log((String)"--------\u3010\u4e2a\u4eba\u5242\u91cf\u4e3b\u8868\u6570\u636e\u8f6c\u6362end\u3011-------", (Object[])new Object[0]);
        log.debug("--------\u3010\u4e2a\u4eba\u5242\u91cf\u4e3b\u8868\u6570\u636e\u8f6c\u6362end\u3011-------");
    }

    public List<DoseMonitorData> convertDoseMonitorData(List<DoseMonitorDataConvertModel> doseMonitorConvertModels) {
        ArrayList<DoseMonitorData> doseMonitors = new ArrayList<DoseMonitorData>();
        for (DoseMonitorDataConvertModel dataConvertModel : doseMonitorConvertModels) {
            String sourceRaType;
            try {
                dataConvertModel.setSex(Convert.toInt((Object)dataConvertModel.getSourceSex()));
                dataConvertModel.setAge(Convert.toInt((Object)dataConvertModel.getSourceAge()));
                dataConvertModel.setIsBigDose(Convert.toInt((Object)dataConvertModel.getSourceIsBigDose()));
                dataConvertModel.setIsYearBigDose(Convert.toInt((Object)dataConvertModel.getSourceIsYearBigDose()));
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)dataConvertModel);
                dataConvertModel.setIsConvertedTozlwq(Integer.valueOf(2));
                dataConvertModel.setFailReasonTozlwq("\u8f6c\u6362\u6570\u636e\u5f02\u5e38");
                continue;
            }
            DoseMonitorData doseMonitor = new DoseMonitorData();
            BeanUtils.copyProperties((Object)dataConvertModel, (Object)doseMonitor);
            doseMonitor.setId(Long.valueOf(this.idWorker.nextId()));
            dataConvertModel.setIsConvertedTozlwq(Integer.valueOf(1));
            doseMonitor.setIsValid(Boolean.valueOf(true));
            if (Objects.equals(dataConvertModel.getOptType(), 3)) {
                doseMonitor.setIsValid(Boolean.valueOf(false));
                doseMonitor.setDelReason("\u4e07\u8fbe\u4ed3\u6570\u636e\u5220\u9664");
            }
            if (StringUtils.contains((String)(sourceRaType = dataConvertModel.getSourceRaType()), (String)"\u5916\u7167\u5c04")) {
                doseMonitor.setRaType(Integer.valueOf(2));
            } else {
                doseMonitor.setRaType(Integer.valueOf(1));
            }
            doseMonitors.add(doseMonitor);
        }
        return doseMonitors;
    }

    @XxlJob(value="DoseMonitorTask-syncDoseMonitorData")
    public void syncDoseMonitorData() throws InterruptedException {
        int pageSize;
        XxlJobHelper.log((String)"--------\u3010\u4e2a\u4eba\u5242\u91cf\u5b50\u8868\u6570\u636e\u8f6c\u6362start\u3011-------", (Object[])new Object[0]);
        log.debug("--------\u3010\u4e2a\u4eba\u5242\u91cf\u5b50\u8868\u6570\u636e\u8f6c\u6362start\u3011-------");
        do {
            PageHelper.startPage((int)1, (int)1000);
            DoseMonitorParam param = new DoseMonitorParam();
            List doseMonitorConvertModels = this.doseMonitorService.listNeedSyncDoseMonitorData(param);
            pageSize = doseMonitorConvertModels.size();
            XxlJobHelper.log((String)"\u672c\u6b21\u9700\u8f6c\u6362\u6570\u636e\u6570\uff1a{}", (Object[])new Object[]{pageSize});
            if (CollectionUtils.isEmpty((Collection)doseMonitorConvertModels)) {
                return;
            }
            List<DoseMonitorData> doseMonitorData = this.convertDoseMonitorData(doseMonitorConvertModels);
            this.doseMonitorService.updateDoseMonitorDatas(doseMonitorData, doseMonitorConvertModels);
        } while (pageSize >= 1000);
        XxlJobHelper.log((String)"--------\u3010\u4e2a\u4eba\u5242\u91cf\u5b50\u8868\u6570\u636e\u8f6c\u6362end\u3011-------", (Object[])new Object[0]);
        log.debug("--------\u3010\u4e2a\u4eba\u5242\u91cf\u5b50\u8868\u6570\u636e\u8f6c\u6362end\u3011-------");
    }

    public List<BatchAddStaffModel> convertDoseMonitorStaffData(List<DoseMonitorDataConvertModel> doseMonitorConvertModels) {
        ArrayList<BatchAddStaffModel> staffModels = new ArrayList<BatchAddStaffModel>();
        HashSet<CallSite> repeatDataSet = new HashSet<CallSite>();
        for (DoseMonitorDataConvertModel dataConvertModel : doseMonitorConvertModels) {
            Long cid = dataConvertModel.getCid();
            if (StringUtils.isBlank((String)dataConvertModel.getName()) || StringUtils.isBlank((String)dataConvertModel.getIdCard())) {
                dataConvertModel.setIsConvertStaff(DoseMonitorConvertStaffEnum.ERRDATA.getKey());
                dataConvertModel.setConvertStaffFailreason("\u5fc5\u586b\u9879\u6709\u4e3a\u7a7a\u6570\u636e");
                continue;
            }
            String cididcard = cid + dataConvertModel.getIdCard();
            if (repeatDataSet.contains(cididcard)) {
                dataConvertModel.setIsConvertStaff(DoseMonitorConvertStaffEnum.REPEAT.getKey());
                dataConvertModel.setConvertStaffFailreason("\u4eba\u5458\u91cd\u590d\u6570\u636e");
                continue;
            }
            repeatDataSet.add((CallSite)((Object)cididcard));
            StaffBasicInfo staffBasicInfo = new StaffBasicInfo();
            staffBasicInfo.setAge(dataConvertModel.getAge());
            staffBasicInfo.setRealName(dataConvertModel.getName());
            staffBasicInfo.setJobName(dataConvertModel.getPost());
            staffBasicInfo.setIdCard(StringUtil.toUpperCase((String)dataConvertModel.getIdCard()));
            Integer sex = dataConvertModel.getSex();
            if (sex != null) {
                staffBasicInfo.setGender(Byte.valueOf(sex.byteValue()));
            } else {
                Byte gender = IDCardUtil.getGender((String)dataConvertModel.getIdCard());
                staffBasicInfo.setGender(gender);
            }
            StaffInfo staffInfo = new StaffInfo();
            staffInfo.setIsThirdParty(Boolean.valueOf(false));
            staffInfo.setSourceId(dataConvertModel.getId());
            if (Objects.equals(dataConvertModel.getDelFlag(), 1)) {
                staffInfo.setIsValid(Boolean.valueOf(false));
                staffInfo.setDeleteReason("\u4e2a\u4eba\u5242\u91cf\u6570\u636e\u5220\u9664");
                staffBasicInfo.setIsValid(Boolean.valueOf(false));
            } else {
                staffInfo.setIsValid(Boolean.valueOf(true));
                staffBasicInfo.setIsValid(Boolean.valueOf(true));
            }
            StaffBasicWork sbw = new StaffBasicWork();
            sbw.setIsRadiation(Boolean.valueOf(true));
            StaffWorkRole swr = new StaffWorkRole();
            swr.setStatus(Byte.valueOf((byte)1));
            swr.setWorkProperty(Byte.valueOf((byte)1));
            swr.setIsHistory(Boolean.valueOf(false));
            swr.setIsThirdParty(Boolean.valueOf(false));
            BatchAddStaffModel build = BatchAddStaffModel.builder().cid(cid).dataSourceId(dataConvertModel.getId()).dataSource(StaffSourceEnum.third_org_check_add.getValue()).addFrom(Integer.valueOf(StaffAddFromEnum.dose_monitor.getValue().intValue())).staffBasicInfo(staffBasicInfo).staffInfo(staffInfo).staffBasicWork(sbw).staffWorkRole(swr).build();
            staffModels.add(build);
            dataConvertModel.setIsConvertStaff(DoseMonitorConvertStaffEnum.CONVERTED.getKey());
        }
        return staffModels;
    }

    public List<DoseMonitorDataConvertModel> checkMonitorDataIdcardRealName(List<DoseMonitorDataConvertModel> doseMonitorConvertModels, Set<Long> backDoseMonitorIdList) {
        List mapperQueryList = doseMonitorConvertModels.stream().map(m -> {
            StaffBasicQueryModel staffParam = new StaffBasicQueryModel();
            staffParam.setCid(m.getCid());
            staffParam.setStaffIdCard(SpringEncryptUtils.encrypt((String)m.getIdCard()));
            return staffParam;
        }).collect(Collectors.toList());
        List dbStaffBasicQueryModels = this.batchAddStaffService.checkStaffModel(mapperQueryList);
        if (CollectionUtils.isNotEmpty((Collection)dbStaffBasicQueryModels)) {
            Map<String, List<StaffBasicQueryModel>> groupByCidCardIdMap = dbStaffBasicQueryModels.stream().collect(Collectors.groupingBy(k -> k.getCid() + k.getStaffIdCard()));
            ArrayList<DoseMonitorDataConvertModel> validDoseMonitorConvertModels = new ArrayList<DoseMonitorDataConvertModel>();
            for (DoseMonitorDataConvertModel doseMonitorConvertModel : doseMonitorConvertModels) {
                String cididcard = doseMonitorConvertModel.getCid() + doseMonitorConvertModel.getIdCard();
                List<StaffBasicQueryModel> cididcardStaffList = groupByCidCardIdMap.get(cididcard);
                if (!CollectionUtils.isNotEmpty(cididcardStaffList) || Objects.equals(cididcardStaffList.get(0).getStaffName(), doseMonitorConvertModel.getName())) continue;
                Long doseMonitorId = doseMonitorConvertModel.getDoseMonitorId();
                backDoseMonitorIdList.add(doseMonitorId);
            }
            for (DoseMonitorDataConvertModel doseMonitorConvertModel : doseMonitorConvertModels) {
                Long doseMonitorId = doseMonitorConvertModel.getDoseMonitorId();
                if (backDoseMonitorIdList.contains(doseMonitorId)) {
                    doseMonitorConvertModel.setConvertStaffFailreason("\u59d3\u540d\u548c\u8eab\u4efd\u8bc1\u4e0e\u7cfb\u7edf\u5df2\u5b58\u5728\u6570\u636e\u4e0d\u4e00\u81f4");
                    doseMonitorConvertModel.setIsConvertStaff(DoseMonitorConvertStaffEnum.BACKDATA.getKey());
                    continue;
                }
                validDoseMonitorConvertModels.add(doseMonitorConvertModel);
            }
            return validDoseMonitorConvertModels;
        }
        return doseMonitorConvertModels;
    }

    @XxlJob(value="DoseMonitorTask-syncDoseMonitorStaffData")
    public void syncDoseMonitorStaffData() throws InterruptedException {
        XxlJobHelper.log((String)"--------\u3010\u4e2a\u4eba\u5242\u91cf\u6570\u636e\u8f6c\u6362\u4eba\u5458start\u3011-------", (Object[])new Object[0]);
        log.debug("--------\u3010\u4e2a\u4eba\u5242\u91cf\u6570\u636e\u8f6c\u6362\u4eba\u5458start\u3011-------");
        List needSyncCidList = this.doseMonitorService.listNeedSyncDoseMonitorStaffDataCid();
        if (CollectionUtils.isEmpty((Collection)needSyncCidList)) {
            return;
        }
        block2: for (List partNeedSyncCidList : ListUtil.partition((List)needSyncCidList, (int)100)) {
            int pageSize;
            DoseMonitorParam param = new DoseMonitorParam();
            param.setCids(partNeedSyncCidList);
            do {
                PageHelper.startPage((int)1, (int)1000, (boolean)false);
                List doseMonitorConvertModels = this.doseMonitorService.listNeedSyncDoseMonitorStaffData(param);
                pageSize = doseMonitorConvertModels.size();
                XxlJobHelper.log((String)"\u672c\u6b21\u9700\u8f6c\u6362\u6570\u636e\u6570\uff1a{}", (Object[])new Object[]{pageSize});
                if (CollectionUtils.isEmpty((Collection)doseMonitorConvertModels)) {
                    return;
                }
                HashSet<Long> backDoseMonitorIdList = new HashSet<Long>();
                List<DoseMonitorDataConvertModel> validDoseMonitorConvertModels = this.checkMonitorDataIdcardRealName(doseMonitorConvertModels, backDoseMonitorIdList);
                List<BatchAddStaffModel> batchAddStaffModels = this.convertDoseMonitorStaffData(validDoseMonitorConvertModels);
                try {
                    if (CollectionUtils.isNotEmpty(batchAddStaffModels)) {
                        List saveResult = this.batchAddStaffService.batchSave(batchAddStaffModels);
                        if (CollectionUtils.isNotEmpty((Collection)saveResult)) {
                            BatchAddStaffLogCounter batchAddStaffLogCounter = this.logCounter(saveResult);
                            batchAddStaffLogCounter.setTotal(batchAddStaffModels.size());
                            log.info("\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)batchAddStaffLogCounter.toString());
                            XxlJobHelper.log((String)"\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object[])new Object[]{batchAddStaffLogCounter.toString()});
                        }
                    } else {
                        log.info("\u65e0\u540c\u6b65\u4eba\u5458\u4fe1\u606f");
                        XxlJobHelper.log((String)"\u65e0\u540c\u6b65\u4eba\u5458\u4fe1\u606f", (Object[])new Object[0]);
                    }
                    this.doseMonitorService.updateDoseMonitorDatasStaffFlag(doseMonitorConvertModels);
                    if (!CollectionUtils.isNotEmpty(backDoseMonitorIdList)) continue;
                    this.doseMonitorService.systemBack(backDoseMonitorIdList, "\u59d3\u540d\u548c\u8eab\u4efd\u8bc1\u4e0e\u7cfb\u7edf\u5df2\u5b58\u5728\u6570\u636e\u4e0d\u4e00\u81f4", "\u7cfb\u7edf");
                }
                catch (Exception e) {
                    log.error("\u4eba\u5458\u6279\u91cf\u540c\u6b65\u5f02\u5e38(\u8df3\u8fc7)\uff1a", (Throwable)e);
                    continue block2;
                }
            } while (pageSize >= 1000);
        }
        XxlJobHelper.log((String)"--------\u3010\u4e2a\u4eba\u5242\u91cf\u6570\u636e\u8f6c\u6362\u4eba\u5458end\u3011-------", (Object[])new Object[0]);
        log.debug("--------\u3010\u4e2a\u4eba\u5242\u91cf\u6570\u636e\u8f6c\u6362\u4eba\u5458end\u3011-------");
    }

    public BatchAddStaffLogCounter logCounter(List<BatchAddStaffModel> checkedBatchAddStaffModels) {
        BatchAddStaffLogCounter logCounter = new BatchAddStaffLogCounter();
        if (CollectionUtils.isEmpty(checkedBatchAddStaffModels)) {
            return logCounter;
        }
        for (BatchAddStaffModel bsm : checkedBatchAddStaffModels) {
            if (bsm.getOrganization() != null) {
                if (Objects.equals(bsm.getOrganization().getNewAdd(), true)) {
                    logCounter.getOrganization().getAddCount().incrementAndGet();
                } else {
                    logCounter.getOrganization().getUpdateCount().incrementAndGet();
                }
            }
            if (bsm.getStaffInfo() != null) {
                if (Objects.equals(bsm.getStaffInfo().getNewAdd(), true)) {
                    logCounter.getStaffInfo().getAddCount().incrementAndGet();
                } else {
                    logCounter.getStaffInfo().getUpdateCount().incrementAndGet();
                }
            }
            if (bsm.getStaffBasicInfo() != null) {
                if (Objects.equals(bsm.getStaffBasicInfo().getNewAdd(), true)) {
                    logCounter.getStaffBasicInfo().getAddCount().incrementAndGet();
                } else {
                    logCounter.getStaffBasicInfo().getUpdateCount().incrementAndGet();
                }
            }
            if (bsm.getWorkRoleInfo() != null) {
                if (Objects.equals(bsm.getWorkRoleInfo().getNewAdd(), true)) {
                    logCounter.getWorkRoleInfo().getAddCount().incrementAndGet();
                } else {
                    logCounter.getWorkRoleInfo().getUpdateCount().incrementAndGet();
                }
            }
            if (bsm.getStaffWorkRole() != null) {
                if (Objects.equals(bsm.getStaffWorkRole().getNewAdd(), true)) {
                    logCounter.getStaffWorkRole().getAddCount().incrementAndGet();
                } else {
                    logCounter.getStaffWorkRole().getUpdateCount().incrementAndGet();
                }
            }
            if (bsm.getStaffBasicWork() == null) continue;
            if (Objects.equals(bsm.getStaffBasicWork().getNewAdd(), true)) {
                logCounter.getStaffBasicWork().getAddCount().incrementAndGet();
                continue;
            }
            logCounter.getStaffBasicWork().getUpdateCount().incrementAndGet();
        }
        return logCounter;
    }
}

