/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.task.sys;

import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.es.esservice.ISysLoginStateV2EsService;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.supervise.service.sys.ISysLogService;
import cn.smarthse.modules.health.supervise.service.sys.ISysLoginStatV2Service;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysLoginStatV2Task {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysLoginStatV2Task.class);
    @DubboReference
    ISysLoginStateV2EsService sysLogEsService;
    @Autowired
    private ISysLoginStatV2Service sysLoginStatService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService superviseService;
    @DubboReference(check=false)
    private ISysLogService sysLogService;

    public List<Long> getInvalidCidList() {
        List companySuperviseModels = this.superviseService.listInvalidCid();
        if (CollectionUtils.isNotEmpty((Collection)companySuperviseModels)) {
            return companySuperviseModels.stream().map(CompanyBaseInfoModel::getId).distinct().collect(Collectors.toList());
        }
        return null;
    }

    public void handle(Integer year, String logInfo) {
        List<Integer> systemFlagList = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(7), Integer.valueOf(9), Integer.valueOf(10));
        List<Integer> belongList = List.of(Integer.valueOf(2), Integer.valueOf(0));
        List<Long> listInvalidCid = this.getInvalidCidList();
        List cityLevelCid = this.superviseService.listCityLevelCid(null, null);
        for (Integer systemFlag : systemFlagList) {
            XxlJobHelper.log((String)(logInfo + "\u3011-systemFlag:{},year:{},belongType:{}"), (Object[])new Object[]{systemFlag, year});
            if (Objects.equals(systemFlag, 1) || Objects.equals(systemFlag, 5) || Objects.equals(systemFlag, 7) || Objects.equals(systemFlag, 9) || Objects.equals(systemFlag, 10)) {
                for (Integer belongType : belongList) {
                    List sysLoginStatV2s;
                    ArrayList<Long> notInCidList = new ArrayList<Long>();
                    notInCidList.addAll(listInvalidCid);
                    if (Objects.equals(belongType, 2)) {
                        sysLoginStatV2s = this.sysLogEsService.collectSummaryLoginState(systemFlag, year, belongType, cityLevelCid, notInCidList);
                        this.sysLoginStatService.saveOrUpdates(sysLoginStatV2s);
                        continue;
                    }
                    if (!Objects.equals(belongType, 0)) continue;
                    notInCidList.addAll(cityLevelCid);
                    sysLoginStatV2s = this.sysLogEsService.collectSummaryLoginState(systemFlag, year, belongType, null, notInCidList);
                    this.sysLoginStatService.saveOrUpdates(sysLoginStatV2s);
                }
                continue;
            }
            List sysLoginStatV2s = this.sysLogEsService.collectSummaryLoginState(systemFlag, year, Integer.valueOf(0), null, null);
            this.sysLoginStatService.saveOrUpdates(sysLoginStatV2s);
        }
    }

    @XxlJob(value="SysLoginStatV2Task-loginAllState")
    public void loginAllState() {
        log.info("\u3010\u8d26\u53f7\u6d3b\u8dc3\u5ea6V2\u7edf\u8ba1\u6240\u6709\u5386\u53f2\u6570\u636e\u3011-start");
        ArrayList<Integer> yearsList = new ArrayList<Integer>();
        for (int i = DateUtil.getYear(); i >= 2023; --i) {
            yearsList.add(i);
        }
        for (Integer year : yearsList) {
            this.handle(year, "\u8d26\u53f7\u6d3b\u8dc3\u5ea6V2\u7edf\u8ba1\u6240\u6709\u5386\u53f2\u6570\u636e");
        }
        log.info("\u3010\u8d26\u53f7\u6d3b\u8dc3\u5ea6V2\u7edf\u8ba1\u6240\u6709\u5386\u53f2\u6570\u636e\u3011-end");
    }

    @XxlJob(value="SysLoginStatV2Task-currYearStatV2Task")
    public void currYearStatV2Task() {
        log.info("\u3010\u8d26\u53f7\u6d3b\u8dc3\u5ea6\u5f53\u524d\u5e74\u4efdV2\u7edf\u8ba1\u3011-start");
        Integer year = DateUtil.getYear();
        this.handle(year, "\u8d26\u53f7\u6d3b\u8dc3\u5ea6\u5f53\u524d\u5e74\u4efdV2\u7edf\u8ba1");
        log.info("\u3010\u8d26\u53f7\u6d3b\u8dc3\u5ea6\u5f53\u524d\u5e74\u4efdV2\u7edf\u8ba1\u3011-end");
    }

    @XxlJob(value="SysLoginStatV2Task-currDayStatV2Task")
    public void currDayStatV2Task() {
        log.info("\u3010\u8d26\u53f7\u6d3b\u8dc3\u5ea6\u5f53\u5929V2\u7edf\u8ba1\u3011-start");
        this.handle(0, "\u8d26\u53f7\u6d3b\u8dc3\u5ea6\u5f53\u5929V2\u7edf\u8ba1");
        log.info("\u3010\u8d26\u53f7\u6d3b\u8dc3\u5ea6\u5f53\u5929V2\u7edf\u8ba1\u3011-end");
    }

    @XxlJob(value="SysLogTask-syncAreaIsnull")
    public void syncAreaIsnull() {
        log.info("\u3010\u7edf\u8ba1\u767b\u5f55\u8bb0\u5f55\u884c\u653f\u533a\u5212\u4e3a\u7a7a\u7684\u6570\u636e\u3011-start");
        this.sysLogService.collectAreaIsNullLogTask();
        log.info("\u3010\u7edf\u8ba1\u767b\u5f55\u8bb0\u5f55\u884c\u653f\u533a\u5212\u4e3a\u7a7a\u7684\u6570\u636e\u3011-end");
    }
}

