/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.task.sys;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.es.esservice.ICompanyEsService;
import cn.smarthse.es.esservice.ISysLoginLogEsService;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.entity.sys.SysLoginStat;
import cn.smarthse.modules.health.supervise.dao.sys.SysLoginStatMapper;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.sys.ISysLoginStatService;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class SysLoginStatTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysLoginStatTask.class);
    @DubboReference
    ISysLoginLogEsService sysLogEsService;
    @DubboReference
    ICompanyEsService companyEsService;
    @Autowired
    ISysLoginStatService loginStatService;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService companyService;
    @DubboReference
    IThirdOrganizationService thirdOrganizationService;
    @DubboReference
    IOrganizationService organizationService;

    @XxlJob(value="SysLoginStatTask-syncCompanyInfo")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void syncCompanyInfo() {
        CompanySuperviseSearchModel searchVo = new CompanySuperviseSearchModel();
        searchVo.setIsTest(Boolean.valueOf(false));
        searchVo.setSuperviseIsDel(Boolean.valueOf(false));
        searchVo.setSuperviseIsHide(Boolean.valueOf(false));
        searchVo.setIsValid(Boolean.valueOf(true));
        List companySuperviseModels = this.companyService.selectIdName(searchVo);
        if (CollectionUtils.isNotEmpty((Collection)companySuperviseModels)) {
            for (List partList : ListUtil.partition((List)companySuperviseModels, (int)10000)) {
                List comIdList = partList.stream().map(companySuperviseModel -> companySuperviseModel.getId()).distinct().collect(Collectors.toList());
                Date loadDate = new Date();
                XxlJobHelper.log((String)"companySuperviseModels size:{}", (Object[])new Object[]{companySuperviseModels.size()});
                List loginedCidList = this.sysLogEsService.getLoginedCidList(comIdList);
                XxlJobHelper.log((String)"\u5df2\u767b\u5f55\u8fc7\u5f97cid size:{}", (Object[])new Object[]{loginedCidList.size()});
                HashSet loginedCidSet = new HashSet(loginedCidList);
                long count = 0L;
                for (List superviseModels : ListUtil.partition((List)companySuperviseModels, (int)2000)) {
                    XxlJobHelper.log((String)"\u5904\u7406\u6570\u636e\u6761\u6570:{}", (Object[])new Object[]{count += (long)superviseModels.size()});
                    this.companyEsService.batchAdd(superviseModels, loadDate, loginedCidSet);
                }
            }
        }
    }

    @XxlJob(value="SysLoginStatTask-task")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void task() {
        try {
            List sysLoginStats;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String startTime = dateFormat.format(new Date());
            log.info("\u8d26\u53f7\u6d3b\u8dc3\u5ea6\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4 \uff1a " + startTime);
            String jobParam = XxlJobHelper.getJobParam();
            Date date = null;
            if (!"all".equalsIgnoreCase(jobParam)) {
                date = this.loginStatService.getMaxLastLoginDate();
            }
            if (CollectionUtils.isEmpty(sysLoginStats = null)) {
                return;
            }
            List allCid = this.loginStatService.getAllCid();
            Map<String, Long> cidMap = allCid.stream().collect(Collectors.toMap(k -> this.genKey((SysLoginStat)k), v -> v.getId(), (v1, v2) -> v2));
            ArrayList<SysLoginStat> addList = new ArrayList<SysLoginStat>();
            ArrayList<SysLoginStat> updateList = new ArrayList<SysLoginStat>();
            for (SysLoginStat sysLoginStat : sysLoginStats) {
                String key = this.genKey(sysLoginStat);
                if (cidMap.containsKey(key)) {
                    Long aLong = cidMap.get(key);
                    sysLoginStat.setId(aLong);
                    updateList.add(sysLoginStat);
                    continue;
                }
                addList.add(sysLoginStat);
            }
            if (CollectionUtils.isNotEmpty(addList)) {
                ListUtil.partition(addList, (int)1000).forEach(itemList -> this.loginStatService.batchUpdateOrInsert(itemList, SysLoginStatMapper.class, (item, dao) -> dao.insert(item)));
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                ListUtil.partition(updateList, (int)1000).forEach(itemList -> this.loginStatService.batchUpdateOrInsert(itemList, SysLoginStatMapper.class, (item, dao) -> {
                    item.setUpdateDate(new Date());
                    item.setCreateDate(null);
                    return dao.updateByPrimaryKeySelective(item);
                }));
            }
            String endTime = dateFormat.format(new Date());
            log.info("\u8d26\u53f7\u6d3b\u8dc3\u5ea6\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4 \uff1a " + endTime);
        }
        catch (Exception e) {
            log.error("\u8d26\u53f7\u6d3b\u8dc3\u5ea6\u4efb\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private String genKey(SysLoginStat k) {
        Long cid = k.getCid();
        Byte logSource = k.getLogSource();
        return StringUtils.concatStr((String)"", (String[])new String[]{cid == null ? "" : cid.toString(), logSource == null ? "" : logSource.toString()});
    }
}

