/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.task.risk;

import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate;
import cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluateData;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateDataService;
import cn.smarthse.services.hfi.api.service.riskev.IRiskExposeEvaluateService;
import cn.smarthse.snowflake.IdWorker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RiskDataSyncTask {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @DubboReference
    private IRiskExposeEvaluateService riskExposeEvaluateService;
    @DubboReference
    private IRiskExposeEvaluateDataService riskExposeEvaluateDataService;
    @Autowired
    private IWorkOperateLogService workOperateLogService;
    protected static String driver = "com.mysql.cj.jdbc.Driver";
    protected static String dbUrl = "jdbc:mysql://smarthse.51vip.biz:3306/risk_expose_share?useUnicode=true&characterEncoding=utf8&serverTimezone=Asia/Shanghai";
    protected static String dbUser = "ehs-root2";
    protected static String dbPass = "test1234567";
    private String getRiskEvaSql = "select id,type,org_id orgId,cid,work_no workNo,project_name projectName,check_date checkDateStr,check_date_end checkDateEndStr,target_standard_id targetStandardId,project_area_id projectAreaId,project_address projectAddress,report_status reportStatus,report_date reportDateStr,data_update_date dataUpdateDateStr,risk_level riskLevel,create_date createDateStr,create_by createBy,update_by updateBy,update_date updateDateStr  from risk_expose_evaluate where risk_level is null";
    private String getRiskEvaDataSql = "select DISTINCT d.id id,d.risk_expose_evaluate_id riskExposeEvaluateId,d.workshop,d.work_name workName,d.work_num workNum,d.check_point checkPoint,d.factor_id factorId, d.factor_name factorName,d.ctwa ctwa,d.cste cste,d.cstel cstel,d.cmac cmac,d.cme cme,d.exceed_limit exceedLimit,d.pe_pc_twa pePcTwa,d.noise_level noiseLevel,d.other_factor_value otherFactorValue,d.touch_level touchLevel,d.check_touch_level checkTouchLevel,d.factor_nature factorNature,d.factor_attr_twa factorAttrTwa,d.create_date createDateStr,d.create_by createBy,d.update_by updateBy,d.update_date updateDateStr from risk_expose_evaluate_data d INNER join risk_expose_evaluate r on r.id=d.risk_expose_evaluate_id where r.risk_level is null";
    @Autowired
    protected IdWorker idworker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRiskData() throws IOException {
        QueryRunner qr = new QueryRunner();
        String connId = "" + this.idworker.nextId();
        Connection conn = this.getConnection(connId);
        StringBuilder updateStr = new StringBuilder();
        StringBuilder riskStr = new StringBuilder();
        StringBuilder logStr = new StringBuilder();
        StringBuilder dateStr = new StringBuilder();
        try {
            List result = (List)qr.query(conn, this.getRiskEvaSql, (ResultSetHandler)new BeanListHandler(RiskExposeEvaluate.class));
            List dataResult = (List)qr.query(conn, this.getRiskEvaDataSql, (ResultSetHandler)new BeanListHandler(RiskExposeEvaluateData.class));
            this.setRiskDate(result);
            this.setDataDate(dataResult);
            if (dataResult != null) {
                this.riskExposeEvaluateDataService.saveBatch((Collection)dataResult);
            }
            if (result != null) {
                this.riskExposeEvaluateService.saveBatch((Collection)result);
            }
            result = this.riskExposeEvaluateService.updateRiskLevelNew(result);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if (result != null) {
                for (RiskExposeEvaluate risk : result) {
                    String updateSql = "update  risk_expose_evaluate set risk_level=" + risk.getRiskLevel() + " where id=" + risk.getId() + ";";
                    String logSql = this.workOperateLogService.reportLogSql(risk.getId(), WorkOperateLogEnum.investigationRiskAssessment.getTypeVal(), Long.valueOf(2179614949624832L), "\u6d59\u6c5f\u7701\u75be\u75c5\u9884\u9632\u63a7\u5236\u4e2d\u5fc3", "\u6d59\u6c5f\u7701\u75be\u75c5\u9884\u9632\u63a7\u5236\u4e2d\u5fc3");
                    logStr.append(logSql);
                    logStr.append("\r\n");
                    updateStr.append(updateSql);
                    updateStr.append("\r\n");
                    String riskSql = "INSERT INTO risk_expose_evaluate VALUES (" + risk.getId() + "," + risk.getType() + ", NULL," + risk.getOrgId() + " , " + risk.getCid() + ", '" + risk.getWorkNo() + "', '" + risk.getProjectName() + "', '" + risk.getCheckDateStr() + "', '" + risk.getCheckDateEndStr() + "', " + risk.getTargetStandardId() + ", " + risk.getProjectAreaId() + ", '" + risk.getProjectAddress() + "', 2, '" + risk.getReportDateStr() + "', NULL, '" + risk.getDataUpdateDateStr() + "', " + risk.getRiskLevel() + ", 0, 1, 2179614949624832, '" + risk.getCreateDateStr() + "', 2179614949624832, '" + risk.getUpdateDateStr() + "');";
                    riskStr.append(riskSql);
                    riskStr.append("\r\n");
                }
            }
            if (dataResult != null) {
                for (RiskExposeEvaluate risk : dataResult) {
                    String dataSql = "INSERT INTO risk_expose_evaluate_data VALUES (" + risk.getId() + ", " + risk.getRiskExposeEvaluateId() + ", '" + risk.getWorkshop() + "', '" + risk.getWorkName() + "', " + risk.getWorkNum() + ", '" + risk.getCheckPoint() + "', '" + risk.getFactorId() + "', '" + risk.getFactorName() + "', '" + risk.getCtwa() + "', '" + risk.getCstel() + "', '" + risk.getCste() + "', '" + risk.getCmac() + "', '" + risk.getCme() + "', '" + risk.getExceedLimit() + "', '" + risk.getPePcTwa() + "', NULL, '" + risk.getNoiseLevel() + "', '" + risk.getOtherFactorValue() + "', " + risk.getTouchLevel() + ", " + risk.getCheckTouchLevel() + ", " + risk.getFactorNature() + ", 1, '" + risk.getFactorAttrTwa() + "', 0, 1, 2179614949624832, '" + risk.getCreateDateStr() + "', 2179614949624832, '" + risk.getUpdateDateStr() + "');";
                    dateStr.append(dataSql);
                    dateStr.append("\r\n");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.error("RiskDataSyncTask::\u67e5\u8be2\u6570\u636e\u5f02\u5e38::", (Throwable)e);
        }
        finally {
            try {
                conn.close();
                this.logger.info("\u6570\u636e\u8fde\u63a5\u5f02\u5e38,connId=" + connId);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.logger.error("RiskDataSyncTask::\u5173\u95ed\u8fde\u63a5\u5f02\u5e38:", (Throwable)e);
            }
        }
        String word = updateStr.toString() + riskStr.toString() + dateStr.toString() + logStr.toString();
        FileOutputStream fileOutputStream = null;
        File file = new File("E:/testfile/test.txt");
        if (!file.exists()) {
            file.createNewFile();
        }
        fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(word.getBytes("gbk"));
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private void setDataDate(List<RiskExposeEvaluateData> dataResult) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (dataResult != null) {
            for (RiskExposeEvaluateData risk : dataResult) {
                risk.setCreateDate(LocalDateTime.parse(risk.getCreateDateStr(), formatter));
                risk.setUpdateDate(LocalDateTime.parse(risk.getUpdateDateStr(), formatter));
                if (risk.getCheckTouchLevel() != null) continue;
                risk.setCheckTouchLevel(Integer.valueOf(2));
                risk.setTouchLevel(Integer.valueOf(2));
            }
        }
    }

    private void setRiskDate(List<RiskExposeEvaluate> result) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        if (result != null) {
            for (RiskExposeEvaluate risk : result) {
                if (risk.getCheckDateStr() != null) {
                    risk.setCheckDate(LocalDateTime.parse(risk.getCheckDateStr(), formatter));
                }
                if (risk.getCheckDateEndStr() != null) {
                    risk.setCheckDateEnd(LocalDateTime.parse(risk.getCheckDateEndStr(), formatter));
                }
                if (risk.getReportDateStr() != null) {
                    risk.setReportDate(LocalDateTime.parse(risk.getReportDateStr(), formatter));
                }
                if (risk.getDataUpdateDateStr() != null) {
                    risk.setDataUpdateDate(LocalDateTime.parse(risk.getDataUpdateDateStr(), formatter));
                }
                risk.setCreateDate(LocalDateTime.now());
                risk.setUpdateDate(LocalDateTime.now());
            }
        }
    }

    private Connection getConnection(String connId) {
        try {
            this.logger.info("\u83b7\u53d6\u6570\u636e\u8fde\u63a5,connId=" + connId);
            return DriverManager.getConnection(dbUrl, dbUser, dbPass);
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.error("RiskDataSyncTask::\u6570\u636e\u8fde\u63a5\u5f02\u5e38::", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

