/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.task.phc;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformLastOrgInfo;
import cn.smarthse.modules.health.enums.check.v3221.PhyPhcCheckTypeEnum;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.supervise.dao.phc.PhcCheckResultMapper;
import cn.smarthse.modules.health.supervise.vo.phccheck.LastPhcCheckReportResultVo;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class PhcCheckResultTask {
    Logger logger = LoggerFactory.getLogger(PhcCheckResultTask.class);
    @Autowired
    PhcCheckResultMapper phcCheckResultMapper;
    @Autowired
    IReformItemBasicService itemBasicService;
    @Autowired
    ThreadPoolExecutor threadPoolExecutor;
    @DubboReference(version="1.0.0")
    ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    ICheckPlanService checkPlanService;

    @XxlJob(value="PhcCheckResultTask-lastCheckTask")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void lastCheckTask() throws InterruptedException {
        this.logger.info("\u4f53\u68c0\u7ed3\u679c\u7edf\u8ba1\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        String jobParam = XxlJobHelper.getJobParam();
        JSONObject jsonObject = JSON.parseObject((String)jobParam);
        Long cidParam = jsonObject != null ? (jsonObject.containsKey((Object)"cid") ? jsonObject.getLong("cid") : null) : null;
        CountDownLatch cdl = new CountDownLatch(6);
        HashSet allCidSet = new HashSet();
        HashMap reformMap = new HashMap();
        HashMap newPhcPhysicalChecksMap = new HashMap();
        HashMap newCheckMap = new HashMap();
        HashMap collectPhcNumMap = new HashMap();
        HashMap dbIdCidMap = new HashMap();
        this.threadPoolExecutor.execute(() -> {
            List<LastPhcCheckReportResultVo> allLastReportIdList = this.phcCheckResultMapper.collectLastPhcResult(cidParam);
            if (CollectionUtils.isNotEmpty(allLastReportIdList)) {
                Map<Long, LastPhcCheckReportResultVo> collect = allLastReportIdList.stream().collect(Collectors.toMap(LastPhcCheckReportResultVo::getCid, v -> v));
                collectPhcNumMap.putAll(collect);
            }
            XxlJobHelper.log((String)"1\u7edf\u8ba1\u4f53\u68c0\u6570\u636e\u5b8c\u6210...", (Object[])new Object[0]);
            cdl.countDown();
        });
        this.threadPoolExecutor.execute(() -> {
            List<PhcPhysicalCheck> allLastReportIdList = this.phcCheckResultMapper.selectId(cidParam);
            if (CollectionUtils.isNotEmpty(allLastReportIdList)) {
                Map<Long, Long> collect = allLastReportIdList.stream().collect(Collectors.toMap(PhcPhysicalCheck::getCid, PhcPhysicalCheck::getId));
                dbIdCidMap.putAll(collect);
            }
            XxlJobHelper.log((String)"2\u67e5\u8be2\u62a5\u8868\u6570\u636e\u5b8c\u6210...", (Object[])new Object[0]);
            cdl.countDown();
        });
        this.threadPoolExecutor.execute(() -> {
            CompanySuperviseSearchModel searchModel = new CompanySuperviseSearchModel();
            searchModel.setId(cidParam);
            List companySuperviseModels = this.companyProvideBySuperviseService.allCompanyId(searchModel);
            Set allCidSetTemp = companySuperviseModels.stream().mapToLong(CompanyBaseInfoModel::getId).boxed().collect(Collectors.toSet());
            allCidSet.addAll(allCidSetTemp);
            XxlJobHelper.log((String)"3\u67e5\u8be2\u6240\u6709\u4f01\u4e1a\u6570\u636e\u5b8c\u6210...", (Object[])new Object[0]);
            cdl.countDown();
        });
        this.threadPoolExecutor.execute(() -> {
            List lastCheckPlanGroupByCid = this.checkPlanService.getLastCheckPlanGroupByCid2(cidParam == null ? null : Arrays.asList(cidParam), null);
            if (CollectionUtils.isNotEmpty((Collection)lastCheckPlanGroupByCid)) {
                Map<Long, CheckPlan> collect = lastCheckPlanGroupByCid.stream().collect(Collectors.toMap(CheckPlan::getCid, v -> v));
                newCheckMap.putAll(collect);
            }
            XxlJobHelper.log((String)"4\u7edf\u8ba1\u6700\u65b0\u7684\u68c0\u6d4b\u6570\u636e\u5b8c\u6210...", (Object[])new Object[0]);
            cdl.countDown();
        });
        this.threadPoolExecutor.execute(() -> {
            List<PhcPhysicalCheck> phcPhysicalChecks1 = this.phcCheckResultMapper.lastPhcLastReport(cidParam);
            if (CollectionUtils.isNotEmpty(phcPhysicalChecks1)) {
                Map<Long, PhcPhysicalCheck> collect = phcPhysicalChecks1.stream().collect(Collectors.toMap(PhcPhysicalCheck::getCid, v -> v));
                newPhcPhysicalChecksMap.putAll(collect);
            }
            XxlJobHelper.log((String)"5\u7edf\u8ba1\u6700\u65b0\u7684\u4f53\u68c0\u6570\u636e\u5b8c\u6210...", (Object[])new Object[0]);
            cdl.countDown();
        });
        this.threadPoolExecutor.execute(() -> {
            List lastOrgInfo1 = this.itemBasicService.getLastOrgInfo(cidParam == null ? null : Arrays.asList(cidParam));
            if (CollectionUtils.isNotEmpty((Collection)lastOrgInfo1)) {
                Map<Long, ReformLastOrgInfo> collect = lastOrgInfo1.stream().collect(Collectors.toMap(ReformLastOrgInfo::getCid, v -> v));
                reformMap.putAll(collect);
            }
            XxlJobHelper.log((String)"6\u7edf\u8ba1\u6700\u65b0\u7684\u98ce\u9669\u6570\u636e\u6570\u636e\u5b8c\u6210...", (Object[])new Object[0]);
            cdl.countDown();
        });
        cdl.await(5L, TimeUnit.MINUTES);
        XxlJobHelper.log((String)"7\u6240\u6709\u6570\u636e\u67e5\u8be2\u5b8c\u6210...", (Object[])new Object[0]);
        ArrayList<LastPhcCheckReportResultVo> addList = new ArrayList<LastPhcCheckReportResultVo>();
        ArrayList<LastPhcCheckReportResultVo> updateList = new ArrayList<LastPhcCheckReportResultVo>();
        for (Long cid : allCidSet) {
            LastPhcCheckReportResultVo result = new LastPhcCheckReportResultVo();
            result.setCid(cid);
            LastPhcCheckReportResultVo lastPhcCheckReportResultVo = (LastPhcCheckReportResultVo)collectPhcNumMap.get(cid);
            if (lastPhcCheckReportResultVo != null) {
                BeanUtils.copyProperties((Object)lastPhcCheckReportResultVo, (Object)result);
            }
            ReformLastOrgInfo reform = (ReformLastOrgInfo)reformMap.get(cid);
            PhcPhysicalCheck phcPhysicalCheck = (PhcPhysicalCheck)newPhcPhysicalChecksMap.get(cid);
            CheckPlan check = (CheckPlan)newCheckMap.get(cid);
            if (phcPhysicalCheck != null) {
                result.setLastPhyId(phcPhysicalCheck.getId());
                result.setLastPhyOrgName(phcPhysicalCheck.getThirdOrgName());
                result.setPhyType(phcPhysicalCheck.getBodyCheckType());
                result.setLastPhyOrgDate(DateUtils.parseDate((Object)phcPhysicalCheck.getCheckTime()));
            } else if (reform != null) {
                result.setPhyType(Integer.valueOf(PhyPhcCheckTypeEnum.ON.getCode().intValue()));
                result.setLastPhyOrgName(reform.getLastPhcOrgName());
                result.setLastPhyOrgDate(reform.getLastPhcAcceptanceDate());
            }
            if (check != null) {
                result.setLastCheckId(check.getId());
                result.setLastCheckOrgName(check.getThirdOrgName());
                Date date = DateUtils.localDateTimeToDate((LocalDateTime)check.getCheckDateBegin());
                result.setLastCheckOrgDate(date);
            } else if (reform != null) {
                result.setLastCheckOrgName(reform.getLastDetectionOrgName());
                result.setLastCheckOrgDate(reform.getLastDetectionOrgDate());
            }
            Long reportId = (Long)dbIdCidMap.get(cid);
            if (reportId == null) {
                result.setCreateDate(new Date());
                result.setId(Long.valueOf(IdWorker.getId()));
                addList.add(result);
                continue;
            }
            result.setUpdateDate(new Date());
            result.setId(reportId);
            updateList.add(result);
        }
        XxlJobHelper.log((String)"\u66f4\u65b0\u6570\u636e{}\u6761...", (Object[])new Object[]{updateList.size()});
        ListUtil.partition(updateList, (int)1000).forEach(list -> this.phcCheckResultMapper.updateLastReportResult((List<LastPhcCheckReportResultVo>)list));
        XxlJobHelper.log((String)"\u65b0\u589e\u6570\u636e{}\u6761...", (Object[])new Object[]{addList.size()});
        ListUtil.partition(addList, (int)1000).forEach(list -> this.phcCheckResultMapper.inserts((List<LastPhcCheckReportResultVo>)list));
        this.logger.info("\u4f53\u68c0\u7ed3\u679c\u7edf\u8ba1\u7ed3\u675f-->" + DateUtils.formatDateTime((Date)new Date()));
    }
}

