/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.task.onlinemonitor;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.enums.CompanyCreditSuperviseSourceEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.newcompliance.entity.NewComplianceCompanyInfo;
import cn.smarthse.modules.health.newcompliance.service.INewComplianceCompanyInfoService;
import cn.smarthse.modules.health.onlineMonitoring.vo.OnlineDeviceCreditSupervise;
import cn.smarthse.modules.health.supervise.dao.company.CompanyDcMapper;
import cn.smarthse.modules.health.supervise.service.onlineMonitoring.IOnlineDeviceService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CreditSuperviseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreditSuperviseTask.class);
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyService;
    @Autowired
    private IOnlineDeviceService deviceService;
    @Autowired
    private CompanyDcMapper companyDcMapper;
    @Autowired
    private INewComplianceCompanyInfoService companyInfoService;

    @XxlJob(value="CreditSuperviseTask-updateCreditSupervise")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void updateCreditSupervise(List<Long> cids) {
        List complianceCompanyInfos;
        List<Company> trainingBaseList;
        Long cid;
        JSONObject jsonObj;
        String jobParam;
        log.info("\u66f4\u65b0\u4f01\u4e1a\u4fe1\u7528\u76d1\u7ba1\u72b6\u6001start..");
        if (CollectionUtils.isEmpty(cids) && StringUtils.isNotBlank((CharSequence)(jobParam = XxlJobHelper.getJobParam())) && (jsonObj = JSON.parseObject((String)jobParam)) != null && (cid = jsonObj.getLong("cid")) != null) {
            cids = List.of(cid);
        }
        List hasJcJkDeviceList = this.deviceService.getHasJcJkDeviceCid(cids);
        Map<Object, Object> oldCreditSuperviseSet = new HashMap();
        HashMap<Long, Set> creditSuperviseMap = new HashMap<Long, Set>();
        if (CollectionUtils.isNotEmpty((Collection)hasJcJkDeviceList)) {
            oldCreditSuperviseSet = hasJcJkDeviceList.stream().filter(f -> Objects.equals(f.getCreditSupervise(), 1)).collect(Collectors.toMap(OnlineDeviceCreditSupervise::getCid, OnlineDeviceCreditSupervise::getCreditSuperviseSource));
            Set onlineDeviceCidSet = hasJcJkDeviceList.stream().filter(f -> f.getDeviceId() > 0L).map(OnlineDeviceCreditSupervise::getCid).collect(Collectors.toSet());
            for (Object cid2 : onlineDeviceCidSet) {
                creditSuperviseMap.computeIfAbsent((Long)cid2, k -> new HashSet()).add(CompanyCreditSuperviseSourceEnum.ONLINE_DEVICE.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty(trainingBaseList = this.companyDcMapper.listStandardTrainingBase(cids))) {
            Set trainingBaseSet = trainingBaseList.stream().map(Company::getId).collect(Collectors.toSet());
            for (Long l : trainingBaseSet) {
                creditSuperviseMap.computeIfAbsent(l, k -> new HashSet()).add(CompanyCreditSuperviseSourceEnum.TRAININGBASE.getCode());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(complianceCompanyInfos = this.companyInfoService.listReformRemainDateInfo(cids)))) {
            Set complianceCidSet = complianceCompanyInfos.stream().map(NewComplianceCompanyInfo::getCid).collect(Collectors.toSet());
            for (Long cid4 : complianceCidSet) {
                creditSuperviseMap.computeIfAbsent(cid4, k -> new HashSet()).add(CompanyCreditSuperviseSourceEnum.COMPLIANCECOMPANY.getCode());
            }
        }
        for (Long l : creditSuperviseMap.keySet()) {
            boolean isEqual;
            Set dataSourceSet = (Set)creditSuperviseMap.get(l);
            String oldCreditSuperviseSources = (String)oldCreditSuperviseSet.get(l);
            ArrayList oldDataSourceSet = CommonUtil.str2IntegerList((String)oldCreditSuperviseSources, (String)",");
            if (oldDataSourceSet == null) {
                oldDataSourceSet = new ArrayList();
            }
            if (isEqual = dataSourceSet.size() == oldDataSourceSet.size() && CollUtil.containsAll((Collection)dataSourceSet, oldDataSourceSet)) continue;
            CompanySuperviseModel c = new CompanySuperviseModel();
            c.setId(l);
            c.setCreditSupervise(Integer.valueOf(1));
            c.setCreditSuperviseSource(StringUtils.join((Iterable)dataSourceSet, (String)","));
            this.companyService.updateCompanyOnlyBaseInfo(c, null);
            XxlJobHelper.log((String)"cid:{}, \u4fee\u6539\u4fe1\u7528\u76d1\u7ba1\u4fe1\u606f\uff0coldDataSourceSet\uff1a{}\uff0c dataSourceSet\uff1a{} ", (Object[])new Object[]{c.getId(), oldCreditSuperviseSources, StringUtils.join((Iterable)dataSourceSet, (String)",")});
        }
        for (Long l : oldCreditSuperviseSet.keySet()) {
            if (creditSuperviseMap.containsKey(l)) continue;
            CompanySuperviseModel c = new CompanySuperviseModel();
            c.setId(l);
            c.setCreditSupervise(Integer.valueOf(0));
            c.setCreditSuperviseSource("");
            XxlJobHelper.log((String)"cid:{}, \u539f\u4fe1\u7528\u76d1\u7ba1\u4e3a1\uff0c \u66f4\u65b0\u4fe1\u7528\u76d1\u7ba1\u72b6\u6001\u4e3a0", (Object[])new Object[]{c.getId()});
            this.companyService.updateCompanyOnlyBaseInfo(c, null);
        }
        log.info("\u66f4\u65b0\u4f01\u4e1a\u4fe1\u7528\u76d1\u7ba1\u72b6\u6001end..");
    }
}

