/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.task.companygrade;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.enums.company.grade.CompanyGradeEventSource;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeWorkProgressService;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.CompanyGradeV3CollectService;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.CompanyGradeV3CollectServiceV2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CompanyGradeV3Task {
    @Autowired
    private CompanyGradeV3CollectService collectCompanyGrade;
    @Autowired
    private CompanyGradeV3CollectServiceV2 collectCompanyGradeV2;
    @Autowired
    private ICompanyGradeWorkProgressService workProgressService;
    @Autowired
    private ICompanyGradeV3Service gradeV3Service;
    Logger logger = LoggerFactory.getLogger(CompanyGradeV3Task.class);

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    @XxlJob(value="CompanyGradeV3Task-gradeTaskold")
    public void gradeTask() {
        Long cid;
        JSONObject jsonObj;
        ArrayList<Long> cids = new ArrayList<Long>();
        CompanyGradeEventSource eventSource = null;
        String jobParam = XxlJobHelper.getJobParam();
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null && (cid = jsonObj.getLong("cid")) != null) {
            cids.add(cid);
            eventSource = CompanyGradeEventSource.getEnumByValue((Byte)jsonObj.getByte("eventSource"));
        }
        this.logger.info("\u4f01\u4e1a\u5206\u7ea7\u5206\u7c7bV3\u7edf\u8ba1\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        this.collectCompanyGrade.collectCompanyGrade(cids, eventSource);
        this.logger.info("\u4f01\u4e1a\u5206\u7ea7\u5206\u7c7bV3\u7edf\u8ba1\u7ed3\u675f-->" + DateUtils.formatDateTime((Date)new Date()));
    }

    @XxlJob(value="CompanyGradeV3Task-gradeTask")
    public void gradeTaskV2() {
        Long cid;
        JSONObject jsonObj;
        ArrayList<Long> cids = new ArrayList<Long>();
        CompanyGradeEventSource eventSource = null;
        String jobParam = XxlJobHelper.getJobParam();
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null && (cid = jsonObj.getLong("cid")) != null) {
            cids.add(cid);
            eventSource = CompanyGradeEventSource.getEnumByValue((Byte)jsonObj.getByte("eventSource"));
        }
        this.logger.info("\u4f01\u4e1a\u5206\u7ea7\u5206\u7c7bV3\u7edf\u8ba1\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        this.collectCompanyGradeV2.refreshAllGrade(cids, eventSource);
        this.logger.info("\u4f01\u4e1a\u5206\u7ea7\u5206\u7c7bV3\u7edf\u8ba1\u7ed3\u675f-->" + DateUtils.formatDateTime((Date)new Date()));
    }

    @XxlJob(value="CompanyGradeV3Task-workProcessTask")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void workProcessTask() {
        this.logger.info("\u5206\u7c7b\u5de5\u4f5c\u8fdb\u5ea6\u7edf\u8ba1\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        this.workProgressService.collectWorkProcess();
        this.logger.info("\u5206\u7c7b\u5de5\u4f5c\u8fdb\u5ea6\u7edf\u8ba1\u7ed3\u675f-->" + DateUtils.formatDateTime((Date)new Date()));
    }

    @XxlJob(value="CompanyGradeV3Task-rank")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void workProcessRankTask() {
        this.logger.info("\u5206\u7c7b\u5de5\u4f5c\u6392\u540d\u7edf\u8ba1\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        this.gradeV3Service.workProcessRankTask();
        this.logger.info("\u5206\u7c7b\u5de5\u4f5c\u6392\u540d\u7edf\u8ba1\u7ed3\u675f-->" + DateUtils.formatDateTime((Date)new Date()));
    }
}

