/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.task.company;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.supervise.enums.company.grade.OccTypeChangeEvent;
import cn.smarthse.modules.health.supervise.service.company.ICompanyPickupCountService;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeWorkProgressService;
import cn.smarthse.modules.health.supervise.service.company.impl.grade.CompanyGradeV3CollectServiceV2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CompanyPickupCountTask {
    Logger logger = LoggerFactory.getLogger(CompanyPickupCountTask.class);
    @Autowired
    ICompanyPickupCountService companyPickupCountService;
    @Autowired
    private CompanyGradeV3CollectServiceV2 collectCompanyGrade;
    @Autowired
    private IDcCompanyService dcCompanyService;
    @Autowired
    private ICompanyGradeWorkProgressService workProgressService;

    @XxlJob(value="CompanyPickupCountTask-pickUpCountTask")
    public void pickUpCountTask() throws InterruptedException {
        Long cid;
        JSONObject jsonObj;
        ArrayList<Long> cids = new ArrayList<Long>();
        String jobParam = XxlJobHelper.getJobParam();
        if (StringUtils.isNotBlank((CharSequence)jobParam) && (jsonObj = JSON.parseObject((String)jobParam)) != null && (cid = jsonObj.getLong("cid")) != null) {
            cids.add(cid);
        }
        try {
            XxlJobHelper.log((String)"\u63a5\u5bb3\u4eba\u6570\u7edf\u8ba1\u5f00\u59cb-->", (Object[])new Object[0]);
            this.companyPickupCountService.handHarmNum(cids);
            XxlJobHelper.log((String)"\u63a5\u5bb3\u4eba\u6570\u7edf\u8ba1\u7ed3\u675f-->", (Object[])new Object[0]);
            XxlJobHelper.log((String)"\u4f01\u4e1a\u5206\u7ea7\u5206\u7c7bV3\u7edf\u8ba1\u5f00\u59cb-->", (Object[])new Object[0]);
            this.collectCompanyGrade.refreshAllGrade(null, null);
            XxlJobHelper.log((String)"\u4f01\u4e1a\u5206\u7ea7\u5206\u7c7bV3\u7edf\u8ba1\u7ed3\u675f-->", (Object[])new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("\u5f02\u5e38\u51fa\u9519\uff1a", (Throwable)e);
            XxlJobHelper.log((String)"\u5f02\u5e38\u51fa\u9519-->", (Object[])new Object[0]);
        }
    }

    @XxlJob(value="CompanyPickupCountTask-recordLastYearHarmNum")
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void recordLastYearHarmNum() {
        this.logger.info("\u8bb0\u5f55\u53bb\u5e74\u63a5\u5bb3\u4eba\u6570\u7edf\u8ba1\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        this.companyPickupCountService.recordLastYearHarmNum(null);
        this.logger.info("\u8bb0\u5f55\u53bb\u5e74\u63a5\u5bb3\u4eba\u6570\u7edf\u8ba1\u7ed3\u675f-->" + DateUtils.formatDateTime((Date)new Date()));
    }

    @XxlJob(value="CompanyPickupCountTask-updateCompanyIndustryByCheck")
    public void updateCompanyIndustryByCheck() {
        this.logger.info("\u6839\u636e\u68c0\u6d4b\u6570\u636e\u4fee\u6539\u884c\u4e1a\u7c7b\u578b,\u5b9a\u65f6\u4efb\u52a1\u751f\u6210\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        List changeCidList = this.dcCompanyService.updateCompanyIndustryByCheck(null);
        if (CollectionUtils.isNotEmpty((Collection)changeCidList)) {
            changeCidList = changeCidList.stream().distinct().collect(Collectors.toList());
            this.dcCompanyService.doCompanyOccTypeTask(changeCidList, OccTypeChangeEvent.BY_CHECKINDU, Boolean.valueOf(true));
        }
        this.logger.info("\u6839\u636e\u68c0\u6d4b\u6570\u636e\u4fee\u6539\u884c\u4e1a\u7c7b\u578b,\u5b9a\u65f6\u4efb\u52a1\u751f\u6210\u7ed3\u675f-->" + DateUtils.formatDateTime((Date)new Date()));
    }

    @XxlJob(value="CompanyPickupCountTask-victimLess3RateRemind")
    public void victimLess3Rate() {
        this.logger.info("\u63a5\u5bb3\u4eba\u6570\uff1c3\u4eba\u4f01\u4e1a\u5360\u6bd4\u7edf\u8ba1\u63d0\u9192\u5f00\u59cb-->" + DateUtils.formatDateTime((Date)new Date()));
        this.workProgressService.victimLess3RateRemind(false);
        this.logger.info("\u63a5\u5bb3\u4eba\u6570\uff1c3\u4eba\u4f01\u4e1a\u5360\u6bd4\u7edf\u8ba1\u63d0\u9192\u7ed3\u675f-->" + DateUtils.formatDateTime((Date)new Date()));
    }
}

