/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.workPerfor;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.dao.workPerfor.WorkPerforMapper;
import cn.smarthse.modules.health.supervise.service.workPerfor.IWorkPerforService;
import cn.smarthse.modules.health.supervise.vo.workPerfor.CheckComVo;
import cn.smarthse.modules.health.supervise.vo.workPerfor.ComHealthCheckVo;
import cn.smarthse.modules.health.supervise.vo.workPerfor.DeclareComVo;
import cn.smarthse.modules.health.supervise.vo.workPerfor.DiseaseComVo;
import cn.smarthse.modules.health.supervise.vo.workPerfor.ThirdSameTimeComVo;
import cn.smarthse.modules.health.supervise.vo.workPerfor.WorkPerforSearchVo;
import cn.smarthse.modules.platform.model.AreaModel;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class WorkPerforServiceImpl
implements IWorkPerforService {
    @Autowired
    private WorkPerforMapper workPerforMapper;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @Autowired
    private RedisClient redisClient;
    private static final String workPerforKey = "WorkPerfor";

    public JqGridData<DeclareComVo> getDeclareComNumByAreaAndTime(JqGridParam jParam, WorkPerforSearchVo searchVo) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2022, 4, 1, 0, 0, 0);
        searchVo.setOrigTime(calendar.getTime());
        List data = (List)this.redisClient.get(workPerforKey, RedisClient.generateCacheKey((Object[])new Object[]{"getDeclareComNumByArea", searchVo.getAreaId()}), 3600L, () -> this.workPerforMapper.getDeclareComNumByArea(searchVo));
        return new JqGridData(data, jParam);
    }

    public JqGridData<ThirdSameTimeComVo> getThirdSameTimeListData(JqGridParam jParam, WorkPerforSearchVo searchVo) {
        this.setOrigTime(searchVo);
        List data = (List)this.redisClient.get(workPerforKey, RedisClient.generateCacheKey((Object[])new Object[]{"getThirdSameTimeListData", searchVo.getAreaId()}), 3600L, () -> this.workPerforMapper.getThirdSameTimeListData(searchVo));
        return new JqGridData(data, jParam);
    }

    public ThirdSameTimeComVo getThirdSameTimeTotalData(WorkPerforSearchVo searchVo) {
        this.setOrigTime(searchVo);
        ThirdSameTimeComVo vo = (ThirdSameTimeComVo)this.redisClient.get(workPerforKey, RedisClient.generateCacheKey((Object[])new Object[]{"getThirdSameTimeTotalData", searchVo.getAreaId()}), 3600L, () -> this.workPerforMapper.getThirdSameTimeTotalData(searchVo));
        vo.setAreaName("\u5408\u8ba1");
        return vo;
    }

    public List<ThirdSameTimeComVo> getAllThirdSameTimeData(WorkPerforSearchVo searchVo) {
        this.setOrigTime(searchVo);
        return this.workPerforMapper.getThirdSameTimeListData(searchVo);
    }

    public JqGridData<CheckComVo> getOccHazardCheckData(JqGridParam jParam, WorkPerforSearchVo searchVo) {
        this.setOrigTime(searchVo);
        List data = (List)this.redisClient.get(workPerforKey, RedisClient.generateCacheKey((Object[])new Object[]{"getOccHazardCheckData", searchVo.getAreaId()}), 3600L, () -> this.workPerforMapper.getOccHazardCheckData(searchVo));
        return new JqGridData(data, jParam);
    }

    public CheckComVo getOccHazardCheckTotalData(WorkPerforSearchVo searchVo) {
        this.setOrigTime(searchVo);
        CheckComVo vo = (CheckComVo)this.redisClient.get(workPerforKey, RedisClient.generateCacheKey((Object[])new Object[]{"getOccHazardCheckTotalData", searchVo.getAreaId()}), 3600L, () -> this.workPerforMapper.getOccHazardCheckTotalData(searchVo));
        return vo;
    }

    public List<CheckComVo> getAllOccHazardCheckData(WorkPerforSearchVo searchVo) {
        this.setOrigTime(searchVo);
        return this.workPerforMapper.getOccHazardCheckData(searchVo);
    }

    public JqGridData<ComHealthCheckVo> getCompanyHealthCheckData(JqGridParam jParam, WorkPerforSearchVo searchVo) {
        this.setOrigTime(searchVo);
        List data = (List)this.redisClient.get(workPerforKey, RedisClient.generateCacheKey((Object[])new Object[]{"getCompanyHealthCheckData", searchVo.getAreaId()}), 3600L, () -> this.workPerforMapper.getCompanyHealthCheckData(searchVo));
        return new JqGridData(data, jParam);
    }

    public ComHealthCheckVo getCompanyHealthCheckTotalData(WorkPerforSearchVo searchVo) {
        this.setOrigTime(searchVo);
        return (ComHealthCheckVo)this.redisClient.get(workPerforKey, RedisClient.generateCacheKey((Object[])new Object[]{"getCompanyHealthCheckTotalData", searchVo.getAreaId()}), 3600L, () -> this.workPerforMapper.getCompanyHealthCheckTotalData(searchVo));
    }

    public List<ComHealthCheckVo> getAllCompanyHealthCheckData(WorkPerforSearchVo searchVo) {
        this.setOrigTime(searchVo);
        return this.workPerforMapper.getCompanyHealthCheckData(searchVo);
    }

    public DeclareComVo getOccHazardTotalData(WorkPerforSearchVo searchVo) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2022, 4, 1, 0, 0, 0);
        searchVo.setOrigTime(calendar.getTime());
        DeclareComVo vo = (DeclareComVo)this.redisClient.get(workPerforKey, RedisClient.generateCacheKey((Object[])new Object[]{"getOccHazardTotalData", searchVo.getAreaId()}), 3600L, () -> this.workPerforMapper.getOccHazardTotalData(searchVo));
        vo.setAreaName("\u5408\u8ba1");
        return vo;
    }

    public List<DeclareComVo> getAllDeclareComNumByAreaAndTime(WorkPerforSearchVo searchVo) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2022, 4, 1, 0, 0, 0);
        searchVo.setOrigTime(calendar.getTime());
        return this.workPerforMapper.getDeclareComNumByArea(searchVo);
    }

    public JqGridData<DiseaseComVo> getDiseaseComNumByAreaAndTime(JqGridParam jParam, WorkPerforSearchVo searchVo) {
        List data = (List)this.redisClient.get(workPerforKey, RedisClient.generateCacheKey((Object[])new Object[]{"getDiseaseComNumByArea", searchVo.getAreaId()}), 3600L, () -> this.workPerforMapper.getDiseaseComNumByArea(searchVo));
        return new JqGridData(data, jParam);
    }

    public DiseaseComVo getDiseaseTotalData(WorkPerforSearchVo searchVo) {
        DiseaseComVo diseaseTotalData = (DiseaseComVo)this.redisClient.get(workPerforKey, RedisClient.generateCacheKey((Object[])new Object[]{"getDiseaseTotalData", searchVo.getAreaId()}), 3600L, () -> this.workPerforMapper.getDiseaseTotalData(searchVo));
        if (diseaseTotalData == null) {
            diseaseTotalData = new DiseaseComVo();
            AreaModel areaModel = this.sysAreaProvideService.getAreaById(searchVo.getAreaId());
            diseaseTotalData.setCityName(areaModel.getFullname());
            diseaseTotalData.setChengfeiA(Integer.valueOf(0));
            diseaseTotalData.setChengfeiB(Integer.valueOf(0));
            diseaseTotalData.setChengfeiC(Integer.valueOf(0));
            diseaseTotalData.setZhongduA(Integer.valueOf(0));
            diseaseTotalData.setZhongduB(Integer.valueOf(0));
            diseaseTotalData.setZhongduC(Integer.valueOf(0));
            diseaseTotalData.setZaoshenglongA(Integer.valueOf(0));
            diseaseTotalData.setZaoshenglongB(Integer.valueOf(0));
            diseaseTotalData.setZaoshenglongC(Integer.valueOf(0));
            diseaseTotalData.setQitaA(Integer.valueOf(0));
            diseaseTotalData.setQitaB(Integer.valueOf(0));
            diseaseTotalData.setQitaC(Integer.valueOf(0));
        }
        return diseaseTotalData;
    }

    public List<DiseaseComVo> getAllDiseaseData(WorkPerforSearchVo searchVo) {
        return this.workPerforMapper.getDiseaseComNumByArea(searchVo);
    }

    private void setOrigTime(WorkPerforSearchVo searchVo) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(LocalDateTime.now().getYear(), 0, 1, 0, 0, 0);
        searchVo.setOrigTime(calendar.getTime());
    }
}

