/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.trainPlan;

import cn.smarthse.common.util.PageUtil;
import cn.smarthse.modules.datacentre.model.ComSuperviseAreaModel;
import cn.smarthse.modules.datacentre.provider.ICompanySuperviseViewService;
import cn.smarthse.modules.health.pojo.TrainResultVo;
import cn.smarthse.modules.health.pojo.TrainStaff;
import cn.smarthse.modules.health.pojo.TrainStatParam;
import cn.smarthse.modules.health.supervise.dao.trainPlan.TrainStatMapper;
import cn.smarthse.modules.health.supervise.service.trainPlan.ITranStatService;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class TranStatServiceImpl
implements ITranStatService {
    @DubboReference
    private ICompanySuperviseViewService companySuperviseViewService;
    @Autowired
    private TrainStatMapper trainStatMapper;

    public PageInfo<TrainResultVo> stat(TrainStatParam param) {
        return PageUtil.getPageInfo(this.doStrainStat(param), (int)param.getPage(), (int)param.getRows());
    }

    public TrainResultVo trainStatAll(TrainStatParam param) {
        List<TrainResultVo> list = this.doStrainStat(param);
        TrainResultVo r = new TrainResultVo();
        list.forEach(vo -> {
            r.setTotalComNum(Integer.valueOf(r.getTotalComNum() + vo.getTotalComNum()));
            r.setTrainComNum(Integer.valueOf(r.getTrainComNum() + vo.getTrainComNum()));
            r.setTrainTotalNum(Integer.valueOf(r.getTrainTotalNum() + vo.getTrainTotalNum()));
            r.setExamNum(Integer.valueOf(r.getExamNum() + vo.getExamNum()));
            r.setExamPassNum(Integer.valueOf(r.getExamPassNum() + vo.getExamPassNum()));
        });
        return r;
    }

    private List<TrainResultVo> doStrainStat(TrainStatParam paramModel) {
        LinkedList<TrainResultVo> list = new LinkedList<TrainResultVo>();
        List comList = this.companySuperviseViewService.queryComArea(paramModel.getAreaId(), paramModel.getLevel());
        Map<String, Set<Long>> group = this.groupByArea(comList, paramModel.getLevel());
        List<TrainStaff> all = this.trainStatMapper.getByYear(paramModel.getYear());
        Map<Long, List<TrainStaff>> cidMemberMap = this.toMap(all);
        group.forEach((key, value) -> {
            TrainResultVo vo = this.createTrainResultVo(cidMemberMap, (Set<Long>)value);
            list.add(vo);
            String[] splits = key.split("-");
            vo.setAreaId(Long.valueOf(Long.parseLong(splits[0])));
            vo.setAreaName(splits[1]);
        });
        return list;
    }

    private Map<Long, List<TrainStaff>> toMap(List<TrainStaff> all) {
        HashMap<Long, List<TrainStaff>> map = new HashMap<Long, List<TrainStaff>>();
        for (TrainStaff trainingMember : all) {
            List trainingMembers = map.computeIfAbsent(trainingMember.getCid(), k -> new LinkedList());
            trainingMembers.add(trainingMember);
        }
        return map;
    }

    private TrainResultVo createTrainResultVo(Map<Long, List<TrainStaff>> cidMemberMap, Set<Long> needCids) {
        TrainResultVo vo = new TrainResultVo();
        vo.setTotalComNum(Integer.valueOf(needCids.size()));
        vo.setTotalCids(needCids);
        vo.setTrainComNum(Integer.valueOf(0));
        vo.setTrainCids(new HashSet());
        vo.setTrainTotalNum(Integer.valueOf(0));
        vo.setTrainTotalStaffIds(new HashSet());
        vo.setExamNum(Integer.valueOf(0));
        vo.setExamStaffIds(new HashSet());
        vo.setExamPassNum(Integer.valueOf(0));
        vo.setExamPassStaffIds(new HashSet());
        cidMemberMap.forEach((key, value) -> {
            if (needCids.contains(key)) {
                vo.getTrainCids().add(key);
                value.forEach(member -> {
                    if (member.getStaffId() == null) {
                        return;
                    }
                    vo.getTrainTotalStaffIds().add(member.getStaffId());
                    if (member.getExamStatus() != null) {
                        if (member.getExamStatus() != 0) {
                            vo.getExamStaffIds().add(member.getStaffId());
                        }
                        if (member.getExamStatus() == 1) {
                            vo.getExamPassStaffIds().add(member.getStaffId());
                        }
                    }
                });
            }
        });
        vo.setTrainComNum(Integer.valueOf(vo.getTrainCids().size()));
        vo.setTrainTotalNum(Integer.valueOf(vo.getTrainTotalStaffIds().size()));
        vo.setExamNum(Integer.valueOf(vo.getExamStaffIds().size()));
        vo.setExamPassNum(Integer.valueOf(vo.getExamPassStaffIds().size()));
        return vo;
    }

    private Map<String, Set<Long>> groupByArea(List<ComSuperviseAreaModel> all, Byte level) {
        LinkedHashMap<String, Set<Long>> map = new LinkedHashMap<String, Set<Long>>();
        for (ComSuperviseAreaModel comAreaModel : all) {
            String key = this.createGroupKey(comAreaModel, level);
            Set cIds = map.computeIfAbsent(key, k -> new HashSet());
            cIds.add(comAreaModel.getCid());
        }
        return map;
    }

    private String createGroupKey(ComSuperviseAreaModel model, Byte level) {
        if (level == null) {
            level = 0;
        }
        Long areaId = 0L;
        String areaName = "";
        String hasChildren = "true";
        switch (level.intValue()) {
            case 0: {
                areaId = model.getProvinceId();
                areaName = model.getProvinceName();
                break;
            }
            case 1: {
                areaId = model.getCityId();
                areaName = model.getCityName();
                break;
            }
            case 2: {
                areaId = model.getAreaId();
                areaName = model.getAreaName();
                break;
            }
            case 3: {
                areaId = model.getStreetId();
                areaName = model.getStreetName();
                hasChildren = "false";
                break;
            }
        }
        if (areaId == null) {
            areaId = 0L;
            areaName = "\u672a\u5212\u5206\u533a\u57df";
        }
        return areaId + "-" + areaName + "-" + hasChildren;
    }
}

