/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.trainPlan;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.train.TrainPlanCount;
import cn.smarthse.modules.health.supervise.dao.trainPlan.TrainPlanCountMapper;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanCountQueryVo;
import cn.smarthse.modules.health.supervise.enums.company.CompanyCollectGroupByEnum;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISuperviseTrainPlanService;
import cn.smarthse.modules.health.supervise.service.trainPlan.ITrainPlanCountService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class TrainPlanCountServiceImpl
extends BaseServiceImpl<TrainPlanCountMapper, TrainPlanCount>
implements ITrainPlanCountService {
    @Autowired
    ISuperviseTrainPlanService trainPlanService;
    @Autowired
    TrainPlanCountMapper trainPlanCountMapper;

    public PageInfo<TrainPlanCount> getCountPageByArea(JqGridParam param, TrainPlanCountQueryVo vo) {
        if (param != null && StringUtils.isNotEmpty((String)param.getSidx())) {
            if (param.getSidx().equals("equipmentRateStr")) {
                param.setSidx("equipmentRate");
            }
            if (param.getSidx().equals("trainRateStr")) {
                param.setSidx("trainRate");
            }
            if (param.getSidx().equals("mainHseManaRateStr")) {
                param.setSidx("mainHseManaRate");
            }
            vo.setOrderCase(param.getSidx() + " " + param.getSord());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TrainPlanCount> list = this.trainPlanCountMapper.getCountListByArea(vo);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<TrainPlanCount> getCountData(TrainPlanCountQueryVo vo) {
        List<TrainPlanCount> list = this.trainPlanCountMapper.getCountData(vo);
        return list;
    }

    public List<TrainPlanCount> getCountListByArea(TrainPlanCountQueryVo vo) {
        List<TrainPlanCount> list = this.trainPlanCountMapper.getCountListByArea(vo);
        return list;
    }

    public PageInfo<TrainPlanCount> getCountPageByRegistrationType(JqGridParam param, TrainPlanCountQueryVo vo) {
        if (param != null && StringUtils.isNotEmpty((String)param.getSidx())) {
            if (param.getSidx().equals("equipmentRateStr")) {
                param.setSidx("equipmentRate");
            }
            if (param.getSidx().equals("trainRateStr")) {
                param.setSidx("trainRate");
            }
            if (param.getSidx().equals("mainHseManaRateStr")) {
                param.setSidx("mainHseManaRate");
            }
            vo.setOrderCase(param.getSidx() + " " + param.getSord());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TrainPlanCount> list = this.trainPlanCountMapper.getCountListByRegistrationType(vo);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public PageInfo<TrainPlanCount> getCountPageByIndustry(JqGridParam param, TrainPlanCountQueryVo vo) {
        if (param != null && StringUtils.isNotEmpty((String)param.getSidx())) {
            if (param.getSidx().equals("equipmentRateStr")) {
                param.setSidx("equipmentRate");
            }
            if (param.getSidx().equals("trainRateStr")) {
                param.setSidx("trainRate");
            }
            if (param.getSidx().equals("mainHseManaRateStr")) {
                param.setSidx("mainHseManaRate");
            }
            vo.setOrderCase(param.getSidx() + " " + param.getSord());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TrainPlanCount> list = this.trainPlanCountMapper.getCountListByIndustry(vo);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public PageInfo<TrainPlanCount> getCountPageByScale(JqGridParam param, TrainPlanCountQueryVo vo) {
        if (param != null && StringUtils.isNotEmpty((String)param.getSidx())) {
            if (param.getSidx().equals("equipmentRateStr")) {
                param.setSidx("equipmentRate");
            }
            if (param.getSidx().equals("trainRateStr")) {
                param.setSidx("trainRate");
            }
            if (param.getSidx().equals("mainHseManaRateStr")) {
                param.setSidx("mainHseManaRate");
            }
            if (param.getSidx().equals("typeName")) {
                param.setSidx("scale");
            }
            vo.setOrderCase(param.getSidx() + " " + param.getSord());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TrainPlanCount> list = this.trainPlanCountMapper.getCountListByScale(vo);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public PageInfo<TrainPlanCount> getCountPageByRisk(JqGridParam param, TrainPlanCountQueryVo vo) {
        if (param != null && StringUtils.isNotEmpty((String)param.getSidx())) {
            if (param.getSidx().equals("equipmentRateStr")) {
                param.setSidx("equipmentRate");
            }
            if (param.getSidx().equals("trainRateStr")) {
                param.setSidx("trainRate");
            }
            if (param.getSidx().equals("mainHseManaRateStr")) {
                param.setSidx("mainHseManaRate");
            }
            if (param.getSidx().equals("typeName")) {
                param.setSidx("scale");
            }
            vo.setOrderCase(param.getSidx() + " " + param.getSord());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<TrainPlanCount> list = this.trainPlanCountMapper.getCountListByRisk(vo);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<TrainPlanCount> getCountList(TrainPlanCountQueryVo trainCountParam, CompanyCollectGroupByEnum typeEnum) {
        ArrayList<TrainPlanCount> list = new ArrayList();
        switch (typeEnum) {
            case AREA: {
                list = this.trainPlanCountMapper.getCountListByArea(trainCountParam);
                break;
            }
            case REGISTERTYPE: {
                list = this.trainPlanCountMapper.getCountListByRegistrationType(trainCountParam);
                trainCountParam.setGroupType(CompanyCollectGroupByEnum.REGISTERTYPE.getValue());
                break;
            }
            case INDUSTRYCATEGORY: {
                list = this.trainPlanCountMapper.getCountListByIndustry(trainCountParam);
                break;
            }
            case SCALE: {
                list = this.trainPlanCountMapper.getCountListByScale(trainCountParam);
                break;
            }
            case OCCUPATIONALRISKCLASSIFY: {
                list = this.trainPlanCountMapper.getCountListByRisk(trainCountParam);
            }
        }
        List<TrainPlanCount> counts = this.getCountData(trainCountParam);
        if (counts != null) {
            TrainPlanCount count = counts.get(0);
            count.setTypeName("\u5408\u8ba1");
            list.add(count);
        }
        return list;
    }

    public Double getTrainRate(Long areaId, Byte areaLevel) {
        return this.trainPlanCountMapper.getTrainRate(areaId, areaLevel);
    }
}

