/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.trainPlan;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.util.FileUtil;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffQuery;
import cn.smarthse.modules.health.entity.work.certificate.CertificateFiles;
import cn.smarthse.modules.health.entity.work.certificate.CertificateStaffDetail;
import cn.smarthse.modules.health.entity.work.train.TrainAttend;
import cn.smarthse.modules.health.entity.work.train.TrainPlan;
import cn.smarthse.modules.health.enums.certificate.ApprovalStatusEnum;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffDetailDataSourceEnum;
import cn.smarthse.modules.health.enums.certificate.CertificateStaffNameTypeEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkPropertyEnum;
import cn.smarthse.modules.health.enums.staff.StaffWorkStatusEnum;
import cn.smarthse.modules.health.onlineMonitoring.service.impl.reform.OnlineDeviceUtil;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveUpdateService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateFilesService;
import cn.smarthse.modules.health.service.work.certificate.ICertificateStaffDetailService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.train.ITrainAttendService;
import cn.smarthse.modules.health.service.work.train.ITrainPlanService;
import cn.smarthse.modules.health.supervise.dao.projectTrain.TrainProjStaffMapper;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.projectTrain.TrainProjReport;
import cn.smarthse.modules.health.supervise.entity.projectTrain.TrainProjStaff;
import cn.smarthse.modules.health.supervise.entity.sys.Param;
import cn.smarthse.modules.health.supervise.entity.trainPlan.PerTrainingInfoModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.RaTuCertificateModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.SyncAppUrlModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.SyncCertInfoModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.SyncTrainInfoModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainAttendModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainCertModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanUpdateModel;
import cn.smarthse.modules.health.supervise.enums.WorkOperateLogEnum;
import cn.smarthse.modules.health.supervise.model.onlineTrain.IssuedModel;
import cn.smarthse.modules.health.supervise.model.onlineTrain.TrainStaffInfoModel;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.operate.IWorkOperateLogService;
import cn.smarthse.modules.health.supervise.service.projectTrain.ITrainProjReportService;
import cn.smarthse.modules.health.supervise.service.projectTrain.ITrainProjStaffService;
import cn.smarthse.modules.health.supervise.service.sys.IParamService;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.snowflake.IdWorker;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@DubboService
@Transactional(readOnly=true)
public class SyncTrainInfoServiceImpl
implements ISyncTrainInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncTrainInfoServiceImpl.class);
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IStaffBasicInfoService staffBasicInfoService;
    @Autowired
    private ITrainProjStaffService trainProjStaffService;
    @DubboReference
    private ICertificateStaffDetailService certificateStaffDetailService;
    @DubboReference
    private ICertificateFilesService certificateFilesService;
    @DubboReference
    private ITrainAttendService trainAttendService;
    @Autowired
    private ITrainProjReportService trainProjReportService;
    @Autowired
    private IWorkOperateLogService workOperateLogService;
    @DubboReference
    private ITrainPlanService trainPlanService;
    @Autowired(required=false)
    protected OssClientBean ossClientBean;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference
    private IParamService paramService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @DubboReference
    private IOrganizationService organizationService;
    @DubboReference
    private IOrganizationUserService organizationUserService;
    @Autowired
    private DataSourceTransactionManager txManager;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    @Autowired
    protected IdWorker idworker;
    @DubboReference
    private ILiteArchiveUpdateService archiveUpdateService;
    @Autowired
    OnlineDeviceUtil onlineDeviceUtil;

    @Transactional(readOnly=false)
    public String addOrUpdateTrainInfo(SyncTrainInfoModel info) {
        try {
            String ver = this.verifyParam(info);
            if (ver != null) {
                return ver;
            }
            TrainProjReport trainProjReport = this.trainProjReportService.getByOnlineTrainId(info.getTrainId());
            if (trainProjReport == null) {
                if (Objects.equals(info.getIsValid(), Boolean.FALSE)) {
                    return "\u8be5\u57f9\u8bad\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25";
                }
                trainProjReport = new TrainProjReport();
                trainProjReport.setOnlineTrainId(info.getTrainId());
                trainProjReport.setProjName(info.getTrainName());
                trainProjReport.setTrainBeginDate(info.getTrainTimeBegin());
                trainProjReport.setTrainEndDate(info.getTrainTimeEnd());
                trainProjReport.setTrainType(",9,10,");
                trainProjReport.setType(Byte.valueOf((byte)2));
                trainProjReport.setReportStatus(info.getChangeType());
                trainProjReport.setOrgReportTime(new Date());
                trainProjReport.setAreaId(info.getAreaId());
                trainProjReport.setRegistrant(info.getOperater());
                trainProjReport.setTrainCompanyName(info.getCompanyName());
                trainProjReport.setIsValid(Global.TRUE);
                trainProjReport = (TrainProjReport)this.trainProjReportService.add((Object)trainProjReport, info.getCreateBy(), null);
            } else {
                if (info.getTrainName() != null) {
                    trainProjReport.setProjName(info.getTrainName());
                }
                if (info.getTrainTimeBegin() != null) {
                    trainProjReport.setTrainBeginDate(info.getTrainTimeBegin());
                }
                if (info.getTrainTimeEnd() != null) {
                    trainProjReport.setTrainEndDate(info.getTrainTimeEnd());
                }
                if (info.getChangeType() != null) {
                    trainProjReport.setReportStatus(info.getChangeType());
                }
                if (info.getIsValid().equals(Global.FALSE)) {
                    List list = this.trainPlanService.getListByCidOrReportId(null, trainProjReport.getId());
                    if (list != null && list.size() > 0) {
                        return "\u57f9\u8bad\u5df2\u6709\u4f01\u4e1a\u62a5\u540d\uff0c\u65e0\u6cd5\u5220\u9664";
                    }
                    trainProjReport.setIsValid(info.getIsValid());
                }
                if (info.getAreaId() != null) {
                    trainProjReport.setAreaId(info.getAreaId());
                }
                if (StringUtils.isNotEmpty((String)info.getOperater())) {
                    trainProjReport.setRegistrant(info.getOperater());
                }
                if (StringUtils.isNotEmpty((String)info.getCompanyName())) {
                    trainProjReport.setTrainCompanyName(info.getCompanyName());
                }
                this.trainProjReportService.update((Object)trainProjReport, info.getCreateBy());
            }
            this.workOperateLogService.addOnlineTrainLog(trainProjReport.getId(), WorkOperateLogEnum.trainProj.getTypeVal(), info.getChangeReason(), info.getCreateBy(), info.getOperater(), Byte.valueOf((byte)1), info.getCompanyName());
            return "\u540c\u6b65\u6210\u529f";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u540c\u6b65\u5931\u8d25\uff1a" + e.toString();
        }
    }

    private String verifyParam(SyncTrainInfoModel info) {
        if (info == null) {
            return "\u540c\u6b65\u57f9\u8bad\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (info.getTrainId() == null) {
            return "\u540c\u6b65\u57f9\u8bad\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((CharSequence)info.getTrainName())) {
            return "\u540c\u6b65\u57f9\u8bad\u6570\u636e\u57f9\u8bad\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    @Transactional(readOnly=false)
    public String addTrainInfoByCid(Long cid, Long trainId, Byte opStatus, Byte enrollSource) {
        if (cid == null || trainId == null) {
            return "cid\u6216\u8005trainId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        TrainProjReport trainProjReport = this.trainProjReportService.getByOnlineTrainId(trainId);
        if (trainProjReport == null) {
            return "\u4f01\u4e1a\u62a5\u540d\u5931\u8d25\uff0c\u67e5\u4e0d\u5230\u57f9\u8bad\u4fe1\u606f";
        }
        TrainPlan trainPlan = this.trainPlanService.getByCidAndReportId(cid, trainProjReport.getId());
        if (opStatus == 1) {
            if (trainPlan == null) {
                trainPlan = new TrainPlan();
                trainPlan.setName(trainProjReport.getProjName());
                trainPlan.setHsType("1,");
                trainPlan.setType(",9,10,");
                trainPlan.setWay(Byte.valueOf((byte)2));
                trainPlan.setOnLine(Byte.valueOf((byte)2));
                trainPlan.setIsFinish(Global.TRUE);
                trainPlan.setReportId(trainProjReport.getId());
                trainPlan.setRegisterTime(trainProjReport.getTrainBeginDate());
                trainPlan.setIsValid(Global.TRUE);
                trainPlan.setCid(cid);
                trainPlan.setDataSource(Byte.valueOf(enrollSource == null ? (byte)3 : (byte)enrollSource));
                this.trainPlanService.add((Object)trainPlan, cid, cid);
                return null;
            }
            return null;
        }
        if (trainPlan == null) {
            return null;
        }
        trainPlan.setIsValid(Global.FALSE);
        this.trainPlanService.update((Object)trainPlan);
        return null;
    }

    @Transactional(readOnly=false)
    public String addOrUpdateCertInfo(SyncCertInfoModel info) {
        TrainAttend attend;
        if (info.getTrainUserId() == null || info.getCid() == null) {
            return "\u4f01\u4e1aid\u6216\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a";
        }
        TrainProjReport trainProjReport = this.trainProjReportService.getByOnlineTrainId(info.getTrainId());
        if (trainProjReport == null) {
            return "\u57f9\u8bad\u4fe1\u606f\u6ca1\u6709\u540c\u6b65";
        }
        StaffInfo staff = this.staffInfoService.getStaffInfoByIdCardOrTrainUserId(info.getCid(), info.getStaffName(), info.getIdCard(), info.getTrainUserId());
        TrainPlan train = this.trainPlanService.getByCidAndReportId(info.getCid(), trainProjReport.getId());
        if (train != null && (attend = this.trainAttendService.getByStaffIdAndTrainId(staff.getId(), train.getId())) == null) {
            attend = new TrainAttend();
            attend.setStaffName(info.getStaffName());
            attend.setStaffId(staff.getId());
            attend.setCid(info.getCid());
            attend.setTrainId(train.getId());
            this.trainAttendService.add((Object)attend);
        }
        CertificateStaffDetail cert = null;
        if (info.getCertType() == 1 || info.getCertType() == 2) {
            cert = this.certificateStaffDetailService.getCertForOrgByStaffIdAndCertType(trainProjReport.getId(), staff.getId(), info.getCertType(), info.getCid());
        }
        if (cert == null) {
            cert = new CertificateStaffDetail();
            if (info.getCertType() == 1) {
                cert.setCertId(Long.valueOf(12L));
            }
            if (info.getCertType() == 2) {
                cert.setCertId(Long.valueOf(13L));
            }
        }
        cert.setDataSource(Byte.valueOf((byte)3));
        cert.setReportId(trainProjReport.getId());
        cert.setStaffName(info.getStaffName());
        cert.setStaffId(staff.getId());
        cert.setCertNo(info.getCertNo());
        cert.setCertCreateDate(info.getCertCreateDate());
        cert.setValidityDate(info.getValidityDate());
        cert.setRepeatData(info.getRepeatData());
        try {
            File file;
            SysFileModel sysFile;
            if (cert.getId() != null) {
                this.certificateStaffDetailService.update((Object)cert, cert.getCreateBy());
            } else {
                cert = (CertificateStaffDetail)this.certificateStaffDetailService.add((Object)cert, staff.getId(), info.getCid());
            }
            String url = this.ossClientBean.getUrl(info.getFileId());
            if (url != null && (sysFile = this.uploadFile(file = FileUtil.getNetUrl((String)url), "api/projectTrain", file.getName(), info.getStaffName(), info.getCid())) != null) {
                this.certificateStaffDetailService.addOrUpdateFile(sysFile.getId().toString(), cert.getId(), cert.getCid(), cert.getCreateBy());
            }
            return "\u8bc1\u4e66\u540c\u6b65\u6210\u529f";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "\u8bc1\u4e66\u540c\u6b65\u5931\u8d25" + e.toString();
        }
    }

    @Transactional(readOnly=false)
    public String addOrUpdateTrainAttend(TrainAttendModel model) {
        if (model.getCid() == null || model.getOnlineTrainId() == null) {
            return "\u4f01\u4e1aID\u6216\u57f9\u8badID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (model.getTrainUserId() == null || StringUtils.isEmpty((CharSequence)model.getStaffName())) {
            return "\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        TrainProjReport trainProjReport = this.trainProjReportService.getByOnlineTrainId(model.getOnlineTrainId());
        if (trainProjReport == null) {
            return "\u672a\u67e5\u8be2\u5230\u57f9\u8bad\u8bb0\u5f55";
        }
        TrainPlan train = this.trainPlanService.getByCidAndReportId(model.getCid(), trainProjReport.getId());
        Long trainPlanId = null;
        if (train != null) {
            trainPlanId = train.getId();
        }
        if (trainPlanId == null) {
            return "\u672a\u67e5\u8be2\u5230\u57f9\u8bad\u8bb0\u5f55";
        }
        if (model.getOperationType() == 1) {
            StaffInfo staff = this.staffInfoService.getStaffInfoByIdCardOrTrainUserId(model.getCid(), model.getStaffName(), model.getIdCard(), model.getTrainUserId());
            TrainProjStaff projStaff = this.trainProjStaffService.getByStaffIdAndReportId(staff.getId(), trainProjReport.getId());
            if (projStaff == null) {
                projStaff = new TrainProjStaff();
                projStaff.setStaffId(staff.getId());
                projStaff.setTrainProjReportId(trainProjReport.getId());
                projStaff.setTrainDate(new Date());
                projStaff.setCreateBy(model.getTrainUserId());
                projStaff.setUpdateBy(model.getTrainUserId());
                projStaff.setCreateDate(new Date());
                projStaff.setUpdateDate(new Date());
                projStaff.setIsValid(Global.TRUE);
                projStaff.setIdCard(model.getIdCard());
                this.trainProjStaffService.add((Object)projStaff);
            } else {
                projStaff.setIdCard(model.getIdCard());
                projStaff.setUpdateBy(Long.valueOf(0L));
                projStaff.setUpdateDate(new Date());
                this.trainProjStaffService.update((Object)projStaff);
            }
            TrainAttend attend = this.trainAttendService.getByStaffIdAndTrainId(staff.getId(), trainPlanId);
            if (attend == null) {
                attend = new TrainAttend();
                attend.setStaffName(model.getStaffName());
                attend.setStaffId(staff.getId());
                attend.setCid(model.getCid());
                attend.setTrainId(trainPlanId);
                this.trainAttendService.add((Object)attend);
            } else {
                attend.setStaffName(model.getStaffName());
                attend.setCid(model.getCid());
                this.trainAttendService.update((Object)attend);
            }
            return null;
        }
        if (model.getOperationType() == 2) {
            TrainAttend trainAttend;
            StaffInfo staff = this.staffInfoService.getStaffInfoByIdCardOrTrainUserId(model.getCid(), model.getStaffName(), model.getIdCard(), model.getTrainUserId());
            if (staff == null) {
                return "\u4eba\u5458\u4fe1\u606f\u4e0d\u5b58\u5728";
            }
            TrainProjStaff trainProjStaff = this.trainProjStaffService.getByStaffIdAndReportId(staff.getId(), trainProjReport.getId());
            if (trainProjStaff != null) {
                trainProjStaff.setIsValid(Global.FALSE);
                this.trainProjStaffService.update((Object)trainProjStaff);
            }
            if ((trainAttend = this.trainAttendService.getByStaffIdAndTrainId(staff.getId(), trainPlanId)) != null) {
                trainAttend.setIsValid(Global.FALSE);
                this.trainAttendService.update((Object)trainAttend);
            }
            return null;
        }
        return "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef";
    }

    @Transactional(rollbackFor={Exception.class})
    public String addOrUpdateTrainAttendAndCertInfo(TrainAttendModel model) {
        if (model == null) {
            return "\u540c\u6b65\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (model.getTrainUserId() == null) {
            return "\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (model.getOperationType() == 1) {
            String result = this.synchronousOnlineTrainCertData(model);
            this.executorService.schedule(() -> this.archiveUpdateService.refreshArchive(model.getCid(), "302"), 2L, TimeUnit.SECONDS);
            return result;
        }
        if (model.getOperationType() == 2) {
            return this.changeCompany(model);
        }
        return "\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef";
    }

    public String syncSpecialCommitteeTrainCertInfo(RaTuCertificateModel model) {
        log.error("\u4e13\u59d4\u4f1a::\u65e5\u5fd7\u6253\u5370::\u5165\u53c2::{}", (Object)model);
        if (model == null) {
            return "\u540c\u6b65\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String result = this.synchronousSpecialCommitteeCertData(model);
        this.executorService.schedule(() -> this.archiveUpdateService.refreshArchive(model.getCid(), "302"), 2L, TimeUnit.SECONDS);
        this.syncResolveTrainRisk(model);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean offlineCertSync(TrainCertModel certSync) {
        if (certSync == null) {
            return Boolean.FALSE;
        }
        Boolean b = this.synchronousDongYangCertData(certSync);
        this.executorService.schedule(() -> this.archiveUpdateService.refreshArchive(certSync.getCid(), "302"), 2L, TimeUnit.SECONDS);
        return b;
    }

    private String synchronousData(TrainAttendModel model) {
        if (model.getCid() == null || StringUtils.isEmpty((CharSequence)model.getStaffName())) {
            return "\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        TrainProjReport trainProjReport = this.trainProjReportService.getByOnlineTrainId(model.getOnlineTrainId());
        if (trainProjReport == null) {
            return "\u672a\u67e5\u8be2\u5230\u57f9\u8bad\u9879\u76ee";
        }
        TrainPlan train = this.trainPlanService.getByCidAndReportId(model.getCid(), trainProjReport.getId());
        if (train == null) {
            return "\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u62a5\u540d\u8bb0\u5f55";
        }
        try {
            File file;
            SysFileModel sysFile;
            StaffInfo staff = this.staffInfoService.getStaffInfoByIdCardOrTrainUserId(model.getCid(), model.getStaffName(), model.getIdCard(), model.getTrainUserId());
            StaffBasicInfo staffBasic = (StaffBasicInfo)this.staffBasicInfoService.getById(staff.getStaffBasicId());
            if (staffBasic == null) {
                StaffBasicInfo basicInfo = new StaffBasicInfo();
                basicInfo.setRealName(model.getStaffName());
                basicInfo.setGender(IDCardUtil.getGender((String)model.getNewIdCard()));
                basicInfo.setIdCard(model.getIdCard());
                basicInfo.setBirthday(IDCardUtil.getBirthday((String)model.getNewIdCard()));
                basicInfo.setAge(Integer.valueOf(IDCardUtil.getAge((String)model.getNewIdCard())));
                basicInfo.setMobile(model.getMobile());
                basicInfo.setCid(model.getCid());
                basicInfo.setIsValid(Boolean.valueOf(true));
                this.staffBasicInfoService.add((Object)basicInfo);
            } else {
                staffBasic.setMobile(model.getMobile());
                this.staffBasicInfoService.update((Object)staffBasic);
            }
            TrainProjStaff projStaff = this.trainProjStaffService.getByStaffIdAndReportId(staff.getId(), trainProjReport.getId());
            if (projStaff == null) {
                projStaff = new TrainProjStaff();
                projStaff.setStaffId(staff.getId());
                projStaff.setTrainProjReportId(trainProjReport.getId());
                projStaff.setTrainDate(new Date());
                projStaff.setCreateBy(model.getTrainUserId());
                projStaff.setUpdateBy(model.getTrainUserId());
                projStaff.setCreateDate(new Date());
                projStaff.setUpdateDate(new Date());
                projStaff.setIsValid(Global.TRUE);
                projStaff.setIdCard(model.getIdCard());
                this.trainProjStaffService.add((Object)projStaff);
            } else {
                projStaff.setIdCard(model.getIdCard());
                projStaff.setUpdateBy(model.getTrainUserId());
                projStaff.setUpdateDate(new Date());
                this.trainProjStaffService.update((Object)projStaff);
            }
            TrainAttend attend = this.trainAttendService.getByStaffIdAndTrainId(staff.getId(), train.getId());
            if (attend == null) {
                attend = new TrainAttend();
                attend.setStaffName(model.getStaffName());
                attend.setStaffId(staff.getId());
                attend.setCid(model.getCid());
                attend.setTrainId(train.getId());
                this.trainAttendService.add((Object)attend);
            } else {
                attend.setStaffName(model.getStaffName());
                attend.setCid(model.getCid());
                this.trainAttendService.update((Object)attend);
            }
            CertificateStaffDetail cert = null;
            if (model.getCertType() == 1 || model.getCertType() == 2) {
                cert = this.certificateStaffDetailService.getCertForOrgByStaffIdAndCertType(trainProjReport.getId(), staff.getId(), model.getCertType(), model.getCid());
                log.error("\u540c\u6b65\u57f9\u8bad\u4eba\u5458\u76f8\u5173\u6570\u636e-info,TrainAttendModel:{},TrainProjReport:{},TrainPlan:{},StaffInfo:{},TrainProjStaff:{},TrainAttend:{},CertificateStaffDetail:{},", new Object[]{model, trainProjReport, train, staff, projStaff, attend, cert});
            }
            if (cert == null) {
                cert = new CertificateStaffDetail();
                if (model.getCertType() == 1) {
                    cert.setCertId(Long.valueOf(12L));
                }
                if (model.getCertType() == 2) {
                    cert.setCertId(Long.valueOf(13L));
                }
            }
            cert.setDataSource(Byte.valueOf(model.getEnrollSource() == null ? (byte)3 : model.getEnrollSource()));
            cert.setStatus(ApprovalStatusEnum.NONEEDAPPROVAL.getValue());
            cert.setReportId(trainProjReport.getId());
            cert.setStaffName(model.getStaffName());
            cert.setStaffId(staff.getId());
            cert.setCertNo(model.getCertNo());
            cert.setCertCreateDate(model.getCertCreateDate());
            cert.setValidityDate(model.getValidityDate());
            cert.setRepeatData(model.getRepeatData());
            if (cert.getId() != null) {
                this.certificateStaffDetailService.update((Object)cert, cert.getCreateBy());
            } else {
                cert = (CertificateStaffDetail)this.certificateStaffDetailService.add((Object)cert, staff.getId(), model.getCid());
            }
            String url = this.ossClientBean.getUrl(model.getFileId());
            if (url != null && (sysFile = this.uploadFile(file = FileUtil.getNetUrl((String)url), "api/projectTrain", file.getName(), model.getStaffName(), model.getCid())) != null) {
                this.certificateStaffDetailService.addOrUpdateFile(sysFile.getId().toString(), cert.getId(), cert.getCid(), cert.getCreateBy());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u8bc1\u4e66\u540c\u6b65\u5931\u8d25";
        }
        return null;
    }

    private String synchronousOnlineTrainCertData(TrainAttendModel certSync) {
        Long cid = certSync.getCid();
        String staffName = certSync.getStaffName();
        Long onlineTrainId = certSync.getOnlineTrainId();
        Integer certType = certSync.getCertType();
        if (cid == null || CharSequenceUtil.isBlank((CharSequence)staffName)) {
            return "\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        TrainProjReport proj = this.trainProjReportService.getByOnlineTrainId(onlineTrainId);
        if (proj == null) {
            return "\u672a\u67e5\u8be2\u5230\u57f9\u8bad\u9879\u76ee";
        }
        TrainPlan plan = this.trainPlanService.getByCidAndReportId(cid, proj.getId());
        if (plan == null) {
            return "\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u62a5\u540d\u8bb0\u5f55";
        }
        try {
            File file;
            SysFileModel sysFile;
            CertificateStaffDetail cert = null;
            if (certType == 1 || certType == 2) {
                cert = this.certificateStaffDetailService.getOnlineTrainCertBySyncInfo(certSync);
            }
            if (cert == null) {
                cert = new CertificateStaffDetail();
                if (certType == 1) {
                    cert.setCertId(CertificateStaffNameTypeEnum.MainTrain.getId());
                }
                if (certType == 2) {
                    cert.setCertId(CertificateStaffNameTypeEnum.ManaTrain.getId());
                }
            }
            cert.setDataSource(Byte.valueOf(certSync.getEnrollSource() == null ? (byte)3 : certSync.getEnrollSource()));
            cert.setStatus(ApprovalStatusEnum.NONEEDAPPROVAL.getValue());
            cert.setReportId(proj.getId());
            StaffQuery staffQuery = new StaffQuery();
            staffQuery.setCid(cid);
            staffQuery.setStaffName(staffName);
            List staffIdList = this.staffInfoService.getStaffIdByStaffQuery(staffQuery);
            if (CollUtil.isNotEmpty((Collection)staffIdList)) {
                cert.setStaffId((Long)staffIdList.get(0));
            }
            cert.setStaffName(staffName);
            cert.setCertNo(certSync.getCertNo());
            cert.setCertCreateDate(certSync.getCertCreateDate());
            cert.setValidityDate(certSync.getValidityDate());
            cert.setRepeatData(certSync.getRepeatData());
            if (cert.getId() != null) {
                this.certificateStaffDetailService.update((Object)cert, cert.getCreateBy());
            } else {
                cert = (CertificateStaffDetail)this.certificateStaffDetailService.add((Object)cert, null, cid);
            }
            String url = this.ossClientBean.getUrl(certSync.getFileId());
            if (url != null && (sysFile = this.uploadFile(file = FileUtil.getNetUrl((String)url), "api/projectTrain", file.getName(), staffName, cid)) != null) {
                this.certificateStaffDetailService.addOrUpdateFile(sysFile.getId().toString(), cert.getId(), cert.getCid(), cert.getCreateBy());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u8bc1\u4e66\u540c\u6b65\u5931\u8d25";
        }
        return null;
    }

    private String synchronousSpecialCommitteeCertData(RaTuCertificateModel model) {
        Long cid = model.getCid();
        String staffName = model.getUname();
        String idCard = model.getIdCard();
        if (cid == null || CharSequenceUtil.isBlank((CharSequence)staffName)) {
            return "\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            File file;
            SysFileModel sysFile;
            CertificateStaffDetail cert = null;
            String certType = model.getCertType();
            if (Objects.equals(certType, "200001") || Objects.equals(certType, "200002")) {
                cert = this.certificateStaffDetailService.getSpecialCommitteeBySyncInfo(model);
            }
            if (cert == null) {
                cert = new CertificateStaffDetail();
                if (Objects.equals(certType, "200001")) {
                    cert.setCertId(CertificateStaffNameTypeEnum.MainTrain.getId());
                } else if (Objects.equals(certType, "200002")) {
                    cert.setCertId(CertificateStaffNameTypeEnum.ManaTrain.getId());
                }
            }
            cert.setCid(cid);
            cert.setSourceId(StrUtil.join((CharSequence)"_", (Object[])new Object[]{model.getTid(), model.getId()}));
            cert.setCertNo(model.getCertificateNo());
            cert.setStaffName(staffName);
            cert.setCertCreateDate(Convert.toDate((Object)model.getIssueTime()));
            cert.setValidityDate(Convert.toDate((Object)model.getInvalidDate()));
            cert.setStatus(ApprovalStatusEnum.NONEEDAPPROVAL.getValue());
            cert.setDataSource(Convert.toByte((Object)CertificateStaffDetailDataSourceEnum.SPECIAL_COMMITTEE.getValue()));
            cert.setIsValid(Boolean.TRUE);
            StaffQuery staffQuery = new StaffQuery();
            staffQuery.setCid(cid);
            staffQuery.setStaffName(staffName);
            staffQuery.setIdCard(idCard);
            List staffIdList = this.staffInfoService.getStaffIdByStaffQuery(staffQuery);
            if (CollUtil.isNotEmpty((Collection)staffIdList)) {
                cert.setStaffId((Long)staffIdList.get(0));
            } else {
                log.error("\u4e13\u59d4\u4f1a::\u65e5\u5fd7\u6253\u5370::\u901a\u8fc7cid\u3001staffName\u3001idCard\u6ca1\u627e\u5230\u4eba\uff0c\u65b0\u589e\u3002");
                long staffId = this.insertAndReturnStaffId(model);
                log.error("\u4e13\u59d4\u4f1a::\u65e5\u5fd7\u6253\u5370::\u65b0\u589e\u4eba\u5458::{}", (Object)staffId);
                cert.setStaffId(Long.valueOf(staffId));
            }
            if (cert.getId() != null) {
                this.certificateStaffDetailService.update((Object)cert, cert.getCreateBy());
            } else {
                cert = (CertificateStaffDetail)this.certificateStaffDetailService.add((Object)cert, null, cid);
            }
            String url = this.ossClientBean.getUrl(Convert.toStr((Object)model.getPdfUrl()));
            log.error("\u4e13\u59d4\u4f1a::\u65e5\u5fd7\u6253\u5370::\u8bc1\u4e66\u9644\u4ef6::{}", (Object)url);
            if (url != null && (sysFile = this.uploadFile(file = FileUtil.getNetUrl((String)url), "api/projectTrain", file.getName(), staffName, cid)) != null) {
                this.certificateStaffDetailService.addOrUpdateFile(sysFile.getId().toString(), cert.getId(), cert.getCid(), cert.getCreateBy());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u8bc1\u4e66\u540c\u6b65\u5931\u8d25";
        }
        return null;
    }

    private void syncResolveTrainRisk(RaTuCertificateModel model) {
        Long cid = model.getCid();
        if (cid == null) {
            throw new ServiceException("cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.reformItemBasicNewService.acceptDivide(List.of(cid), ReformGenerationSourceEnum.TRAIN.getValue(), Integer.valueOf(LocalDate.now().getYear()));
    }

    private Boolean synchronousDongYangCertData(TrainCertModel certSync) {
        if (certSync.getOnlineTrainId() == null || certSync.getCid() == null || CharSequenceUtil.isBlank((CharSequence)certSync.getStaffName())) {
            return Boolean.FALSE;
        }
        try {
            boolean okCert;
            CertificateStaffDetail cert = null;
            boolean bl = okCert = Objects.equals(certSync.getTrainPersonnelType(), CertificateStaffNameTypeEnum.MainTrain.getId()) || Objects.equals(certSync.getTrainPersonnelType(), CertificateStaffNameTypeEnum.ManaTrain.getId());
            if (okCert) {
                cert = this.certificateStaffDetailService.getDongYangCertBySyncInfo(certSync);
            }
            if (cert == null) {
                cert = new CertificateStaffDetail();
            }
            cert.setCertId(certSync.getTrainPersonnelType());
            cert.setDataSource(Byte.valueOf(CertificateStaffDetailDataSourceEnum.OFFLINE.getValue().byteValue()));
            cert.setStatus(ApprovalStatusEnum.NONEEDAPPROVAL.getValue());
            cert.setStaffName(certSync.getStaffName());
            cert.setCertNo(certSync.getCertNo());
            cert.setCertCreateDate(certSync.getCertCreateDate());
            cert.setValidityDate(certSync.getValidityDate());
            cert.setReportId(certSync.getOnlineTrainId());
            if (cert.getId() == null) {
                cert = (CertificateStaffDetail)this.certificateStaffDetailService.add((Object)cert, Long.valueOf(0L), certSync.getCid());
            } else {
                this.certificateStaffDetailService.update((Object)cert, Long.valueOf(0L));
            }
            CertificateFiles certFile = new CertificateFiles();
            certFile.setCid(certSync.getCid());
            certFile.setCerId(cert.getId());
            certFile.setIsValid(Boolean.TRUE);
            CertificateFiles dbCertFile = this.certificateFilesService.getCertificateFileByModel(certFile);
            certFile.setFileId(certSync.getFileId());
            if (dbCertFile == null) {
                this.certificateFilesService.add((Object)certFile);
            } else {
                this.certificateFilesService.delete((Object)dbCertFile);
                this.certificateFilesService.add((Object)certFile);
            }
            this.reformItemBasicNewService.autoAcceptance(Convert.toStr((Object)certSync.getCid()));
        }
        catch (Exception e) {
            log.error("\u7ebf\u4e0b\u57f9\u8bad\u8bc1\u4e66\u540c\u6b65\u5931\u8d25\uff1a", (Throwable)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String updateRealNameOrIdCard(TrainAttendModel model, List<StaffInfo> staffInfoList) {
        try {
            for (StaffInfo staffInfo : staffInfoList) {
                StaffBasicInfo basicInfo;
                if (staffInfo.getTrainUserId() == null) {
                    staffInfo.setTrainUserId(model.getTrainUserId());
                }
                if ((basicInfo = staffInfo.getStaffBasicInfo()) == null) continue;
                if (StringUtils.isNotEmpty((String)model.getNewIdCard())) {
                    basicInfo.setIdCard(model.getNewIdCard());
                    basicInfo.setAge(Integer.valueOf(IDCardUtil.getAge((String)model.getNewIdCard())));
                    basicInfo.setGender(IDCardUtil.getGender((String)model.getNewIdCard()));
                    basicInfo.setBirthday(IDCardUtil.getBirthday((String)model.getNewIdCard()));
                }
                basicInfo.setRealName(model.getStaffName());
                basicInfo.setUpdateBy(model.getTrainUserId());
                basicInfo.setUpdateDate(new Date());
                this.staffInfoService.updateStaffNameAndIdCard(staffInfo);
            }
            if (model.getOperationType() == 2) {
                ArrayList trainAttendList = new ArrayList();
                for (StaffInfo staffInfo : staffInfoList) {
                    trainAttendList.addAll(this.trainAttendService.getListByStaffId(staffInfo.getId()));
                }
                this.trainAttendService.batchUpdateStaffName(trainAttendList, model.getStaffName());
            } else {
                ArrayList projList = new ArrayList();
                for (StaffInfo staffInfo : staffInfoList) {
                    projList.addAll(this.trainProjStaffService.getListByStaffId(staffInfo.getId()));
                }
                if (CollectionUtils.isNotEmpty(projList)) {
                    this.trainProjStaffService.batchUpdateOrInsert(projList, TrainProjStaffMapper.class, (item, d) -> {
                        item.setIdCard(model.getNewIdCard());
                        item.setUpdateDate(new Date());
                        return d.updateByPrimaryKeySelective(item);
                    });
                }
            }
            ArrayList certificateList = new ArrayList();
            for (StaffInfo staffInfo : staffInfoList) {
                certificateList.addAll(this.certificateStaffDetailService.getCertByStaffId(staffInfo.getId(), null));
            }
            this.certificateStaffDetailService.batchUpdateStaffName(certificateList, model.getStaffName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u540c\u6b65\u5931\u8d25";
        }
        return null;
    }

    private String changeCompany(TrainAttendModel model) {
        if (model.getNewCid() == null || model.getOnlineTrainId() == null) {
            return "\u53d8\u66f4\u4f01\u4e1aID\u6216\u57f9\u8badID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        TrainProjReport trainProjReport = this.trainProjReportService.getByOnlineTrainId(model.getOnlineTrainId());
        if (trainProjReport == null) {
            return "\u672a\u67e5\u8be2\u5230\u57f9\u8bad\u9879\u76ee";
        }
        TrainPlan trainOld = this.trainPlanService.getByCidAndReportId(model.getCid(), trainProjReport.getId());
        if (trainOld == null) {
            return "\u672a\u67e5\u8be2\u5230\u539f\u4f01\u4e1a\u62a5\u540d\u8bb0\u5f55";
        }
        TrainPlan trainNew = this.trainPlanService.getByCidAndReportId(model.getNewCid(), trainProjReport.getId());
        if (trainNew == null) {
            return "\u672a\u67e5\u8be2\u5230\u65b0\u4f01\u4e1a\u62a5\u540d\u8bb0\u5f55";
        }
        StaffInfo staffInfoOld = this.staffInfoService.getStaffInfoByCidAndTrainUserId(model.getCid(), model.getTrainUserId());
        if (staffInfoOld == null) {
            return "\u672a\u67e5\u8be2\u5230\u8be5\u4eba\u5458\u4fe1\u606f";
        }
        StaffInfo staffInfoNew = this.staffInfoService.getStaffInfoByIdCardOrTrainUserId(model.getNewCid(), model.getStaffName(), model.getIdCard(), model.getTrainUserId());
        try {
            TrainAttend attend;
            TrainProjStaff projStaff = this.trainProjStaffService.getByStaffIdAndReportId(staffInfoOld.getId(), trainProjReport.getId());
            if (projStaff != null) {
                this.trainProjStaffService.delete((Object)projStaff, model.getTrainUserId());
                projStaff.setId(Long.valueOf(this.idworker.nextId()));
                projStaff.setStaffId(staffInfoNew.getId());
                projStaff.setIsValid(Global.TRUE);
                this.trainProjStaffService.add((Object)projStaff, model.getTrainUserId(), staffInfoNew.getCid());
            }
            if ((attend = this.trainAttendService.getByStaffIdAndTrainId(staffInfoOld.getId(), trainOld.getId())) != null) {
                this.trainAttendService.delete((Object)attend, model.getTrainUserId());
                attend.setId(Long.valueOf(this.idworker.nextId()));
                attend.setStaffId(staffInfoNew.getId());
                attend.setCid(staffInfoNew.getCid());
                attend.setTrainId(trainNew.getId());
                attend.setIsValid(Global.TRUE);
                this.trainAttendService.add((Object)attend, model.getTrainUserId(), staffInfoNew.getCid());
            }
            this.staffInfoService.deleteStaffInfoById(staffInfoOld.getId(), model.getTrainUserId(), null);
            List certificateOld = this.certificateStaffDetailService.getListByParam(staffInfoOld.getId(), staffInfoOld.getCid(), trainProjReport.getId());
            for (CertificateStaffDetail certificate : certificateOld) {
                this.certificateStaffDetailService.delete((Object)certificate, model.getTrainUserId());
                certificate.setId(Long.valueOf(this.idworker.nextId()));
                certificate.setCid(staffInfoNew.getCid());
                certificate.setStaffId(staffInfoNew.getId());
                certificate.setIsValid(Global.TRUE);
                this.certificateStaffDetailService.add((Object)certificate, model.getTrainUserId(), staffInfoNew.getCid());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u4fee\u6539\u5931\u8d25";
        }
        return null;
    }

    public String SyncAppUrl(SyncAppUrlModel model) {
        if (model.getAndroidAppUrl() != null) {
            Param androidAppUrl = this.paramService.getByKeyAndArea("train_app_android_url", Long.valueOf(0L));
            if (androidAppUrl != null) {
                androidAppUrl.setParamValue(model.getAndroidAppUrl());
                this.paramService.update((Object)androidAppUrl);
            } else {
                androidAppUrl = new Param();
                androidAppUrl.setAreaId(Long.valueOf(0L));
                androidAppUrl.setIsValid(Boolean.valueOf(true));
                androidAppUrl.setParamKey("train_app_android_url");
                androidAppUrl.setParamValue(model.getAndroidAppUrl());
                androidAppUrl.setName("\u57f9\u8badapp\u5b89\u5353\u4e0b\u8f7d\u5730\u5740");
                androidAppUrl.setParamDescribe("\u57f9\u8badapp\u5b89\u5353\u4e0b\u8f7d\u5730\u5740");
                this.paramService.add((Object)androidAppUrl);
            }
        }
        if (model.getIosAppUrl() != null) {
            Param iosAppUrl = this.paramService.getByKeyAndArea("train_app_ios_url", Long.valueOf(0L));
            if (iosAppUrl != null) {
                iosAppUrl.setParamValue(model.getIosAppUrl());
                this.paramService.update((Object)iosAppUrl);
            } else {
                iosAppUrl = new Param();
                iosAppUrl.setAreaId(Long.valueOf(0L));
                iosAppUrl.setIsValid(Boolean.valueOf(true));
                iosAppUrl.setParamKey("train_app_ios_url");
                iosAppUrl.setParamValue(model.getIosAppUrl());
                iosAppUrl.setName("\u57f9\u8badapp\u82f9\u679c\u4e0b\u8f7d\u5730\u5740");
                iosAppUrl.setParamDescribe("\u57f9\u8badapp\u82f9\u679c\u4e0b\u8f7d\u5730\u5740");
                this.paramService.add((Object)iosAppUrl);
            }
        }
        return "\u540c\u6b65\u6210\u529f";
    }

    private SysFileModel uploadFile(File obj, String ossPath, String fileName, String staffName, Long cid) throws IOException {
        SysFileModel file = new SysFileModel();
        String ext = "pdf";
        if (fileName.contains(".")) {
            ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        String certFileName = staffName + "\u7684\u8bc1\u4e66." + ext;
        String oss = this.ossClientBean.OSSPutObject(String.valueOf(UUID.randomUUID()) + ".pdf", obj, ossPath, certFileName, "" + FileUtils.checksumCRC32((File)obj));
        file.setFileName(certFileName);
        file.setResource(Integer.valueOf(FileResourceEnum.companyHealth_07.getValue()));
        file.setFileSize(FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)obj)));
        file.setFileExt(ext);
        file.setCid(cid);
        file.setFileHash("" + FileUtils.checksumCRC32((File)obj));
        file.setOssUrl(oss);
        file.setDescription("\u8bc1\u4e66\u6587\u4ef6");
        file = this.sysFileProvideService.addSysFile(file, Long.valueOf(0L));
        return file;
    }

    public Map<Long, IssuedModel> issuedBy(List<Long> cids) {
        HashMap<Long, IssuedModel> map = new HashMap<Long, IssuedModel>(cids.size());
        if (CollectionUtils.isNotEmpty(cids)) {
            try {
                for (Long cid : cids) {
                    CompanySuperviseModel companyInfo = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
                    if (companyInfo == null) continue;
                    Integer belongType = companyInfo.getBelongType();
                    if (belongType == null || belongType.equals(CompanyBelongTypeEnum.NO.getValue())) {
                        Long areaId = companyInfo.getAreaId();
                        this.extracted(map, cid, areaId);
                        continue;
                    }
                    if (belongType.equals(CompanyBelongTypeEnum.SHI.getValue())) {
                        Long cityId = companyInfo.getCityId();
                        this.extracted(map, cid, cityId);
                        continue;
                    }
                    if (!belongType.equals(CompanyBelongTypeEnum.SHENG.getValue())) continue;
                    Long provinceId = companyInfo.getProvinceId();
                    this.extracted(map, cid, provinceId);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public Map<String, Object> issuedBy(Long cid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (cid == null) {
            throw new ServiceException("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CompanySuperviseModel companyInfo = this.companyProvideBySuperviseService.getCompanyInfoById(cid);
        if (companyInfo == null) {
            return map;
        }
        Integer belongType = companyInfo.getBelongType();
        Long areaId = null;
        if (belongType == null || belongType.equals(CompanyBelongTypeEnum.NO.getValue())) {
            areaId = companyInfo.getAreaId();
        } else if (belongType.equals(CompanyBelongTypeEnum.SHI.getValue())) {
            areaId = companyInfo.getCityId();
        } else if (belongType.equals(CompanyBelongTypeEnum.SHENG.getValue())) {
            areaId = companyInfo.getProvinceId();
        }
        Organization organization = this.organizationService.getOrganizationByAreaId(areaId);
        if (organization == null) {
            return map;
        }
        map.put("name", organization.getName());
        map.put("id", organization.getId());
        return map;
    }

    @Transactional(readOnly=false)
    public TrainStaffInfoModel getOrUpdateStaffInfo(TrainAttendModel model) {
        TrainStaffInfoModel trainStaffInfoModel = new TrainStaffInfoModel();
        if (model == null) {
            trainStaffInfoModel.setMessage("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return trainStaffInfoModel;
        }
        List staffInfoList = this.staffInfoService.getListByTrainUserId(model.getTrainUserId());
        if (staffInfoList == null) {
            staffInfoList = this.staffInfoService.getStaffInfoByCardId(model.getIdCard());
        }
        if (staffInfoList == null || staffInfoList.size() == 0) {
            trainStaffInfoModel.setMessage("\u672a\u67e5\u8be2\u5230\u8be5\u4eba\u5458\u4fe1\u606f");
            return trainStaffInfoModel;
        }
        StaffInfo staff = (StaffInfo)staffInfoList.get(0);
        if (model.getOperationType() == 1) {
            if (staff.getStaffBasicInfo() == null) {
                trainStaffInfoModel.setMessage("\u672a\u67e5\u8be2\u5230\u8be5\u4eba\u5458\u57fa\u7840\u4fe1\u606f");
                return trainStaffInfoModel;
            }
            trainStaffInfoModel.setRealName(staff.getStaffBasicInfo().getRealName());
            trainStaffInfoModel.setIdCard(staff.getStaffBasicInfo().getIdCard());
            return trainStaffInfoModel;
        }
        if (model.getOperationType() == 2) {
            if (StringUtils.isEmpty((CharSequence)model.getIdCard())) {
                trainStaffInfoModel.setMessage("\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                return trainStaffInfoModel;
            }
            if (!model.getIdCard().equals(staff.getStaffBasicInfo().getIdCard())) {
                trainStaffInfoModel.setMessage("\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u4fee\u6539\u5931\u8d25");
                return trainStaffInfoModel;
            }
            String ver = this.updateRealNameOrIdCard(model, staffInfoList);
            if (ver != null) {
                trainStaffInfoModel.setMessage(ver);
                return trainStaffInfoModel;
            }
        } else if (model.getOperationType() == 3) {
            if (StringUtils.isEmpty((CharSequence)model.getIdCard())) {
                trainStaffInfoModel.setMessage("\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                return trainStaffInfoModel;
            }
            String ver = this.updateRealNameOrIdCard(model, staffInfoList);
            if (ver != null) {
                trainStaffInfoModel.setMessage(ver);
                return trainStaffInfoModel;
            }
        } else {
            trainStaffInfoModel.setMessage("\u64cd\u4f5c\u6570\u9519\u8bef\uff0c\u4fee\u6539\u5931\u8d25");
            return trainStaffInfoModel;
        }
        trainStaffInfoModel.setRealName(model.getStaffName());
        trainStaffInfoModel.setIdCard(model.getIdCard());
        return trainStaffInfoModel;
    }

    private Boolean existsCompany(Long cid) {
        if (cid == null) {
            return false;
        }
        List onlnyCompanyByIdList = this.companyProvideBySuperviseService.getOnlyCompanyByCid(Collections.singletonList(cid));
        return CollectionUtils.isNotEmpty((Collection)onlnyCompanyByIdList);
    }

    private void extracted(Map<Long, IssuedModel> map, Long cid, Long cityId) {
        if (cityId != null) {
            IssuedModel model = new IssuedModel();
            Organization organization = this.organizationService.getOrganizationByAreaId(cityId);
            if (organization != null) {
                model.setIssueUnit(organization.getName());
                List organizationUserList = this.organizationUserService.getListByOid(organization.getId());
                if (CollectionUtils.isNotEmpty((Collection)organizationUserList)) {
                    ArrayList result = new ArrayList(organizationUserList.size());
                    organizationUserList.stream().forEach(i -> result.add(i.getUsername()));
                    model.setUsername(result);
                }
            }
            map.put(cid, model);
        }
    }

    @Transactional(readOnly=false)
    public String batchUpdateTrainPlan(List<TrainPlanUpdateModel> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        int pageSize = 1000;
        int pages = (int)Math.ceil((double)list.size() * 1.0 / (double)pageSize);
        for (int i = 0; i < pages; ++i) {
            this.commitOneBatch(i, pageSize, list);
        }
        return null;
    }

    private void commitOneBatch(int page, int pageSize, List<TrainPlanUpdateModel> list) {
        ArrayList<TrainPlan> trainPlanList = new ArrayList<TrainPlan>();
        TransactionStatus status = null;
        try {
            List subList = list.stream().skip(page * pageSize).limit(pageSize).collect(Collectors.toList());
            if (subList.size() == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (Object model : subList) {
                if (model.getReportId() == null) continue;
                sb.append(model.getReportId()).append(",");
            }
            Map map = this.trainProjReportService.getByOnlineTrainIds(sb.toString());
            for (TrainPlanUpdateModel model : subList) {
                TrainProjReport trainProjReportId;
                if (model.getReportId() == null || (trainProjReportId = (TrainProjReport)map.get(model.getReportId())) == null) continue;
                TrainPlan trainPlan = new TrainPlan();
                trainPlan.setReportId(trainProjReportId.getId());
                trainPlan.setCid(model.getCid());
                trainPlan.setKeyPersonStatus(model.getKeyPersonStatus());
                trainPlan.setManagePersonStatus(model.getManagePersonStatus());
                trainPlan.setUpdateDate(new Date());
                trainPlanList.add(trainPlan);
            }
            if (trainPlanList.size() > 0) {
                DefaultTransactionDefinition def = new DefaultTransactionDefinition();
                def.setPropagationBehavior(3);
                status = this.txManager.getTransaction((TransactionDefinition)def);
                for (TrainPlan trainPlan : trainPlanList) {
                    this.trainPlanService.updateStatusByReportIdAndCid(trainPlan);
                }
                this.txManager.commit(status);
            }
        }
        catch (Exception e) {
            if (status != null) {
                this.txManager.rollback(status);
            }
            e.printStackTrace();
        }
    }

    public List<Long> getAllOnlineTrainId() {
        return this.trainProjReportService.getAllOnlineTrainId();
    }

    @Transactional(readOnly=false)
    public String perTrainingInfoDeleteAndRecovery(PerTrainingInfoModel model) {
        if (model.getOnlineTrainId() == null || model.getCid() == null || model.getTrainUserId() == null) {
            return "\u53c2\u6570\u5f02\u5e38";
        }
        TrainProjReport trainProjReport = this.trainProjReportService.getByOnlineTrainId(model.getOnlineTrainId());
        if (trainProjReport == null) {
            return "\u672a\u67e5\u8be2\u5230\u57f9\u8bad\u9879\u76ee";
        }
        if (model.getOperationType() == 1) {
            TrainPlan trainPlan = this.trainPlanService.getByCidAndReportId(model.getCid(), trainProjReport.getId());
            if (trainPlan == null) {
                return "\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u62a5\u540d\u8bb0\u5f55";
            }
            StaffInfo staff = this.staffInfoService.getStaffInfoByCidAndTrainUserId(model.getCid(), model.getTrainUserId());
            if (staff == null) {
                return "\u672a\u67e5\u8be2\u5230\u8be5\u4eba\u5458\u4fe1\u606f";
            }
            TrainProjStaff projStaff = this.trainProjStaffService.getByStaffIdAndReportId(staff.getId(), trainProjReport.getId());
            TrainAttend attend = this.trainAttendService.getByStaffIdAndTrainId(staff.getId(), trainPlan.getId());
            List certificateStaffDetailList = this.certificateStaffDetailService.getListByParam(staff.getId(), model.getCid(), trainProjReport.getId());
            for (CertificateStaffDetail certificate : certificateStaffDetailList) {
                if (certificate == null) continue;
                this.certificateStaffDetailService.delete((Object)certificate, model.getUpdateBy());
            }
            if (attend != null) {
                this.trainAttendService.delete((Object)attend, model.getUpdateBy());
            }
            if (projStaff != null) {
                this.trainProjStaffService.delete((Object)projStaff, model.getUpdateBy());
            }
            this.staffInfoService.deleteStaffInfoById(staff.getId(), model.getUpdateBy(), null);
            this.archiveUpdateService.refreshArchive(model.getCid(), "302");
            return null;
        }
        if (model.getOperationType() == 2) {
            return null;
        }
        return "\u64cd\u4f5c\u6570\u9519\u8bef";
    }

    @Transactional(readOnly=false)
    public String getCompanyTrainNumber(Long trainingId, Integer completedCompanyNumber) {
        if (trainingId == null || completedCompanyNumber == null) {
            return "\u53c2\u6570\u5f02\u5e38";
        }
        TrainProjReport trainProjReport = this.trainProjReportService.getByOnlineTrainId(trainingId);
        if (trainProjReport != null) {
            trainProjReport.setCompletedCompanyNumber(completedCompanyNumber);
            this.trainProjReportService.updateByPrimaryKey((Object)trainProjReport, trainProjReport.getId());
            return null;
        }
        return "\u672a\u67e5\u8be2\u5230\u57f9\u8bad\u9879\u76ee";
    }

    @Transactional(readOnly=false)
    public void syncBatchCertInfo(List<CertificateStaffDetail> details) {
        this.certificateStaffDetailService.saveBatch(details);
    }

    private long insertAndReturnStaffId(RaTuCertificateModel model) {
        Long cid = model.getCid();
        String staffName = SpringEncryptUtils.decrypt((String)model.getUname());
        String idCard = SpringEncryptUtils.decrypt((String)model.getIdCard());
        long staffId = this.idworker.nextId();
        long staffBasicId = this.idworker.nextId();
        long staffBasicWorkId = this.idworker.nextId();
        long staffWorkRoleId = this.idworker.nextId();
        StaffInfo staffInfo = new StaffInfo();
        staffInfo.setId(Long.valueOf(staffId));
        staffInfo.setCid(cid);
        staffInfo.setStaffBasicId(Long.valueOf(staffBasicId));
        staffInfo.setStaffName(staffName);
        staffInfo.setIsThirdParty(Boolean.FALSE);
        staffInfo.setCreateBy(cid);
        staffInfo.setUpdateBy(cid);
        staffInfo.setIsValid(Boolean.TRUE);
        StaffBasicInfo staffBasicInfo = new StaffBasicInfo();
        staffBasicInfo.setId(Long.valueOf(staffBasicId));
        staffBasicInfo.setCid(cid);
        staffBasicInfo.setRealName(staffName);
        staffBasicInfo.setGender(IDCardUtil.getGender((String)idCard));
        staffBasicInfo.setIdCard(idCard);
        staffBasicInfo.setBirthday(IDCardUtil.getBirthday((String)idCard));
        staffBasicInfo.setAge(Integer.valueOf(IDCardUtil.getAge((String)idCard)));
        staffBasicInfo.setCreateBy(cid);
        staffBasicInfo.setUpdateBy(cid);
        staffBasicInfo.setIsValid(Boolean.TRUE);
        StaffBasicWork staffBasicWork = new StaffBasicWork();
        staffBasicWork.setId(Long.valueOf(staffBasicWorkId));
        staffBasicWork.setCid(cid);
        staffBasicWork.setStaffId(Long.valueOf(staffId));
        staffBasicWork.setCreateBy(cid);
        staffBasicWork.setUpdateBy(cid);
        staffBasicWork.setIsValid(Boolean.TRUE);
        StaffWorkRole staffWorkRole = new StaffWorkRole();
        staffWorkRole.setId(Long.valueOf(staffWorkRoleId));
        staffWorkRole.setCid(cid);
        staffWorkRole.setStaffId(Long.valueOf(staffId));
        staffWorkRole.setStaffName(staffName);
        staffWorkRole.setIdCard(idCard);
        staffWorkRole.setWorkProperty(StaffWorkPropertyEnum.MAJOR.getValue());
        staffWorkRole.setStatus(StaffWorkStatusEnum.ONWORKING.getValue());
        staffWorkRole.setIsThirdParty(Boolean.FALSE);
        staffWorkRole.setIsHistory(Boolean.FALSE);
        staffWorkRole.setCreateBy(cid);
        staffWorkRole.setUpdateBy(cid);
        staffWorkRole.setIsValid(Boolean.TRUE);
        staffBasicWork.setCurrentStaffWorkRole(staffWorkRole);
        staffInfo.setStaffBasicInfo(staffBasicInfo);
        staffInfo.setStaffBasicWork(staffBasicWork);
        this.staffInfoService.addNewStaffInfoSubmitV24(staffInfo);
        return staffId;
    }
}

