/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.trainPlan;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.entity.base.company.CompanyFunctionalOrganizationMember;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.enums.certificate.OccHeaStaffTypeEnum;
import cn.smarthse.modules.health.enums.company.FunOrgMemberTypeEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessFromEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessTypeEnum;
import cn.smarthse.modules.health.enums.train.TrainPlanTypeEnum;
import cn.smarthse.modules.health.service.sys.message.IMessageService;
import cn.smarthse.modules.health.supervise.dao.trainPlan.SuperviseTrainPlanMapper;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.entity.trainPlan.BlocTrainPlanCountInfo;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainCountParam;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanCompanyInfo;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanCompanyListVo;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanCountQueryVo;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanInfo;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanQueryVo;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainSummInfo;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.certificate.ISuperviseCertificateService;
import cn.smarthse.modules.health.supervise.service.company.ICompanyFunOrgService;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISuperviseTrainPlanService;
import cn.smarthse.modules.health.supervise.vo.train.DutyTrainPlanItem;
import cn.smarthse.modules.health.supervise.vo.train.TrainPlanCountScaleVo;
import cn.smarthse.modules.health.supervise.vo.train.TrainPlanInfoVo;
import cn.smarthse.modules.health.supervise.vo.train.TrainPlanPersonVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class SuperviseTrainPlanServiceImpl
implements ISuperviseTrainPlanService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SuperviseTrainPlanServiceImpl.class);
    @Autowired
    private SuperviseTrainPlanMapper dao;
    @Autowired
    private ISuperviseCertificateService certService;
    @Autowired
    private ICompanyFunOrgService comFunService;
    @DubboReference
    private IOrganizationUserService organizationUserService;
    @DubboReference
    private IMessageService messageService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;

    public int getTrainCompanyNumByAreaAndYear(Long areaId, Byte level, Integer year) {
        if (areaId == null || year == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("level", level);
        params.put("areaId", areaId);
        Integer comNum = this.dao.getTrainCompanyNumByAreaAndYear(params);
        return comNum;
    }

    public int getTrainCompanyNumByAreaAndTime(Long areaId, Byte level, Date beginTime, Date endTime, Byte ownLevel) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("ownLevel", ownLevel);
        Integer comNum = this.dao.getTrainCompanyNumByAreaAndTime(params);
        return comNum;
    }

    public int getWillExpireMainTrainComNum(Long areaId, Byte level, Date beginTime, Date endTime) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("trainType", 1);
        List<TrainPlanCompanyInfo> list = this.dao.getWillExpireTrainComList(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public int getExpireMainTrainComNum(Long areaId, Byte level) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("trainType", 1);
        return this.dao.getExpireTrainComCount(params);
    }

    public int getExpireHseTrainComNum(Long areaId, Byte level) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("trainType", 2);
        return this.dao.getExpireTrainComCount(params);
    }

    public int getWillExpireHseTrainComNum(Long areaId, Byte level, Date beginTime, Date endTime) {
        if (areaId == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("trainType", 2);
        List<TrainPlanCompanyInfo> list = this.dao.getWillExpireTrainComList(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public List<TrainPlanCompanyInfo> getWillExpireMainTrainComList(Long areaId, Byte level, Date beginTime, Date endTime) {
        if (areaId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("trainType", 1);
        List<TrainPlanCompanyInfo> list = this.dao.getExpireTrainComList(params);
        return list;
    }

    public List<TrainPlanCompanyInfo> getExpireMainTrainComList(Long areaId, Byte level) {
        if (areaId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("trainType", 1);
        List<TrainPlanCompanyInfo> list = this.dao.getExpireTrainComList(params);
        return list;
    }

    public List<TrainPlanCompanyInfo> getExpireHseTrainComList(Long areaId, Byte level) {
        if (areaId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("trainType", 2);
        List<TrainPlanCompanyInfo> list = this.dao.getExpireTrainComList(params);
        return list;
    }

    public List<TrainPlanCompanyInfo> getWillExpireHseTrainComList(Long areaId, Byte level, Date beginTime, Date endTime) {
        if (areaId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("level", level);
        params.put("areaId", areaId);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        params.put("trainType", 2);
        List<TrainPlanCompanyInfo> list = this.dao.getExpireTrainComList(params);
        return list;
    }

    public int trainNumberThisYear(Long cid, Integer year) {
        if (cid == null || year == null) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("year", year);
        params.put("cid", cid);
        params.put("type", Character.valueOf('1'));
        List<TrainPlanInfo> list = this.dao.listOfTrainByYear(params);
        if (list != null && list.size() > 0) {
            return list.size();
        }
        return 0;
    }

    public PageInfo<TrainPlanInfo> getPreviousTrainInfo(JqGridParam gparam, Long cid, Integer yearFlag) {
        if (cid == null) {
            return null;
        }
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cid", cid);
        params.put("yearFlag", yearFlag);
        params.put("type", Character.valueOf('1'));
        List<TrainPlanInfo> list = this.dao.getLististOfTrainByCid(params);
        for (TrainPlanInfo tp : list) {
            tp.setTrainType(this.getTypeName(tp.getTrainType()));
            Byte way = 1;
            if (tp.getTrainWay() != null) {
                if (tp.getTrainWay().equals(way)) {
                    tp.setTrainWayName("\u5185\u90e8\u57f9\u8bad");
                } else {
                    tp.setTrainWayName("\u5916\u90e8\u57f9\u8bad");
                }
            }
            if (tp.getTrainTime() != null) {
                SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd");
                String datastr = time.format(tp.getTrainTime());
                tp.setDataStr(datastr);
                continue;
            }
            tp.setDataStr("-");
        }
        return new PageInfo(list);
    }

    private String getTypeName(String type) {
        Object typeName = null;
        if (!StringUtils.isEmpty((CharSequence)type)) {
            List types = new ArrayList();
            types = StringUtils.parseToIntegerList((String)type, (String)",");
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                for (TrainPlanTypeEnum tpType : TrainPlanTypeEnum.values()) {
                    if ((byte)t != tpType.getCode()) continue;
                    typeName = typeName == null ? tpType.getName() : (String)typeName + "," + tpType.getName();
                }
            }
            return typeName;
        }
        return null;
    }

    public TrainSummInfo getTrainSummByCidAndYear(Long cid, Integer year) {
        TrainSummInfo info = new TrainSummInfo();
        int trainNum = this.trainNumberThisYear(cid, year);
        info.setTrainNum(Integer.valueOf(trainNum));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String year1 = sdf.format(date);
        Integer years = Integer.valueOf(year1);
        if (year.equals(years)) {
            int effectiveCert = this.certService.getEffectiveCertByCidThisYear(cid, year);
            int expireCert = this.certService.getExpireCertByCidThisYear(cid, year);
            info.setCertEffectiveNum(Integer.valueOf(effectiveCert));
            info.setCertExpireNum(Integer.valueOf(expireCert));
        } else {
            int effectiveCert = this.certService.getEffectiveCertByCidAndYear(cid, year);
            int expireCert = this.certService.getExpireCertByCidAndYear(cid, year);
            info.setCertEffectiveNum(Integer.valueOf(effectiveCert));
            info.setCertExpireNum(Integer.valueOf(expireCert));
        }
        return info;
    }

    public List<TrainPlanCompanyInfo> getHseManagerTrainCompanies() {
        TrainPlanQueryVo vo = new TrainPlanQueryVo();
        vo.setTrainType(OccHeaStaffTypeEnum.OccHeaMan.getCode());
        List<TrainPlanCompanyInfo> list = this.dao.haveHseTrainCompaniesInfo(vo);
        return list;
    }

    public List<TrainPlanCompanyInfo> getMainManagerTrainCompanies() {
        TrainPlanQueryVo vo = new TrainPlanQueryVo();
        vo.setTrainType(OccHeaStaffTypeEnum.MAIN.getCode());
        List<TrainPlanCompanyInfo> list = this.dao.haveHseTrainCompaniesInfo(vo);
        return list;
    }

    public List<TrainPlanCompanyInfo> blocHaveMainManagerTrainCompanies(List<Long> childrenSmarthseCids) {
        if (childrenSmarthseCids != null && childrenSmarthseCids.size() > 0) {
            String cids = this.getCidStr(childrenSmarthseCids);
            TrainPlanQueryVo vo = new TrainPlanQueryVo();
            vo.setCids(cids);
            vo.setTrainType(OccHeaStaffTypeEnum.MAIN.getCode());
            List<TrainPlanCompanyInfo> list = this.dao.haveHseTrainCompanies(vo);
            return list;
        }
        return null;
    }

    private String getCidStr(List<Long> childrenSmarthseCids) {
        Object cids = "-9";
        for (Long s : childrenSmarthseCids) {
            cids = (String)cids + "," + s;
        }
        return cids;
    }

    public List<TrainPlanCompanyInfo> blocHaveHseManagerTrainCompanies(List<Long> childrenSmarthseCids) {
        if (childrenSmarthseCids != null && childrenSmarthseCids.size() > 0) {
            String cids = this.getCidStr(childrenSmarthseCids);
            TrainPlanQueryVo vo = new TrainPlanQueryVo();
            vo.setCids(cids);
            vo.setTrainType(OccHeaStaffTypeEnum.OccHeaMan.getCode());
            List<TrainPlanCompanyInfo> list = this.dao.haveHseTrainCompanies(vo);
            return list;
        }
        return null;
    }

    public List<TrainPlanCompanyInfo> blocExpireMainManagerTrainCompanies(List<Long> childrenSmarthseCids) {
        if (childrenSmarthseCids != null && childrenSmarthseCids.size() > 0) {
            TrainPlanQueryVo vo = new TrainPlanQueryVo();
            String cids = this.getCidStr(childrenSmarthseCids);
            vo.setCids(cids);
            vo.setTrainType(OccHeaStaffTypeEnum.MAIN.getCode());
            List<TrainPlanCompanyInfo> list = this.dao.expireTrainCompanies(vo);
            return list;
        }
        return null;
    }

    public List<TrainPlanCompanyInfo> blocExpireHseManagerTrainCompanies(List<Long> childrenSmarthseCids) {
        if (childrenSmarthseCids != null && childrenSmarthseCids.size() > 0) {
            TrainPlanQueryVo vo = new TrainPlanQueryVo();
            String cids = this.getCidStr(childrenSmarthseCids);
            vo.setCids(cids);
            vo.setTrainType(OccHeaStaffTypeEnum.OccHeaMan.getCode());
            List<TrainPlanCompanyInfo> list = this.dao.expireTrainCompanies(vo);
            return list;
        }
        return null;
    }

    public List<TrainPlanCompanyInfo> blocWillExpireHseManagerTrainCompaniesByTime(Date beginTime, Date endTime, List<Long> childrenSmarthseCids) {
        if (childrenSmarthseCids != null && childrenSmarthseCids.size() > 0) {
            TrainPlanQueryVo vo = new TrainPlanQueryVo();
            String cids = this.getCidStr(childrenSmarthseCids);
            vo.setCids(cids);
            vo.setTrainType(OccHeaStaffTypeEnum.OccHeaMan.getCode());
            vo.setBeginTime(beginTime);
            vo.setEndTime(endTime);
            List<TrainPlanCompanyInfo> list = this.dao.expireTrainCompaniesByVo(vo);
            return list;
        }
        return null;
    }

    public List<TrainPlanCompanyInfo> blocWillExpireMainManagerTrainCompaniesByTime(Date beginTime, Date endTime, List<Long> childrenSmarthseCids) {
        if (childrenSmarthseCids != null && childrenSmarthseCids.size() > 0) {
            TrainPlanQueryVo vo = new TrainPlanQueryVo();
            vo.setTrainType(OccHeaStaffTypeEnum.MAIN.getCode());
            vo.setBeginTime(beginTime);
            vo.setEndTime(endTime);
            String cids = this.getCidStr(childrenSmarthseCids);
            vo.setCids(cids);
            List<TrainPlanCompanyInfo> list = this.dao.expireTrainCompaniesByVo(vo);
            return list;
        }
        return null;
    }

    public BlocTrainPlanCountInfo getBlocTrainPlanCountInfo(Long cid) {
        BlocTrainPlanCountInfo info = new BlocTrainPlanCountInfo();
        if (cid == null) {
            return info;
        }
        int fullTimeNum = 0;
        int partTimeNum = 0;
        int haveCertNum = 0;
        if (this.certService.haveMainEffectiveCertByCid(cid).booleanValue()) {
            info.setMainManagerTrain("\u662f");
        } else {
            info.setMainManagerTrain("\u5426");
        }
        List commem = this.comFunService.getMemberListByCid(cid);
        for (CompanyFunctionalOrganizationMember member : commem) {
            if (member.getMemberType() == null) continue;
            if (FunOrgMemberTypeEnum.special.getCode().equals(member.getMemberType())) {
                ++fullTimeNum;
                continue;
            }
            ++partTimeNum;
        }
        List certList = this.certService.getHaveEffectiveHseCertListBycid(cid);
        if (certList != null) {
            haveCertNum = certList.size();
        }
        info.setManagerNum(Integer.valueOf(fullTimeNum + partTimeNum));
        info.setFullTimeNum(Integer.valueOf(fullTimeNum));
        info.setPartTimeNum(Integer.valueOf(partTimeNum));
        info.setCertEffectiveNum(Integer.valueOf(haveCertNum));
        if (haveCertNum > 0) {
            info.setHseManagerTrain("\u662f");
        } else {
            info.setHseManagerTrain("\u5426");
        }
        return info;
    }

    public PageInfo<BlocTrainPlanCountInfo> blocCompanyTrainCountInfos(JqGridParam param, List<BlocTrainPlanCountInfo> trainList, TrainCountParam trainCountParam) {
        if (trainList == null || trainList.size() == 0) {
            return new PageInfo(null);
        }
        if (param != null && StringUtils.isNotEmpty((String)param.getSidx())) {
            trainCountParam.setOrderCase(param.getSidx() + " " + param.getSord());
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getRows());
        List<BlocTrainPlanCountInfo> list = this.dao.blocCompanyTrainCountInfos(trainList, trainCountParam);
        PageInfo page = new PageInfo(list);
        return page;
    }

    public String getTrainSummInfoByCidAndYear(Long cid, Integer year) {
        int trainNum = this.trainNumberThisYear(cid, year);
        int effectiveCert = 0;
        int expireCert = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String year1 = sdf.format(date);
        Integer years = Integer.valueOf(year1);
        if (year.equals(years)) {
            effectiveCert = this.certService.getEffectiveCertByCidThisYear(cid, year);
            expireCert = this.certService.getExpireCertByCidThisYear(cid, year);
        } else {
            effectiveCert = this.certService.getEffectiveCertByCidAndYear(cid, year);
            expireCert = this.certService.getExpireCertByCidAndYear(cid, year);
        }
        String result = null;
        result = trainNum == 0 ? "\u672a\u8fdb\u884c\u6559\u80b2\u57f9\u8bad,\u8bc1\u4e66\u6709\u6548\u4eba\u6570<strong class='ft18 red'>" + effectiveCert + "</strong>\u4eba\uff0c\u8fc7\u671f\u4eba\u6570<strong class='ft18 red'>" + expireCert + "</strong>\u4eba" : "\u5df2\u8fdb\u884c\u6559\u80b2\u57f9\u8bad<strong class='ft18 red'>" + trainNum + "</strong>\u6b21,\u8bc1\u4e66\u6709\u6548\u4eba\u6570<strong class='ft18 red'>" + effectiveCert + "</strong>\u4eba\uff0c\u8fc7\u671f\u4eba\u6570<strong class='ft18 red'>" + expireCert + "</strong>\u4eba";
        return result;
    }

    public Integer getTrainPlanCompanyCountByIndustry(Long areaId, Byte level, String industryCategoryIds, Integer year) {
        ArrayList<Long> iids = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((String)industryCategoryIds)) {
            iids.addAll(Arrays.asList(industryCategoryIds.split(",")).stream().mapToLong(s -> Long.valueOf(s)).boxed().collect(Collectors.toList()));
        }
        if (iids.size() == 0) {
            return 0;
        }
        return this.dao.getTrainPlanCompanyCountByIndustry(areaId, level, iids, year);
    }

    public Integer getTrainPlanCompanyCountByHarms(String harmIds, Long areaId, Byte areaLevel) {
        ArrayList<Long> hids = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((String)harmIds)) {
            hids.addAll(Arrays.asList(harmIds.split(",")).stream().mapToLong(s -> Long.valueOf(s)).boxed().collect(Collectors.toList()));
        }
        if (hids.size() == 0) {
            return 0;
        }
        return this.dao.getTrainPlanCompanyCountByHarms(hids, areaId, areaLevel);
    }

    public List<TrainPlanCountScaleVo> getTrainPlanCompanyCountByScale(Long areaId, Byte areaLevel) {
        return this.dao.getTrainPlanCompanyCountByScale(areaId, areaLevel);
    }

    public PageInfo<TrainPlanCompanyListVo> getTrainPlanCompanyList(JqGridParam gparam, TrainPlanCountQueryVo param) {
        PageHelper.startPage((int)gparam.getPage(), (int)gparam.getRows());
        List<TrainPlanCompanyListVo> list = this.dao.getTrainPlanCompanyList(param);
        PageInfo page = new PageInfo(list);
        return page;
    }

    @Transactional(readOnly=false)
    public Boolean sendOnlineTrainAddMessage(Long id, Long businessId, Long areaId, Byte level, String trainName, String processUrl, Integer sendBelong) {
        log.info("\u5f00\u59cb\u53d1\u9001\u65b0\u589e\u5728\u7ebf\u57f9\u8bad\u8bfe\u7a0b\u6d88\u606f\u2014\u2014\u2014\u2014>\u65f6\u95f4:{},\u76d1\u7ba1id:{},\u533a\u57dfid:{},\u57f9\u8bad\u7cfb\u7edf\u4e2d\u7684\u57f9\u8badid:{}", new Object[]{DateUtils.getDateTime(), id, areaId, businessId});
        if (Objects.isNull(id) || Objects.isNull(businessId) || Objects.isNull(areaId) || Objects.isNull(level) || StringUtils.isEmpty((CharSequence)trainName) || StringUtils.isEmpty((CharSequence)processUrl)) {
            return Boolean.FALSE;
        }
        OrganizationUser organizationUser = this.organizationUserService.getUserInfoById(id);
        Date now = DateUtil.getDateNow();
        Message message = new Message();
        message.setCid(null);
        message.setBussinesId(businessId);
        message.setBussinesType(MessageBusinessTypeEnum.notice.getValue());
        message.setBussinesName("\u65b0\u589e\u5728\u7ebf\u57f9\u8bad\u8bfe\u7a0b");
        message.setBussinesNo(null);
        message.setBussinessContent(organizationUser.getOrganization().getName() + "\u53d1\u5e03\u4e86\u201d" + trainName + "\u201c\u57f9\u8bad\uff0c\u8bf7\u901a\u77e5\u76f8\u5173\u4eba\u5458\u524d\u5f80\u6d59\u91cc\u529e-\u536b\u4f01\u5728\u7ebf\u62a5\u540d\u57f9\u8bad");
        message.setBussinesFromType(MessageBusinessFromEnum.onlineTraining.getValue());
        message.setBussinesFrom(organizationUser.getOrganization().getName() + "/" + organizationUser.getUsername());
        message.setSendTime(now);
        message.setProcessUrl(processUrl);
        message.setCreateUser(organizationUser.getUsername());
        message.setCreateBy(organizationUser.getId());
        message.setCreateDate(now);
        message.setAreaId(areaId);
        message.setSendBelong(sendBelong);
        Message addResult = this.messageService.addMessage(message);
        if (Objects.isNull(addResult)) {
            log.error("\u53d1\u9001\u65b0\u589e\u5728\u7ebf\u57f9\u8bad\u8bfe\u7a0b\u6d88\u606f\u5931\u8d25\u2014\u2014\u2014\u2014>\u4fdd\u5b58\u5230message\u8868\u5931\u8d25\uff0c\u57f9\u8badid\uff1a{}", (Object)businessId);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Transactional(readOnly=false)
    public Boolean sendOnlineTrainBackMessage(Long id, Long cid, Long businessId, String trainName, String processUrl) {
        log.info("\u5f00\u59cb\u53d1\u9001\u9000\u56de\u62a5\u540d\u6d88\u606f\u2014\u2014\u2014\u2014>\u65f6\u95f4:{},\u76d1\u7ba1id:{},\u4f01\u4e1aid:{},\u57f9\u8bad\u7cfb\u7edf\u4e2d\u7684\u57f9\u8badid:{}", new Object[]{DateUtils.getDateTime(), id, cid, businessId});
        if (Objects.isNull(id) || Objects.isNull(cid) || Objects.isNull(businessId) || StringUtils.isEmpty((CharSequence)trainName) || StringUtils.isEmpty((CharSequence)processUrl)) {
            return Boolean.FALSE;
        }
        OrganizationUser organizationUser = (OrganizationUser)this.organizationUserService.getById(id);
        Date now = DateUtil.getDateNow();
        Message message = new Message();
        message.setCid(cid);
        message.setBussinesId(businessId);
        message.setBussinesType(MessageBusinessTypeEnum.notice.getValue());
        message.setBussinesName("\u9000\u56de\u5355\u4f4d\u5728\u7ebf\u57f9\u8bad\u8bfe\u7a0b\u62a5\u540d\u4fe1\u606f");
        message.setBussinesNo(null);
        message.setBussinessContent("\u4f60\u62a5\u540d\u7684\u57f9\u8bad\u201c" + trainName + "\u57f9\u8bad\u201d\uff0c\u88ab" + organizationUser.getFullName() + "\u9000\u56de\uff0c\u8bf7\u901a\u77e5\u76f8\u5173\u4eba\u5458\u524d\u5f80\u6d59\u91cc\u529e-\u536b\u4f01\u5728\u7ebf\u91cd\u65b0\u62a5\u540d\u57f9\u8bad");
        message.setBussinesFromType(MessageBusinessFromEnum.onlineTraining.getValue());
        message.setBussinesFrom(organizationUser.getFullName() + "/" + organizationUser.getUsername());
        message.setSendTime(now);
        message.setProcessUrl(processUrl);
        message.setCreateUser(organizationUser.getUsername());
        message.setCreateBy(organizationUser.getId());
        message.setCreateDate(now);
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
        if (company == null || company.getAreaDetailId() == null) {
            log.error("\u53d1\u9001\u9000\u56de\u62a5\u540d\u6d88\u606f\u5931\u8d25\u2014\u2014\u2014\u2014>\u4fdd\u5b58\u5230message\u8868\u5931\u8d25\uff0c\u57f9\u8badid\uff1a{}\uff0c\u76f8\u5173\u4f01\u4e1aid\uff1a{}", (Object)businessId, (Object)cid);
            return Boolean.FALSE;
        }
        message.setAreaId(company.getAreaDetailId());
        Message addResult = this.messageService.addMessage(message);
        if (addResult == null) {
            log.error("\u53d1\u9001\u9000\u56de\u62a5\u540d\u6d88\u606f\u5931\u8d25\u2014\u2014\u2014\u2014>\u4fdd\u5b58\u5230message\u8868\u5931\u8d25\uff0c\u57f9\u8badid\uff1a{}\uff0c\u76f8\u5173\u4f01\u4e1aid\uff1a{}", (Object)businessId, (Object)cid);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Integer getTrainNumByByAreaAndYear(Long areaId, Byte areaLevel, Integer year, Byte ownLevel) {
        return this.dao.getTrainNumByByAreaAndYear(areaId, areaLevel, year, ownLevel);
    }

    public Integer getTrainNumByByAreaAndYear2(Long areaId, Byte areaLevel, Integer year, Byte ownLevel) {
        return this.dao.getTrainNumByByAreaAndYear2(areaId, areaLevel, year, ownLevel);
    }

    public DutyTrainPlanItem getDutyTrainInfo(Long areaId, Byte areaLevel, List<Long> keyIndustryIds, Integer scale) {
        List<TrainPlanPersonVo> dutyTrainInfo = this.dao.getDutyTrainInfo(areaId, areaLevel, keyIndustryIds, scale);
        DutyTrainPlanItem dutyTrainPlanItem = new DutyTrainPlanItem();
        if (CollectionUtils.isNotEmpty(dutyTrainInfo)) {
            Map<Long, List<TrainPlanPersonVo>> map = dutyTrainInfo.stream().collect(Collectors.groupingBy(k -> k.getCid()));
            for (Long s : map.keySet()) {
                List<TrainPlanPersonVo> dutyTrainPlanItems = map.get(s);
                TrainPlanPersonVo personVo = this.getTrainPlanPersonVo(dutyTrainPlanItems);
                this.statisticsNum(personVo, dutyTrainPlanItem);
            }
            dutyTrainPlanItem.setTotalComNum(Integer.valueOf(map.keySet().size()));
        }
        return dutyTrainPlanItem;
    }

    public DutyTrainPlanItem getDutyTrainInfoV322(Long areaId, Byte areaLevel, List<Long> keyIndustryIds, Integer scale) {
        DutyTrainPlanItem dutyTrainPlanItem = new DutyTrainPlanItem();
        List<TrainPlanInfoVo> trainPlanInfoVo = this.dao.getDutyTrainInfoV322(areaId, areaLevel, keyIndustryIds, scale);
        Map<Long, List<TrainPlanInfoVo>> map = trainPlanInfoVo.stream().collect(Collectors.groupingBy(TrainPlanInfoVo::getCid));
        HashMap<Long, Integer> keyPersonFinishNumMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> keyPersonIngNumMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> managePersonFinishNumMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> managePersonIngNumMap = new HashMap<Long, Integer>();
        for (Long s : map.keySet()) {
            List<TrainPlanInfoVo> vo = map.get(s);
            for (TrainPlanInfoVo planInfoVo : vo) {
                if (planInfoVo == null) continue;
                if (planInfoVo.getCertficateId() != null && planInfoVo.getValidityDate().getTime() >= new Date().getTime()) {
                    if (planInfoVo.getCertId() == 12L) {
                        keyPersonFinishNumMap.put(planInfoVo.getCid(), 1);
                    } else {
                        managePersonFinishNumMap.put(planInfoVo.getCid(), 1);
                    }
                }
                if (planInfoVo.getCertficateId() != null || planInfoVo.getTrainEndDate() == null || planInfoVo.getTrainEndDate().getTime() < new Date().getTime()) continue;
                if (keyPersonFinishNumMap.get(planInfoVo.getCid()) != null) {
                    keyPersonIngNumMap.remove(planInfoVo.getCid());
                } else {
                    keyPersonIngNumMap.put(planInfoVo.getCid(), 1);
                }
                if (managePersonFinishNumMap.get(planInfoVo.getCid()) != null) {
                    managePersonIngNumMap.remove(planInfoVo.getCid());
                    continue;
                }
                managePersonIngNumMap.put(planInfoVo.getCid(), 1);
            }
        }
        dutyTrainPlanItem.setTotalComNum(Integer.valueOf(keyPersonFinishNumMap.size() + keyPersonIngNumMap.size() + managePersonFinishNumMap.size() + managePersonIngNumMap.size()));
        dutyTrainPlanItem.setKeyPersonFinishNum(Integer.valueOf(keyPersonFinishNumMap.size()));
        dutyTrainPlanItem.setKeyPersonIngNum(Integer.valueOf(keyPersonIngNumMap.size()));
        dutyTrainPlanItem.setManagePersonFinishNum(Integer.valueOf(managePersonFinishNumMap.size()));
        dutyTrainPlanItem.setManagePersonIngNum(Integer.valueOf(managePersonIngNumMap.size()));
        return dutyTrainPlanItem;
    }

    private void statisticsNum(TrainPlanPersonVo personVo, DutyTrainPlanItem dutyTrainPlanItem) {
        if (Objects.nonNull(personVo.getKeyPersonStatus())) {
            switch (personVo.getKeyPersonStatus()) {
                case 0: {
                    dutyTrainPlanItem.setKeyPersonNoStartNum(Integer.valueOf(dutyTrainPlanItem.getKeyPersonNoStartNum() + 1));
                    break;
                }
                case 1: {
                    dutyTrainPlanItem.setKeyPersonIngNum(Integer.valueOf(dutyTrainPlanItem.getKeyPersonIngNum() + 1));
                    break;
                }
                case 2: {
                    dutyTrainPlanItem.setKeyPersonFinishNum(Integer.valueOf(dutyTrainPlanItem.getKeyPersonFinishNum() + 1));
                }
            }
        }
        if (Objects.nonNull(personVo.getManagePersonStatus())) {
            switch (personVo.getManagePersonStatus()) {
                case 0: {
                    dutyTrainPlanItem.setManagePersonNoStartNum(Integer.valueOf(dutyTrainPlanItem.getManagePersonNoStartNum() + 1));
                    break;
                }
                case 1: {
                    dutyTrainPlanItem.setManagePersonIngNum(Integer.valueOf(dutyTrainPlanItem.getManagePersonIngNum() + 1));
                    break;
                }
                case 2: {
                    dutyTrainPlanItem.setManagePersonFinishNum(Integer.valueOf(dutyTrainPlanItem.getManagePersonFinishNum() + 1));
                }
            }
        }
    }

    private TrainPlanPersonVo getTrainPlanPersonVo(List<TrainPlanPersonVo> dutyTrainPlanItems) {
        TrainPlanPersonVo personVo = new TrainPlanPersonVo();
        Integer keyPersonType = 0;
        Integer managePersonType = 0;
        for (TrainPlanPersonVo item : dutyTrainPlanItems) {
            if (Objects.nonNull(item.getKeyPersonStatus())) {
                if (item.getKeyPersonStatus() == null || item.getKeyPersonStatus() == 0) {
                    if (keyPersonType != 0) {
                        keyPersonType = 1;
                    }
                } else {
                    keyPersonType = item.getKeyPersonStatus() == 1 ? Integer.valueOf(1) : Integer.valueOf(2);
                }
            } else {
                keyPersonType = 0;
            }
            if (Objects.nonNull(item.getManagePersonStatus())) {
                if (item.getManagePersonStatus() == null || item.getManagePersonStatus() == 0) {
                    if (managePersonType == 0) continue;
                    managePersonType = 1;
                    continue;
                }
                if (item.getManagePersonStatus() == 1) {
                    managePersonType = 1;
                    continue;
                }
                managePersonType = 2;
                continue;
            }
            managePersonType = 0;
        }
        personVo.setKeyPersonStatus(keyPersonType);
        personVo.setManagePersonStatus(managePersonType);
        personVo.setCid(dutyTrainPlanItems.get(0).getCid());
        return personVo;
    }

    public DutyTrainPlanItem getDutyTrainInfoByScale(Long areaId, Byte areaLevel, Integer scale) {
        return this.dao.getDutyTrainInfoByScale(areaId, areaLevel, scale);
    }
}

