/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.Digests;
import cn.smarthse.common.util.Encodes;
import cn.smarthse.framework.encrypt.MD5;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanyCidUserIdModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.sys.SecUserRole;
import cn.smarthse.modules.health.entity.sys.SysUser;
import cn.smarthse.modules.health.enums.staff.StaffAddFromEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.ISecUserRoleService;
import cn.smarthse.modules.health.service.sys.ISysUserService;
import cn.smarthse.modules.health.supervise.dao.sys.SysUserMapper;
import cn.smarthse.modules.health.supervise.model.CreateUserModel;
import cn.smarthse.modules.health.supervise.model.CreateUserResult;
import cn.smarthse.modules.health.supervise.service.sys.ISysUserThirdService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
public class SysUserThirdServiceImpl
implements ISysUserThirdService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysUserThirdServiceImpl.class);
    @DubboReference
    private IStaffInfoService staffInfoService;
    @Autowired
    private SysUserMapper mapper;
    @DubboReference
    private ISecUserRoleService secUserRoleService;
    @DubboReference
    private ISysUserService sysUserService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;
    @Autowired
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public CreateUserResult create(List<CreateUserModel> list) {
        CreateUserResult result = new CreateUserResult();
        if (CollUtil.isEmpty(list)) {
            result.setResultCode(Integer.valueOf(0));
            log.error("[\u521b\u5efa\u7528\u6237]\u4e3a\u7a7a");
            return result;
        }
        result = this.validateUsers(list);
        if (Objects.equals(result.getResultCode(), 0)) {
            log.error("[\u521b\u5efa\u7528\u6237]\u6821\u9a8c\u5931\u8d25\uff0c{}", (Object)result.getErrorMsg());
            return result;
        }
        RLock lock = this.redissonClient.getLock(String.format("SysUserThirdServiceImpl:create:%s", list.hashCode()));
        if (lock.tryLock()) {
            try {
                result.setCount(Integer.valueOf(this.insert(result.getCreateUserModelList())));
                this.sysUserService.clearDataScope();
            }
            catch (Exception e) {
                log.error("[\u521b\u5efa\u7528\u6237]\u51fa\u9519 ", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        return result;
    }

    public Integer disableOrEnableUserByCid(Long cid, Integer flag, Long loginUserId) {
        return this.sysUserService.disableOrEnableUserByCid(cid, flag, loginUserId);
    }

    public Integer disableOrEnableUserByCids(String cids, Integer flag, Long loginUserId) {
        return this.sysUserService.disableOrEnableUserByCids(cids, flag, loginUserId);
    }

    public Integer disableOrEnableUserByCidList(List<Long> cidList, Integer flag, Long loginUserId) {
        return this.sysUserService.disableOrEnableUserByCidList(cidList, flag, loginUserId);
    }

    public Integer deleteOrRecoverUserByCid(Long cid, Integer flag) {
        return this.sysUserService.deleteOrRecoverUserByCid(cid, flag);
    }

    public Integer deleteUserByCid(List<Long> cidList, Long loginUserId) {
        return this.sysUserService.deleteUserByCid(cidList, loginUserId);
    }

    public Integer resetPasswordByUserId(Long userId, String plainPassword, Long loginUserId) {
        return this.sysUserService.resetPasswordByUserId(userId, plainPassword, loginUserId);
    }

    public Integer resetPasswordByUserId(List<Long> userIds, String plainPassword) {
        return this.sysUserService.resetPasswordByUserId(userIds, plainPassword);
    }

    public SysUser getUserInfoById(Long userId) {
        return (SysUser)this.mapper.selectByPrimaryKey(userId);
    }

    public List<SysUser> getUserInfoByCidList(List<Long> cidList) {
        return this.sysUserService.getUserInfoByCidList(cidList);
    }

    private int insert(List<CreateUserModel> list) {
        int count = 0;
        Date date = new Date();
        ArrayList<CompanyCidUserIdModel> updateUserIdList = new ArrayList<CompanyCidUserIdModel>(list.size());
        for (CreateUserModel model : list) {
            StaffInfo staffForm = new StaffInfo();
            staffForm.setCid(model.getCid());
            staffForm.setIsThirdParty(Global.FALSE);
            staffForm.setIsValid(Global.TRUE);
            staffForm.setCreateDate(date);
            staffForm.setUpdateDate(date);
            staffForm.setCreateBy(model.getCreateBy());
            staffForm.setUpdateBy(model.getCreateBy());
            staffForm.setAddFrom(Integer.valueOf(StaffAddFromEnum.supervise_manager_or_single_add2.getValue().byteValue()));
            StaffBasicInfo bas = new StaffBasicInfo();
            bas.setCid(model.getCid());
            bas.setRealName(model.getUsername());
            bas.setCid(model.getCid());
            bas.setIsValid(Global.TRUE);
            bas.setCreateDate(date);
            bas.setUpdateDate(date);
            bas.setCreateBy(model.getCreateBy());
            bas.setUpdateBy(model.getCreateBy());
            staffForm.setStaffBasicInfo(bas);
            staffForm = this.staffInfoService.addStaffInfoSubmit(staffForm);
            SysUser user = new SysUser();
            user.setStaffId(staffForm.getId());
            user.setCid(model.getCid());
            user.setUsername(model.getUsername());
            user.setFullname(model.getUsername());
            user.setIsManger(Boolean.valueOf(true));
            user.setIsForbidden(Global.FALSE);
            user.setForbiddenUpdateTime(date);
            user.setUsername(model.getUsername());
            user.setCreateBy(model.getCreateBy());
            user.setCreateDate(date);
            user.setUpdateDate(date);
            user.setUpdateBy(model.getCreateBy());
            user.setIsDefaultPwd(Boolean.valueOf(true));
            this.entryptPassword(user, MD5.MD5Encode((String)model.getPassword()));
            if (user.getCid() == null) {
                log.error("\u521b\u5efa\u7528\u4eba\u5355\u4f4d\u8d26\u53f7\u51fa\u4e86\u95ee\u9898:cid \u4e0d\u5b58\u5728,{}", (Throwable)new RuntimeException("\u521b\u5efa\u7528\u4eba\u5355\u4f4d\u8d26\u53f7\u51fa\u4e86\u95ee\u9898:cid \u4e0d\u5b58\u5728"));
            }
            user = (SysUser)this.sysUserService.add((Object)user);
            CompanyCidUserIdModel companySuperviseModel = new CompanyCidUserIdModel();
            companySuperviseModel.setCid(user.getCid());
            companySuperviseModel.setUserId(user.getId());
            updateUserIdList.add(companySuperviseModel);
            model.setUserId(user.getId());
            SecUserRole userRole = new SecUserRole();
            userRole.setIsValid(Global.TRUE);
            userRole.setSecRoleId(Long.valueOf(1L));
            userRole.setSysUserId(user.getId());
            userRole.setCreateBy(model.getCreateBy());
            userRole.setCreateDate(date);
            userRole.setUpdateDate(date);
            userRole.setUpdateBy(model.getCreateBy());
            userRole.setCid(model.getCid());
            this.secUserRoleService.add((Object)userRole, null, model.getCid());
            this.secUserRoleService.addSysUserRoleV3(user.getId(), Long.valueOf(3001L));
            ++count;
        }
        try {
            if (CollUtil.isNotEmpty(updateUserIdList)) {
                this.mapper.updateCompanyUserIdList(updateUserIdList);
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7528\u6237\u540e\u8bbe\u7f6e\u4e3b\u8868userId\u51fa\u9519\u4e86", (Throwable)e);
        }
        return count;
    }

    private CreateUserResult validateUsers(List<CreateUserModel> list) {
        CreateUserResult result = new CreateUserResult();
        result.setResultCode(Integer.valueOf(1));
        StringBuilder sb = new StringBuilder();
        String uname = null;
        Long hasManagerCid = null;
        if (CollUtil.isNotEmpty(list) && list.size() == 1) {
            uname = list.get(0).getUsername();
            hasManagerCid = list.get(0).getCid();
        }
        SysUser param = new SysUser();
        param.setUsername(uname);
        List<SysUser> userList = this.mapper.getAllUsername(param);
        Set set = userList.stream().map(SysUser::getUsername).collect(Collectors.toSet());
        List<Long> hasManagerCidList = this.mapper.listCidByAllManager(hasManagerCid);
        ArrayList<CreateUserModel> createUserModelList = new ArrayList<CreateUserModel>(list.size());
        for (CreateUserModel createUserModel : list) {
            if (StrUtil.isBlank((CharSequence)createUserModel.getUsername()) || StrUtil.isBlank((CharSequence)createUserModel.getPassword())) {
                result.setResultCode(Integer.valueOf(0));
                sb.append("\u7528\u6237\u540d\uff0c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                result.setErrorMsg(sb.toString());
                return result;
            }
            if (set.contains(createUserModel.getUsername()) || hasManagerCidList.contains(createUserModel.getCid())) continue;
            createUserModelList.add(createUserModel);
        }
        if (result.getResultCode().equals(0)) {
            result.setErrorMsg(sb.toString());
        }
        result.setCreateUserModelList(createUserModelList);
        return result;
    }

    public SysUser entryptPassword(SysUser user, String plainPassword) {
        String plain = Encodes.unescapeHtml((String)plainPassword);
        byte[] salt = Digests.generateSalt((int)8);
        user.setSalt(Encodes.hexEncode((byte[])salt));
        byte[] hashPassword = Digests.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        user.setPassword(Encodes.hexEncode((byte[])hashPassword));
        return user;
    }

    @Transactional
    public int updateUserInfo(SysUser sysUser, Long loginStaffId) {
        if (sysUser.getId() != null) {
            SysUser sysUser1 = (SysUser)this.mapper.selectByPrimaryKey(sysUser.getId());
            if (sysUser1.getIsForbidden() != null && !sysUser1.getIsForbidden().equals(sysUser.getIsForbidden())) {
                sysUser.setForbiddenUpdateTime(new Date());
            }
            if (!StringUtils.equals((CharSequence)sysUser1.getUsername(), (CharSequence)sysUser.getUsername())) {
                String hasUserName = this.checkUserNameInfo(sysUser.getId(), sysUser.getUsername());
                if (StringUtils.isBlank((CharSequence)hasUserName)) {
                    sysUser.setUpdateDate(new Date());
                    sysUser.setUpdateBy(loginStaffId);
                    this.mapper.updateByPrimaryKeySelective(sysUser);
                }
            } else {
                sysUser.setUpdateDate(new Date());
                sysUser.setUpdateBy(loginStaffId);
                this.mapper.updateByPrimaryKeySelective(sysUser);
            }
        }
        return 0;
    }

    public String checkUserNameInfo(Long userId, String userName) {
        if (userId == null || StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        Example e = new Example(SysUser.class);
        e.createCriteria().andEqualTo("username", (Object)userName).andEqualTo("isValid", (Object)true);
        List sysUsers = this.mapper.selectByExample(e);
        if (CollectionUtils.isNotEmpty((Collection)sysUsers)) {
            for (SysUser sysUser : sysUsers) {
                if (sysUser.getId().equals(userId)) continue;
                return "\u5b58\u5728\u76f8\u540c\u7528\u6237\u540d";
            }
        }
        return null;
    }

    public Boolean isHaveThisName(String name, Long excludeId) {
        return this.sysUserService.isHaveThisName(name, excludeId);
    }

    public Boolean isHaveThisName(List<String> nameList) {
        return this.sysUserService.isHaveThisName(nameList);
    }

    @Transactional
    public void rollbackImportUserData(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.sysUserService.rollbackImportUserData(idList);
    }

    @Transactional
    public Boolean createSysUser(List<Long> idList, Long loginUserId) {
        if (Objects.isNull(loginUserId)) {
            throw new HealthException("\u7528\u6237\u4fe1\u606f\u6216\u767b\u5f55\u7528\u6237\u4e22\u5931");
        }
        if (CollUtil.isEmpty(idList)) {
            throw new HealthException("\u8bf7\u9009\u62e9\u8981\u521b\u5efa\u8d26\u53f7\u7684\u4f01\u4e1a");
        }
        List companyList = this.companyProvideBySuperviseService.getOnlyCompanyByCid(idList);
        if (CollUtil.isEmpty((Collection)companyList)) {
            throw new HealthException("\u8981\u521b\u5efa\u8d26\u53f7\u7684\u4f01\u4e1a\u5df2\u4e0d\u5b58\u5728");
        }
        List<String> nameList = companyList.stream().map(CompanyBaseInfoModel::getName).collect(Collectors.toList());
        if (this.isHaveThisName(nameList).booleanValue()) {
            throw new HealthException("\u8981\u521b\u5efa\u8d26\u53f7\u7684\u4f01\u4e1a\u9ed8\u8ba4\u540d\u79f0\u5df2\u5b58\u5728");
        }
        List<SysUser> sysUserList = this.getUserInfoByCidList(idList);
        if (CollUtil.isNotEmpty(sysUserList)) {
            Set cidList = sysUserList.stream().filter(i -> i.getIsManger()).map(SysUser::getCid).collect(Collectors.toSet());
            idList.removeIf(i -> cidList.stream().anyMatch(j -> j.equals(i)));
            if (CollUtil.isEmpty(idList)) {
                throw new HealthException("\u8bf7\u9009\u62e9\u8981\u521b\u5efa\u8d26\u53f7\u7684\u4f01\u4e1a");
            }
        }
        ArrayList<CreateUserModel> list = new ArrayList<CreateUserModel>(companyList.size());
        companyList.forEach(c -> {
            CreateUserModel createUserModel = new CreateUserModel();
            createUserModel.setCid(c.getId());
            createUserModel.setUsername(c.getName());
            createUserModel.setPassword("Zyj@2022");
            createUserModel.setCreateBy(loginUserId);
            list.add(createUserModel);
        });
        this.create(list);
        return Boolean.TRUE;
    }

    public List<SysUser> listUserNameByStaffIds(List<Long> staffIds) {
        return this.mapper.listUserNameByStaffIds(staffIds);
    }

    public List<SysUser> getUserManager(Long cid) {
        List userManager = this.sysUserService.getUserManager(cid);
        return userManager;
    }
}

