/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.entity.sys.SysLoginStatV2;
import cn.smarthse.modules.health.supervise.dao.sys.SysLoginStatV2Mapper;
import cn.smarthse.modules.health.supervise.service.sys.ISysLoginStatV2Service;
import cn.smarthse.modules.health.vo.sys.loginstat.SysLoginStatParamV2;
import cn.smarthse.modules.health.vo.sys.loginstat.SysLoginStatVoV2;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class SysLoginStatV2ServiceImpl
extends BaseServiceImpl<SysLoginStatV2Mapper, SysLoginStatV2>
implements ISysLoginStatV2Service {
    @Autowired
    private IdWorker idWorker;

    public Date getMaxLastLoginDate() {
        return ((SysLoginStatV2Mapper)this.dao).getMaxLastLoginDate();
    }

    public List<SysLoginStatV2> getAllCid() {
        return ((SysLoginStatV2Mapper)this.dao).getAllCid();
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void saveOrUpdates(List<SysLoginStatV2> sysLoginStats) {
        if (CollectionUtils.isEmpty(sysLoginStats)) {
            return;
        }
        for (SysLoginStatV2 sysLoginStat : sysLoginStats) {
            sysLoginStat.setId(Long.valueOf(this.idWorker.nextId()));
        }
        ListUtil.partition(sysLoginStats, (int)1000).forEach(list -> ((SysLoginStatV2Mapper)this.dao).saveOrUpdates((List<SysLoginStatV2>)list));
    }

    public List<SysLoginStatVoV2> listCollectLoginStatV2(SysLoginStatParamV2 paramV2) {
        List<SysLoginStatVoV2> sysLoginStatVoV2s = ((SysLoginStatV2Mapper)this.dao).collectLoginStatV2(paramV2);
        return sysLoginStatVoV2s;
    }

    public PageInfo<SysLoginStatVoV2> pageCollectLoginStatV2(JqGridParam jparam, SysLoginStatParamV2 paramV2) {
        PageHelper.startPage((int)jparam.getPage(), (int)jparam.getRows());
        List<SysLoginStatVoV2> sysLoginStatVoV2s = this.listCollectLoginStatV2(paramV2);
        return new PageInfo(sysLoginStatVoV2s);
    }
}

