/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.sys;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.entity.sys.SysArea;
import cn.smarthse.modules.health.supervise.dao.sys.SysAreaMapper;
import cn.smarthse.modules.health.supervise.service.sys.ISysAreaService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@DubboService
@Transactional(readOnly=true)
public class SysAreaServiceImpl
extends BaseServiceImpl<SysAreaMapper, SysArea>
implements ISysAreaService {
    @Autowired
    SysAreaMapper sysAreaMapper;

    public List<SysArea> listProvince() {
        SysArea criObj = new SysArea();
        criObj.setLevel(Byte.valueOf((byte)1));
        criObj.setParentId(Long.valueOf(0L));
        return this.commonQuerySysArea(criObj);
    }

    public List<SysArea> listCity(Long provinceId) throws Exception {
        if (provinceId == null) {
            throw new Exception("\u8bf7\u4f20\u5165\u7701\u4efd\u7684\u7f16\u53f7");
        }
        SysArea criObj = new SysArea();
        criObj.setLevel(Byte.valueOf((byte)2));
        criObj.setParentId(provinceId);
        return this.commonQuerySysArea(criObj);
    }

    public List<SysArea> listArea(Long cityId) throws Exception {
        if (cityId == null) {
            throw new Exception("\u8bf7\u4f20\u5165\u5e02\u7684\u7f16\u53f7");
        }
        SysArea criObj = new SysArea();
        criObj.setLevel(Byte.valueOf((byte)3));
        criObj.setParentId(cityId);
        return this.commonQuerySysArea(criObj);
    }

    public List<SysArea> listStreet(Long areaId) throws Exception {
        if (areaId == null) {
            throw new Exception("\u8bf7\u4f20\u5165\u533a\u57df\u7684\u7f16\u53f7");
        }
        SysArea criObj = new SysArea();
        criObj.setLevel(Byte.valueOf((byte)4));
        criObj.setParentId(areaId);
        return this.commonQuerySysArea(criObj);
    }

    public List<SysArea> commonQuerySysArea(SysArea queryObj) {
        Example example = new Example(SysArea.class);
        Example.Criteria cri = example.createCriteria();
        queryObj.setIsValid(Boolean.valueOf(true));
        cri.andEqualTo((Object)queryObj);
        example.orderBy("orderBy");
        return this.sysAreaMapper.selectByExample(example);
    }

    public String getFullName(Long areaId, String separation) {
        if (areaId == null) {
            return "";
        }
        SysArea area = (SysArea)this.getById(areaId);
        if (area != null) {
            StringBuffer areaName = new StringBuffer();
            areaName.append(area.getProvinceName());
            if (StringUtils.isNotBlank((CharSequence)area.getCityName())) {
                areaName.append(separation + area.getCityName());
            }
            if (StringUtils.isNotBlank((CharSequence)area.getAreaName())) {
                areaName.append(separation + area.getAreaName());
            }
            if (StringUtils.isNotBlank((CharSequence)area.getStreetName())) {
                areaName.append(separation + area.getStreetName());
            }
            return areaName.toString();
        }
        return "";
    }

    public SysArea getAreaByName(Long parentId, String name) {
        if (name == null) {
            return null;
        }
        SysArea criObj = new SysArea();
        criObj.setParentId(parentId);
        if (parentId != null && parentId.equals(0L)) {
            if (name.equals("\u65b0\u7586")) {
                name = "\u65b0\u7586\u7ef4\u543e\u5c14";
            }
            criObj.setShortName(name);
        } else {
            criObj.setName(name);
        }
        List<SysArea> list = this.commonQuerySysArea(criObj);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}

