/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.supervisionlaw;

import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.supervise.dao.supervisionlaw.OffSiteLawTableMapper;
import cn.smarthse.modules.health.supervise.entity.statistics.OffSiteLawTable;
import cn.smarthse.modules.health.supervise.model.supervisionlaw.OffSiteLawModel;
import cn.smarthse.modules.health.supervise.service.supervisionlaw.IOffSiteLawTableService;
import cn.smarthse.snowflake.IdWorker;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
@Transactional(readOnly=true)
public class OffSiteLawTableServiceImpl
extends BaseServiceImpl<OffSiteLawTableMapper, OffSiteLawTable>
implements IOffSiteLawTableService {
    @Autowired
    protected IdWorker idworker;

    @Transactional(readOnly=false)
    public void statisticsTable() {
        ((OffSiteLawTableMapper)this.dao).deleteAll();
        List<OffSiteLawTable> provinceList = this.provinceList();
        List<OffSiteLawTable> cityList = this.cityList();
        List<OffSiteLawTable> areaList = this.areaList();
        List<OffSiteLawTable> streetList = this.streetList();
        List<OffSiteLawTable> currentList = this.currentList();
        List list = Stream.of(provinceList, cityList, areaList, streetList, currentList).flatMap(Collection::stream).collect(Collectors.toList());
        this.batchUpdateOrInsert(list, OffSiteLawTableMapper.class, (item, mapper) -> {
            item.setId(Long.valueOf(this.idworker.nextId()));
            item.setCreateDate(new Date());
            item.setUpdateDate(new Date());
            item.setCreateBy(Long.valueOf(0L));
            item.setUpdateBy(Long.valueOf(0L));
            item.setIsValid(Boolean.valueOf(true));
            return mapper.insert(item);
        });
    }

    public OffSiteLawModel getByAreaId(SearchParam searchParam) {
        return ((OffSiteLawTableMapper)this.dao).getByAreaId(searchParam);
    }

    public List<OffSiteLawModel> getListByParentId(SearchParam searchParam) {
        return ((OffSiteLawTableMapper)this.dao).getListByParentId(searchParam);
    }

    public PageInfo<OffSiteLawModel> getListPageByParentId(SearchParam searchParam) {
        PageHelper.startPage((int)searchParam.getPageNum(), (int)searchParam.getPageSize());
        return new PageInfo(this.getListByParentId(searchParam));
    }

    private List<OffSiteLawTable> provinceList() {
        OffSiteLawTable offSiteLawTable2023 = ((OffSiteLawTableMapper)this.dao).getProvenceList(2023);
        OffSiteLawTable offSiteLawTable2024 = ((OffSiteLawTableMapper)this.dao).getProvenceList(2024);
        return new ArrayList<OffSiteLawTable>(Arrays.asList(offSiteLawTable2023, offSiteLawTable2024));
    }

    private List<OffSiteLawTable> cityList() {
        List<OffSiteLawTable> offSiteLawTable2023 = ((OffSiteLawTableMapper)this.dao).getCityList(2023, false);
        List<OffSiteLawTable> offSiteLawTable2024 = ((OffSiteLawTableMapper)this.dao).getCityList(2024, false);
        offSiteLawTable2023.addAll(offSiteLawTable2024);
        return offSiteLawTable2023;
    }

    private List<OffSiteLawTable> areaList() {
        List<OffSiteLawTable> offSiteLawTable2023 = ((OffSiteLawTableMapper)this.dao).getAreaList(2023, false);
        List<OffSiteLawTable> offSiteLawTable2024 = ((OffSiteLawTableMapper)this.dao).getAreaList(2024, false);
        offSiteLawTable2023.addAll(offSiteLawTable2024);
        return offSiteLawTable2023;
    }

    private List<OffSiteLawTable> streetList() {
        List<OffSiteLawTable> offSiteLawTable2023 = ((OffSiteLawTableMapper)this.dao).getStreetList(2023, false);
        List<OffSiteLawTable> offSiteLawTable2024 = ((OffSiteLawTableMapper)this.dao).getStreetList(2024, false);
        offSiteLawTable2023.addAll(offSiteLawTable2024);
        return offSiteLawTable2023;
    }

    private List<OffSiteLawTable> currentList() {
        List<OffSiteLawTable> area2023 = ((OffSiteLawTableMapper)this.dao).getAreaList(2023, true);
        List<OffSiteLawTable> area2024 = ((OffSiteLawTableMapper)this.dao).getAreaList(2024, true);
        List<OffSiteLawTable> street2023 = ((OffSiteLawTableMapper)this.dao).getStreetList(2023, true);
        List<OffSiteLawTable> street2024 = ((OffSiteLawTableMapper)this.dao).getStreetList(2024, true);
        return Stream.of(area2023, area2024, street2023, street2024).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

