/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.statistics.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.dao.statistics.ZybPushRecordMapper;
import cn.smarthse.modules.health.supervise.model.statistics.WaitInCompanyModel;
import cn.smarthse.modules.health.supervise.model.statistics.ZybPushRecordModel;
import cn.smarthse.modules.health.supervise.model.statistics.ZybPushRecordParam;
import cn.smarthse.modules.health.supervise.service.statistics.IZybPushRecordService;
import cn.smarthse.modules.platform.model.AreaModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@DubboService
public class ZybPushRecordServiceImpl
implements IZybPushRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZybPushRecordServiceImpl.class);
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService areaProvideService;
    @Autowired
    private ZybPushRecordMapper zybPushRecordMapper;

    private void setingParamValue(ZybPushRecordParam param) {
        Long areaId;
        AreaModel areaById;
        if (param.getAreaId() != null && param.getAreaLevel() == null && (areaById = this.areaProvideService.getAreaById(areaId = param.getAreaId())) != null) {
            param.setAreaLevel(areaById.getLevel());
        }
    }

    public List<ZybPushRecordModel> listZybpushRecord(ZybPushRecordParam param) {
        this.setingParamValue(param);
        this.setingParamValue(param);
        List<ZybPushRecordModel> zybPushRecordModels = this.zybPushRecordMapper.selectPushRecord(param);
        return zybPushRecordModels;
    }

    public PageInfo<WaitInCompanyModel> pageWaitInCompanyModel(JqGridParam jParam, ZybPushRecordParam param) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<WaitInCompanyModel> zybPushRecordModels = this.zybPushRecordMapper.listWaitInCompanyModel(param);
        return new PageInfo(zybPushRecordModels);
    }

    public PageInfo<ZybPushRecordModel> pageZybpushRecord(JqGridParam jParam, ZybPushRecordParam param) {
        this.setingParamValue(param);
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<ZybPushRecordModel> zybPushRecordModels = this.zybPushRecordMapper.selectPushRecord(param);
        this.settingCompanyFlag(zybPushRecordModels);
        return new PageInfo(zybPushRecordModels);
    }

    public void settingCompanyFlag(List<ZybPushRecordModel> zybPushRecordModels) {
        if (CollectionUtils.isEmpty(zybPushRecordModels)) {
            return;
        }
        List modelList = zybPushRecordModels.stream().filter(f -> f.getZlwyCompany() == false).collect(Collectors.toList());
        for (ZybPushRecordModel zybPushRecordModel : modelList) {
            CompanyBaseInfoModel r;
            zybPushRecordModel.setHasCompanyFlag(Integer.valueOf(0));
            String companyName = zybPushRecordModel.getCompanyName();
            String creditCode = zybPushRecordModel.getCreditCode();
            CompanyBaseInfoModel param = new CompanyBaseInfoModel();
            param.setName(companyName);
            param.setUnifiedSocialCc(creditCode);
            List<CompanyBaseInfoModel> companyBaseInfoModels = this.zybPushRecordMapper.selectCompany(param);
            if (CollectionUtil.isEmpty(companyBaseInfoModels)) continue;
            if (companyBaseInfoModels.size() > 1) {
                zybPushRecordModel.setHasCompanyFlag(Integer.valueOf(3));
            }
            if ((r = companyBaseInfoModels.get(0)) == null) continue;
            if (Objects.equals(r.getIsRegulationVisible(), 1)) {
                zybPushRecordModel.setHasCompanyFlag(Integer.valueOf(2));
                continue;
            }
            zybPushRecordModel.setHasCompanyFlag(Integer.valueOf(1));
        }
    }

    public boolean linkRiskCompany(ZybPushRecordModel link) {
        if (link.getCid() == null || link.getRiskMainpartId() == null) {
            throw new ServiceException("\u5fc5\u586b\u9879\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            this.zybPushRecordMapper.linkRiskCompany(link);
            return true;
        }
        catch (Exception e) {
            log.error("\u5173\u8054\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public List<CompanyBaseInfoModel> selectCompanyBycode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.zybPushRecordMapper.selectCompanyBycode(code);
    }
}

