/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.supervise.service.statistics.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.service.BaseServiceImpl;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.modules.health.compliance.service.IComplianceCompanyInfoManagerService;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeWorkProgress;
import cn.smarthse.modules.health.entity.work.reform.param.RiskResolveResSearch;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.supervise.dao.statistics.YearEfficScoreTableMapper;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryScoreTable;
import cn.smarthse.modules.health.supervise.entity.statistics.DeclareAreaModel;
import cn.smarthse.modules.health.supervise.entity.statistics.YearEfficScoreTable;
import cn.smarthse.modules.health.supervise.enums.YearEfficScoreTaskCaseEnum;
import cn.smarthse.modules.health.supervise.model.compliance.ComplianceVisualModel;
import cn.smarthse.modules.health.supervise.model.compliance.ComplianceVisualParam;
import cn.smarthse.modules.health.supervise.model.statistics.YearEfficReportParam;
import cn.smarthse.modules.health.supervise.service.company.IDcCompanyService;
import cn.smarthse.modules.health.supervise.service.company.grade.ICompanyGradeV3Service;
import cn.smarthse.modules.health.supervise.service.statistics.IYearEfficScoreTableService;
import cn.smarthse.modules.health.supervise.vo.company.CompanyTrainVo;
import cn.smarthse.modules.health.supervise.vo.workPerfor.WorkProgressStatisticSearchVo;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.modules.sys.enumd.SystemDeploymentSourceEnum;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.township.manage.model.param.AdminPatrolStatisticsAnnualIndicatorsParam;
import cn.smarthse.township.manage.model.vo.admin.AdminPatrolStatisticsAnnualIndicatorsVo;
import cn.smarthse.township.manage.provider.admin.IPatrolStatisticsServiceProvider;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class YearEfficScoreTableServiceImpl
extends BaseServiceImpl<YearEfficScoreTableMapper, YearEfficScoreTable>
implements IYearEfficScoreTableService {
    @DubboReference
    private IWandaDeclareService wandaDeclareService;
    @Autowired
    private ICompanyGradeV3Service companyGradeV3Service;
    @Autowired
    private IComplianceCompanyInfoManagerService companyInfoManagerService;
    @DubboReference
    private IPatrolStatisticsServiceProvider patrolStatisticsServiceProvider;
    @Autowired
    private IDcCompanyService companyService;

    public PageInfo<YearEfficScoreTable> pageYearEfficScoreTable(JqGridParam jParam, YearEfficReportParam param) {
        PageHelper.startPage((int)jParam.getPage(), (int)jParam.getRows());
        List<YearEfficScoreTable> list = this.listEfficScoreTable(param);
        return new PageInfo(list);
    }

    public List<YearEfficScoreTable> listEfficScoreTable(YearEfficReportParam param) {
        List<YearEfficScoreTable> list = ((YearEfficScoreTableMapper)this.dao).listEfficScoreTable(param);
        if (CollUtil.isNotEmpty(list)) {
            list.forEach(y -> {
                if (y.getGradeFinishRate() == null) {
                    y.setGradeFinishRate(Double.valueOf(0.0));
                }
                if (y.getGradeFinishScore() == null) {
                    y.setGradeFinishScore(Double.valueOf(0.0));
                }
                if (y.getTrainRate() == null) {
                    y.setTrainRate(Double.valueOf(0.0));
                }
                if (y.getTrainScore() == null) {
                    y.setTrainScore(Double.valueOf(0.0));
                }
                if (y.getDeclareNum() == null) {
                    y.setDeclareNum(Integer.valueOf(0));
                }
                if (y.getDeclareScore() == null) {
                    y.setDeclareScore(Double.valueOf(0.0));
                }
                if (y.getKeyIndustryTrainCase() == null) {
                    y.setKeyIndustryTrainCase(Boolean.valueOf(false));
                }
                if (y.getKeyIndustryTrainScore() == null) {
                    y.setKeyIndustryTrainScore(Double.valueOf(0.0));
                }
                if (y.getXzxgRate() == null) {
                    y.setXzxgRate(Double.valueOf(0.0));
                }
                if (y.getXzxgScore() == null) {
                    y.setXzxgScore(Double.valueOf(0.0));
                }
                if (y.getOnlineInquiryRate() == null) {
                    y.setOnlineInquiryRate(Double.valueOf(0.0));
                }
                if (y.getOnlineInquiryScore() == null) {
                    y.setOnlineInquiryScore(Double.valueOf(0.0));
                }
                if (y.getAreaComplianceQualifiedRate() == null) {
                    y.setAreaComplianceQualifiedRate(Double.valueOf(0.0));
                }
                if (y.getAreaComplianceQualifiedRateScore() == null) {
                    y.setAreaComplianceQualifiedRateScore(Double.valueOf(0.0));
                }
                if (y.getComplianceQualifiedRate() == null) {
                    y.setComplianceQualifiedRate(Double.valueOf(0.0));
                }
                if (y.getComplianceQualifiedScore() == null) {
                    y.setComplianceQualifiedScore(Double.valueOf(0.0));
                }
                if (y.getComplianceQualifiedNum() == null) {
                    y.setComplianceQualifiedNum(Integer.valueOf(0));
                }
                if (y.getComplianceQualifiedNumScore() == null) {
                    y.setComplianceQualifiedNumScore(Double.valueOf(0.0));
                }
                if (y.getDefuseRate() == null) {
                    y.setDefuseRate(Double.valueOf(0.0));
                }
                if (y.getDefuseScore() == null) {
                    y.setDefuseScore(Double.valueOf(0.0));
                }
                if (y.getDetectionRate() == null) {
                    y.setDetectionRate(Double.valueOf(0.0));
                }
                if (y.getDetectionScore() == null) {
                    y.setDetectionScore(Double.valueOf(0.0));
                }
                if (y.getPhysicalCheckRate() == null) {
                    y.setPhysicalCheckRate(Double.valueOf(0.0));
                }
                if (y.getPhysicalCheckScore() == null) {
                    y.setPhysicalCheckScore(Double.valueOf(0.0));
                }
                if (y.getOnlineDeviceCount() == null) {
                    y.setOnlineDeviceCount(Integer.valueOf(0));
                }
                if (y.getOnlineDeviceCountScore() == null) {
                    y.setOnlineDeviceCountScore(Double.valueOf(0.0));
                }
            });
        }
        return list;
    }

    @Transactional(readOnly=true)
    public void updateEfficScore(YearEfficScoreTaskCaseEnum ... caseTask) {
        List<AreaModel> areaModels = ((YearEfficScoreTableMapper)this.dao).selectCityArea();
        Map<Long, YearEfficScoreTable> dbYearEfficTableMap = areaModels.stream().map(m -> {
            YearEfficScoreTable table = new YearEfficScoreTable();
            table.setAreaId(m.getAreaId());
            table.setLevel(m.getLevel());
            table.setId(m.getId());
            return table;
        }).collect(Collectors.toMap(YearEfficScoreTable::getAreaId, Function.identity(), (v1, v2) -> v1));
        if (caseTask == null || Arrays.stream(caseTask).anyMatch(t -> t == YearEfficScoreTaskCaseEnum.Grade)) {
            this.processGradeData(dbYearEfficTableMap);
        }
        if (caseTask == null || Arrays.stream(caseTask).anyMatch(t -> t == YearEfficScoreTaskCaseEnum.Train)) {
            this.processTrainRiskData(dbYearEfficTableMap);
        }
        if (caseTask == null || Arrays.stream(caseTask).anyMatch(t -> t == YearEfficScoreTaskCaseEnum.Declare)) {
            this.processDeclareData(dbYearEfficTableMap);
        }
        if (caseTask == null || Arrays.stream(caseTask).anyMatch(t -> t == YearEfficScoreTaskCaseEnum.KeyInduTrain)) {
            this.processKeyInduTrainData(dbYearEfficTableMap);
        }
        if (caseTask == null || Arrays.stream(caseTask).anyMatch(t -> t == YearEfficScoreTaskCaseEnum.Patrol)) {
            this.processPatrolData(dbYearEfficTableMap);
        }
        if (caseTask == null || Arrays.stream(caseTask).anyMatch(t -> t == YearEfficScoreTaskCaseEnum.Specialist)) {
            this.processSpecialistAnswerData(dbYearEfficTableMap);
        }
        if (caseTask == null || Arrays.stream(caseTask).anyMatch(t -> t == YearEfficScoreTaskCaseEnum.Compliance)) {
            try {
                this.processComplianceData(dbYearEfficTableMap);
            }
            catch (Exception e) {
                this.logger.error("\u5408\u89c4\u4f01\u4e1a\u8ba1\u7b97\u51fa\u9519..", (Throwable)e);
            }
        }
        if (caseTask == null || Arrays.stream(caseTask).anyMatch(t -> t == YearEfficScoreTaskCaseEnum.Risk)) {
            // empty if block
        }
        if (caseTask == null || Arrays.stream(caseTask).anyMatch(t -> t == YearEfficScoreTaskCaseEnum.OnlineDevice)) {
            this.processOnlineDeviceData(dbYearEfficTableMap);
        }
        List scoreTableList = dbYearEfficTableMap.values().stream().collect(Collectors.toList());
        ((IYearEfficScoreTableService)SpringContextHolder.getBean(IYearEfficScoreTableService.class)).saveEfficScoreTable(scoreTableList);
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public void saveEfficScoreTable(List<YearEfficScoreTable> scoreTableList) {
        this.batchUpdateOrInsert(scoreTableList, YearEfficScoreTableMapper.class, (item, mapper) -> {
            if (item.getId() == null) {
                item.setId(Long.valueOf(this.idworker.nextId()));
                item.setIsValid(Boolean.valueOf(true));
                item.setCreateDate(new Date());
                mapper.insert(item);
            } else {
                item.setUpdateDate(new Date());
                mapper.updateByPrimaryKeySelective(item);
            }
            return 1;
        });
    }

    public void processDeclareData(Map<Long, YearEfficScoreTable> dbYearEfficTableMap) {
        SearchParam searchParam = new SearchParam();
        searchParam.setAreaId(Long.valueOf(330000000000L));
        searchParam.setLevel(Byte.valueOf((byte)1));
        searchParam.setStorageList(Arrays.asList((byte)2, (byte)3, (byte)4, (byte)5));
        List declareAreaModels = this.wandaDeclareService.statisticsDeclareAreaListData(searchParam);
        if (CollUtil.isNotEmpty((Collection)declareAreaModels)) {
            for (DeclareAreaModel declareAreaModel : declareAreaModels) {
                Long areaId = declareAreaModel.getAreaId();
                Integer declareScore = declareAreaModel.getYearEfficDeclareScore();
                Integer more3NUm = declareAreaModel.getMore3NUm();
                if (!dbYearEfficTableMap.containsKey(areaId)) continue;
                YearEfficScoreTable table = dbYearEfficTableMap.get(areaId);
                table.setDeclareNum(Integer.valueOf(more3NUm == null ? 0 : more3NUm));
                table.setDeclareScore(Double.valueOf(declareScore != null ? declareScore.doubleValue() : 0.0));
            }
        }
    }

    public void processGradeData(Map<Long, YearEfficScoreTable> dbYearEfficTableMap) {
        WorkProgressStatisticSearchVo searchVo = new WorkProgressStatisticSearchVo();
        searchVo.setOrgAreaId(Long.valueOf(330000000000L));
        searchVo.setOrgAreaLevel(Byte.valueOf((byte)1));
        searchVo.setDataRange(Byte.valueOf((byte)1));
        searchVo.setOnlyLaborDispatch(Integer.valueOf(0));
        searchVo.setCityShow(Boolean.valueOf(true));
        searchVo.setGradeSource("2,5,6,7");
        searchVo.setPickupCount3("1,2");
        searchVo.setParentId(Long.valueOf(330000000000L));
        searchVo.setPareaLevel(Byte.valueOf((byte)1));
        List companyGradeWorkProgresses = this.companyGradeV3Service.listWorkProcess(searchVo);
        if (CollUtil.isNotEmpty((Collection)companyGradeWorkProgresses)) {
            for (CompanyGradeWorkProgress companyGradeWorkProgress : companyGradeWorkProgresses) {
                if (companyGradeWorkProgress == null) continue;
                Long areaId = companyGradeWorkProgress.getId();
                double gradeFinishRate = companyGradeWorkProgress.getGradeFinishRate();
                if (!dbYearEfficTableMap.containsKey(areaId)) continue;
                YearEfficScoreTable table = dbYearEfficTableMap.get(areaId);
                table.setGradeFinishRate(Double.valueOf(gradeFinishRate));
                if (gradeFinishRate >= 100.0) {
                    table.setGradeFinishScore(Double.valueOf(5.5));
                    continue;
                }
                table.setGradeFinishScore(Double.valueOf(0.0));
            }
        }
    }

    public void processComplianceData(Map<Long, YearEfficScoreTable> dbYearEfficTableMap) {
        List<ComplianceVisualModel> cityComplianceList = ((YearEfficScoreTableMapper)this.dao).collectComplianceProv();
        if (CollUtil.isNotEmpty(cityComplianceList)) {
            Map<Long, List<ComplianceVisualModel>> cityMap = cityComplianceList.stream().collect(Collectors.groupingBy(ComplianceVisualModel::getCityId));
            cityMap.forEach((cityId, list) -> this.cityComplianceCalcRule(dbYearEfficTableMap, (Long)cityId, (List<ComplianceVisualModel>)list));
        }
        ComplianceVisualParam complianceVisualParam = new ComplianceVisualParam();
        complianceVisualParam.setAreaLevel(Byte.valueOf((byte)3));
        List<ComplianceVisualModel> areaComplianceList = ((YearEfficScoreTableMapper)this.dao).collectCompliance(complianceVisualParam);
        if (CollUtil.isNotEmpty(areaComplianceList)) {
            for (ComplianceVisualModel complianceVisualModel : areaComplianceList) {
                Long areaId = complianceVisualModel.getAreaId();
                if (!dbYearEfficTableMap.containsKey(areaId)) continue;
                YearEfficScoreTable table = dbYearEfficTableMap.get(areaId);
                Long companyTotal = complianceVisualModel.getCompanyTotal();
                Long hgTotal = complianceVisualModel.getHgTotal();
                table.setComplianceQualifiedNum(Integer.valueOf(hgTotal.intValue()));
                if (hgTotal >= 5L) {
                    table.setComplianceQualifiedNumScore(Double.valueOf(3.0));
                } else {
                    table.setComplianceQualifiedNumScore(Double.valueOf(0.0));
                }
                BigDecimal submitRate = NumberUtil.div((Number)hgTotal, (Number)companyTotal, (int)4, (RoundingMode)RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                table.setAreaComplianceQualifiedRate(Double.valueOf(submitRate.doubleValue()));
                BigDecimal score = YearEfficScoreTableServiceImpl.areaComplianceCalcRule(submitRate);
                table.setAreaComplianceQualifiedRateScore(Double.valueOf(score.doubleValue()));
            }
        }
    }

    public void cityComplianceCalcRule(Map<Long, YearEfficScoreTable> dbYearEfficTableMap, Long cityId, List<ComplianceVisualModel> list) {
        if (dbYearEfficTableMap.containsKey(cityId)) {
            YearEfficScoreTable table = dbYearEfficTableMap.get(cityId);
            if (CollUtil.isEmpty(list)) {
                table.setComplianceQualifiedRate(Double.valueOf(0.0));
                table.setComplianceQualifiedScore(Double.valueOf(0.0));
                return;
            }
            int totalNum = list.size();
            List gt5List = list.stream().filter(f -> f != null && f.getHgTotal() != null && f.getHgTotal() >= 5L).collect(Collectors.toList());
            int htNum = gt5List.size();
            BigDecimal cityHtRate = NumberUtil.div((Number)htNum, (Number)totalNum, (int)4, (RoundingMode)RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
            table.setComplianceQualifiedRate(Double.valueOf(cityHtRate.doubleValue()));
            BigDecimal multiply = new BigDecimal("2").subtract(new BigDecimal(totalNum - htNum).multiply(new BigDecimal("0.5")));
            BigDecimal max = cn.hutool.core.util.NumberUtil.max((BigDecimal[])new BigDecimal[]{multiply, new BigDecimal("0")});
            table.setComplianceQualifiedScore(Double.valueOf(max.doubleValue()));
        }
    }

    public static BigDecimal areaComplianceCalcRule(BigDecimal div) {
        BigDecimal score = BigDecimal.ZERO;
        if (div.compareTo(new BigDecimal("50")) >= 0) {
            score = new BigDecimal("1.0");
            BigDecimal additionalCoverage = div.subtract(new BigDecimal("50"));
            BigDecimal additionalScore = additionalCoverage.divide(new BigDecimal("10"), 0, RoundingMode.DOWN).multiply(new BigDecimal("1"));
            score = score.add(additionalScore);
            score = cn.hutool.core.util.NumberUtil.min((BigDecimal[])new BigDecimal[]{score, new BigDecimal("3")});
        }
        return score;
    }

    public void processSpecialistAnswerData(Map<Long, YearEfficScoreTable> dbYearEfficTableMap) {
        List<Map<String, Object>> maps = ((YearEfficScoreTableMapper)this.dao).selectSpecialistAnswerCount();
        if (CollUtil.isNotEmpty(maps)) {
            for (Map<String, Object> map : maps) {
                Long areaId = Long.valueOf(map.get("area_id").toString());
                Double responsivity = (Double)map.get("responsivity");
                if (!dbYearEfficTableMap.containsKey(areaId)) continue;
                YearEfficScoreTable table = dbYearEfficTableMap.get(areaId);
                table.setOnlineInquiryRate(responsivity);
                if (responsivity >= 100.0) {
                    table.setOnlineInquiryScore(Double.valueOf(1.0));
                    continue;
                }
                table.setOnlineInquiryScore(Double.valueOf(0.0));
            }
        }
    }

    public void processOnlineDeviceData(Map<Long, YearEfficScoreTable> dbYearEfficTableMap) {
        List<ComplianceVisualModel> maps = ((YearEfficScoreTableMapper)this.dao).collectOnlineDevice();
        if (CollUtil.isNotEmpty(maps)) {
            for (ComplianceVisualModel data : maps) {
                Long areaId1 = data.getAreaId();
                Long hgTotal = data.getHgTotal();
                if (!dbYearEfficTableMap.containsKey(areaId1)) continue;
                YearEfficScoreTable table = dbYearEfficTableMap.get(areaId1);
                table.setOnlineDeviceCount(Integer.valueOf(0));
                table.setOnlineDeviceCountScore(Double.valueOf(0.0));
                if (hgTotal == null || hgTotal <= 0L) continue;
                table.setOnlineDeviceCount(Integer.valueOf(hgTotal.intValue()));
                table.setOnlineDeviceCountScore(Double.valueOf(1.0));
            }
        }
    }

    public void processKeyInduTrainData(Map<Long, YearEfficScoreTable> dbYearEfficTableMap) {
        List<Map<String, Object>> maps = ((YearEfficScoreTableMapper)this.dao).selectKeyInduTrain();
        if (CollUtil.isNotEmpty(maps)) {
            for (Map<String, Object> map : maps) {
                Long areaId = Long.valueOf(map.get("city_id").toString());
                Long num = Long.valueOf(map.get("num").toString());
                if (!dbYearEfficTableMap.containsKey(areaId)) continue;
                YearEfficScoreTable table = dbYearEfficTableMap.get(areaId);
                table.setKeyIndustryTrainCase(Boolean.valueOf(false));
                table.setKeyIndustryTrainScore(Double.valueOf(0.0));
                if (num <= 0L) continue;
                table.setKeyIndustryTrainCase(Boolean.valueOf(true));
                table.setKeyIndustryTrainScore(Double.valueOf(5.0));
            }
        }
    }

    public void processPatrolData(Map<Long, YearEfficScoreTable> dbYearEfficTableMap) {
        AdminPatrolStatisticsAnnualIndicatorsParam param = new AdminPatrolStatisticsAnnualIndicatorsParam();
        param.setYear(Integer.valueOf(DateUtil.getYear()));
        param.setSystemDeploymentSource(SystemDeploymentSourceEnum.NO.getCode());
        param.setAreaScope(Integer.valueOf(2));
        param.setBusinessState("1");
        List cityPatrolList = this.patrolStatisticsServiceProvider.getPatrolRateForAnnualIndicators(param);
        if (CollUtil.isNotEmpty((Collection)cityPatrolList)) {
            for (AdminPatrolStatisticsAnnualIndicatorsVo cityPatrol : cityPatrolList) {
                Long areaId = cityPatrol.getAreaId();
                String normalPatroaledCompanyRate = cityPatrol.getNormalPatroaledCompanyRate();
                if (!cn.hutool.core.util.NumberUtil.isNumber((CharSequence)(normalPatroaledCompanyRate = StringUtils.replace((String)normalPatroaledCompanyRate, (String)"%", (String)""))) || !dbYearEfficTableMap.containsKey(areaId)) continue;
                YearEfficScoreTable table = dbYearEfficTableMap.get(areaId);
                BigDecimal score = BigDecimal.ZERO;
                BigDecimal coverage = new BigDecimal(normalPatroaledCompanyRate);
                if (coverage.compareTo(new BigDecimal("80")) >= 0) {
                    score = new BigDecimal("1.0");
                }
                table.setXzxgRate(Double.valueOf(coverage.doubleValue()));
                table.setXzxgScore(Double.valueOf(score.doubleValue()));
            }
        }
        param.setAreaScope(Integer.valueOf(3));
        List areaPatrolList = this.patrolStatisticsServiceProvider.getPatrolRateForAnnualIndicators(param);
        if (CollUtil.isNotEmpty((Collection)areaPatrolList)) {
            for (AdminPatrolStatisticsAnnualIndicatorsVo cityPatrol : areaPatrolList) {
                Long areaId = cityPatrol.getAreaId();
                String normalPatroaledCompanyRate = cityPatrol.getNormalPatroaledCompanyRate();
                if (!cn.hutool.core.util.NumberUtil.isNumber((CharSequence)(normalPatroaledCompanyRate = StringUtils.replace((String)normalPatroaledCompanyRate, (String)"%", (String)"")))) continue;
                BigDecimal patroalBigDecimal = new BigDecimal(normalPatroaledCompanyRate);
                if (!dbYearEfficTableMap.containsKey(areaId)) continue;
                YearEfficScoreTable table = dbYearEfficTableMap.get(areaId);
                BigDecimal bigDecimal = YearEfficScoreTableServiceImpl.areaPatrolCalcRule(patroalBigDecimal);
                table.setXzxgRate(Double.valueOf(patroalBigDecimal.doubleValue()));
                table.setXzxgScore(Double.valueOf(bigDecimal.doubleValue()));
            }
        }
    }

    public static BigDecimal areaPatrolCalcRule(BigDecimal coverage) {
        BigDecimal score = BigDecimal.ZERO;
        if (coverage.compareTo(new BigDecimal("60")) >= 0) {
            score = new BigDecimal("1.0");
            BigDecimal additionalCoverage = coverage.subtract(new BigDecimal("60"));
            BigDecimal additionalScore = additionalCoverage.divide(new BigDecimal("10"), 0, RoundingMode.DOWN).multiply(new BigDecimal("0.5"));
            score = score.add(additionalScore);
            score = cn.hutool.core.util.NumberUtil.min((BigDecimal[])new BigDecimal[]{score, new BigDecimal("2")});
        }
        return score;
    }

    public void processRiskData(Map<Long, YearEfficScoreTable> dbYearEfficTableMap) {
        List<KeyFactoryScoreTable> keyFactoryScoreTables = ((YearEfficScoreTableMapper)this.dao).selectRiskData();
        if (CollUtil.isNotEmpty(keyFactoryScoreTables)) {
            for (KeyFactoryScoreTable keyFactoryScoreTable : keyFactoryScoreTables) {
                Long areaId = keyFactoryScoreTable.getAreaId();
                String defuseRate = keyFactoryScoreTable.getDefuseRate();
                Double defuseScore = keyFactoryScoreTable.getDefuseScore();
                double defuseRateV = NumberUtil.toDouble((String)defuseRate);
                Double detectionRate = keyFactoryScoreTable.getDetectionRate();
                Double detectionScore = keyFactoryScoreTable.getDetectionScore();
                Double physicalCheckRate = keyFactoryScoreTable.getPhysicalCheckRate();
                Double physicalCheckScore = keyFactoryScoreTable.getPhysicalCheckScore();
                if (!dbYearEfficTableMap.containsKey(areaId)) continue;
                YearEfficScoreTable table = dbYearEfficTableMap.get(areaId);
                table.setDefuseRate(Double.valueOf(defuseRateV));
                table.setDefuseScore(Double.valueOf(defuseScore == null ? 0.0 : defuseScore));
                table.setDetectionRate(Double.valueOf(detectionRate == null ? 0.0 : detectionRate));
                table.setDetectionScore(Double.valueOf(detectionScore == null ? 0.0 : detectionScore));
                table.setPhysicalCheckRate(Double.valueOf(physicalCheckRate == null ? 0.0 : physicalCheckRate));
                table.setPhysicalCheckScore(Double.valueOf(physicalCheckScore == null ? 0.0 : physicalCheckScore));
            }
        }
    }

    public static void assignTrainScores(List<CompanyTrainVo> companyTrainList) {
        Collections.sort(companyTrainList, Comparator.comparingDouble(CompanyTrainVo::getCompanyTrainRate).reversed());
        int currentScore = 11;
        double previousRate = Double.MAX_VALUE;
        for (int i = 0; i < companyTrainList.size(); ++i) {
            CompanyTrainVo companyTrainVo = companyTrainList.get(i);
            double currentRate = companyTrainVo.getCompanyTrainRate();
            if (currentRate != previousRate) {
                currentScore = 11 - i;
                previousRate = currentRate;
            }
            companyTrainVo.setScore(Integer.valueOf(currentScore));
        }
    }

    public static void main(String[] args) {
        ArrayList<CompanyTrainVo> companyTrainList = new ArrayList<CompanyTrainVo>();
        CompanyTrainVo vo1 = new CompanyTrainVo();
        vo1.setCompanyTrainRate(Double.valueOf(85.0));
        CompanyTrainVo vo2 = new CompanyTrainVo();
        vo2.setCompanyTrainRate(Double.valueOf(86.0));
        CompanyTrainVo vo3 = new CompanyTrainVo();
        vo3.setCompanyTrainRate(Double.valueOf(65.0));
        CompanyTrainVo vo4 = new CompanyTrainVo();
        vo4.setCompanyTrainRate(Double.valueOf(75.0));
        CompanyTrainVo vo5 = new CompanyTrainVo();
        vo5.setCompanyTrainRate(Double.valueOf(95.0));
        CompanyTrainVo vo6 = new CompanyTrainVo();
        vo6.setCompanyTrainRate(Double.valueOf(95.0));
        CompanyTrainVo vo7 = new CompanyTrainVo();
        vo7.setCompanyTrainRate(Double.valueOf(75.0));
        companyTrainList.add(vo1);
        companyTrainList.add(vo2);
        companyTrainList.add(vo3);
        companyTrainList.add(vo4);
        companyTrainList.add(vo5);
        companyTrainList.add(vo6);
        companyTrainList.add(vo7);
        YearEfficScoreTableServiceImpl.assignTrainScores(companyTrainList);
        System.out.println(companyTrainList);
    }

    public void processTrainRiskData(Map<Long, YearEfficScoreTable> dbYearEfficTableMap) {
        RiskResolveResSearch param = new RiskResolveResSearch();
        param.setSearchLevel(Byte.valueOf((byte)2));
        List regionCompanyTrainRateList = this.companyService.getRegionCompanyTrainRateList(param);
        if (CollUtil.isNotEmpty((Collection)regionCompanyTrainRateList)) {
            YearEfficScoreTableServiceImpl.assignTrainScores(regionCompanyTrainRateList);
            for (CompanyTrainVo companyTrainVo : regionCompanyTrainRateList) {
                Long regionId = companyTrainVo.getRegionId();
                Double companyTrainRate = companyTrainVo.getCompanyTrainRate();
                if (companyTrainRate == null || !dbYearEfficTableMap.containsKey(regionId)) continue;
                YearEfficScoreTable table = dbYearEfficTableMap.get(regionId);
                table.setTrainRate(companyTrainRate);
                table.setTrainScore(Convert.toDouble((Object)companyTrainVo.getScore()));
            }
        }
    }
}

